/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.AbstractValidationMessageAcceptor;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xtext.GrammarWithoutLeftRecursionInspector;
import org.eclipse.xtext.xtext.KeywordInspector;
import org.eclipse.xtext.xtext.OverriddenValueInspector;
import org.eclipse.xtext.xtext.PredicateUsesUnorderedGroupInspector;
import org.eclipse.xtext.xtext.RuleWithoutInstantiationInspector;
import org.eclipse.xtext.xtext.ValidEntryRuleInspector;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextValidator
extends AbstractDeclarativeValidator {
    public static final String INVALID_METAMODEL_NAME = "org.eclipse.xtext.grammar.InvalidMetaModelName";
    public static final String INVALID_ACTION_USAGE = "org.eclipse.xtext.grammar.InvalidActionUsage";
    public static final String EMPTY_ENUM_LITERAL = "org.eclipse.xtext.grammar.EmptyEnumLiteral";
    public static final String INVALID_HIDDEN_TOKEN = "org.eclipse.xtext.grammar.InvalidHiddenToken";
    public static final String INVALID_HIDDEN_TOKEN_FRAGMENT = "org.eclipse.xtext.grammar.InvalidHiddenTokenFragment";
    @Inject
    private IValueConverterService valueConverter;
    private KeywordInspector keywordHidesTerminalInspector;
    public static final String EMPTY_GENERATED_PACKAGE = "XtextValidator.checkGeneratedPackageNotEmpty";

    @Override
    protected List<EPackage> getEPackages() {
        return Collections.singletonList(XtextPackage.eINSTANCE);
    }

    @Check(value=CheckType.FAST)
    public void checkGrammarUsesMaxOneOther(Grammar grammar) {
        if (grammar.getUsedGrammars().size() > 1) {
            int i = 1;
            while (i < grammar.getUsedGrammars().size()) {
                this.error("You may not use more than one other grammar.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__USED_GRAMMARS, i);
                ++i;
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkGrammarRecursiveReference(Grammar grammar) {
        HashSet visitedGrammars = Sets.newHashSet((Object[])new Grammar[]{grammar});
        int i = 0;
        while (i < grammar.getUsedGrammars().size()) {
            Grammar usedGrammar = (Grammar)grammar.getUsedGrammars().get(i);
            if (!this.doCheckGrammarRecursiveReference(grammar, usedGrammar, i, visitedGrammars)) {
                return;
            }
            ++i;
        }
    }

    private boolean doCheckGrammarRecursiveReference(Grammar grammarToCheck, Grammar currentGrammar, int idx, Set<Grammar> visitedGrammars) {
        if (Strings.equal((String)grammarToCheck.getName(), (String)currentGrammar.getName())) {
            this.error("Invalid recursive reference of grammar.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__USED_GRAMMARS, idx);
            return false;
        }
        if (!visitedGrammars.add(currentGrammar)) {
            return true;
        }
        for (Grammar usedGrammar : currentGrammar.getUsedGrammars()) {
            if (this.doCheckGrammarRecursiveReference(grammarToCheck, usedGrammar, idx, visitedGrammars)) continue;
            return false;
        }
        return true;
    }

    @Check
    public void checkGrammarName(Grammar g) {
        String[] split = g.getName().split("\\.");
        if (split.length == 1) {
            this.warning("You should use a namespace.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
        }
        int i = 0;
        while (i < split.length - 1) {
            String nsEle = split[i];
            if (Character.isUpperCase(nsEle.charAt(0))) {
                this.warning("Namespace elements should start with a lower case letter.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
            }
            ++i;
        }
        String ele = split[split.length - 1];
        if (!Character.isUpperCase(ele.charAt(0))) {
            this.error("The last element should start with an upper case letter.", (EStructuralFeature)XtextPackage.Literals.GRAMMAR__NAME);
        }
    }

    @Check
    public void checkFirstRule(Grammar g) {
        if (g.getRules().isEmpty()) {
            return;
        }
        AbstractRule firstRule = (AbstractRule)g.getRules().get(0);
        if (!(firstRule instanceof ParserRule)) {
            if (!this.containsAnyParserRule(g, new HashSet<Grammar>())) {
                return;
            }
            this.error("The first rule must be a parser rule.", firstRule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, -1);
        } else if (GrammarUtil.isDatatypeRule((ParserRule)firstRule)) {
            if (!this.containsAnyParserRule(g, new HashSet<Grammar>())) {
                return;
            }
            this.error("The first rule must be a parser rule, but is a data type rule.", firstRule, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, -1);
        }
    }

    private boolean containsAnyParserRule(Grammar g, Set<Grammar> visited) {
        if (!visited.add(g)) {
            return false;
        }
        for (AbstractRule rule : g.getRules()) {
            if (!(rule instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)rule)) continue;
            return true;
        }
        for (Grammar used : g.getUsedGrammars()) {
            if (!this.containsAnyParserRule(used, visited)) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkGeneratedMetamodel(GeneratedMetamodel metamodel) {
        if (metamodel.getName() != null && metamodel.getName().length() != 0 && Character.isUpperCase(metamodel.getName().charAt(0))) {
            this.warning("Metamodel names should start with a lower case letter.", (EStructuralFeature)XtextPackage.Literals.GENERATED_METAMODEL__NAME, -1, INVALID_METAMODEL_NAME, metamodel.getName());
        }
    }

    @Check
    public void checkGeneratedPackage(GeneratedMetamodel metamodel) {
        Diagnostician diagnostician = (Diagnostician)this.getContext().get(EValidator.class);
        this.checkGeneratedPackage(metamodel, diagnostician, this.getContext());
    }

    public void checkGeneratedPackage(GeneratedMetamodel metamodel, Diagnostician diagnostician, Map<?, ?> params) {
        EPackage pack = metamodel.getEPackage();
        if (pack != null) {
            Diagnostic packageValidationResult = diagnostician.validate((EObject)pack, params);
            AbstractValidationMessageAcceptor filter = new AbstractValidationMessageAcceptor(){
                Set<Triple<EObject, EStructuralFeature, String>> accepted = Sets.newHashSet();

                public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptInfo(message, object, feature, index, code, issueData);
                    }
                }

                public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptWarning(message, object, feature, index, code, issueData);
                    }
                }

                public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                    if (this.accepted.add((Triple<EObject, EStructuralFeature, String>)Tuples.create((Object)object, (Object)feature, (Object)message))) {
                        XtextValidator.this.getMessageAcceptor().acceptError(message, object, feature, index, code, issueData);
                    }
                }
            };
            this.propageValidationResult(packageValidationResult, metamodel, filter);
        }
    }

    @Check
    public void checkGeneratedPackageForNameClashes(GeneratedMetamodel metamodel) {
        EPackage pack = metamodel.getEPackage();
        HashMultimap constantNameToElement = HashMultimap.create();
        HashMultimap accessorNameToElement = HashMultimap.create();
        if (pack != null) {
            for (EClassifier classifier : pack.getEClassifiers()) {
                String accessorName = classifier.getName();
                if ("Class".equals(accessorName) || "Name".equals(accessorName)) {
                    accessorName = String.valueOf(accessorName) + "_";
                }
                accessorNameToElement.put((Object)("get" + accessorName), (Object)classifier);
                String classifierConstantName = CodeGenUtil.format((String)classifier.getName(), (char)'_', null, (boolean)true, (boolean)true).toUpperCase();
                constantNameToElement.put((Object)classifierConstantName, (Object)classifier);
                if (!(classifier instanceof EClass)) continue;
                for (EStructuralFeature feature : ((EClass)classifier).getEAllStructuralFeatures()) {
                    String featureConstantPart = CodeGenUtil.format((String)feature.getName(), (char)'_', null, (boolean)false, (boolean)false).toUpperCase();
                    String featureConstantName = String.valueOf(classifierConstantName) + "__" + featureConstantPart;
                    constantNameToElement.put((Object)featureConstantName, (Object)feature);
                    String featureAccessorName = "get" + classifier.getName() + "_" + Strings.toFirstUpper((String)feature.getName());
                    accessorNameToElement.put((Object)featureAccessorName, (Object)feature);
                }
            }
        }
        this.createMessageForNameClashes((Multimap<String, ENamedElement>)constantNameToElement);
        this.createMessageForNameClashes((Multimap<String, ENamedElement>)accessorNameToElement);
    }

    @Check
    public void checkGeneratedPackageNotEmpty(GeneratedMetamodel metamodel) {
        EPackage pack = metamodel.getEPackage();
        if (pack != null && pack.getEClassifiers().isEmpty()) {
            this.getMessageAcceptor().acceptError("Generated package '" + metamodel.getName() + "' may not be empty.", (EObject)metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, -1, EMPTY_GENERATED_PACKAGE, new String[0]);
        }
    }

    public void createMessageForNameClashes(Multimap<String, ENamedElement> nameToElement) {
        for (Map.Entry entry : nameToElement.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1 || Iterables.isEmpty((Iterable)Iterables.filter((Iterable)((Iterable)entry.getValue()), EStructuralFeature.class)) || Iterables.isEmpty((Iterable)Iterables.filter((Iterable)((Iterable)entry.getValue()), EClassifier.class))) continue;
            String constantName = (String)entry.getKey();
            String message = "Name clash in generated code: '" + constantName + "'.";
            for (ENamedElement element : (Collection)entry.getValue()) {
                String myMessage = message;
                if (element.getName().indexOf(95) >= 0) {
                    myMessage = String.valueOf(myMessage) + " Try to avoid underscores in names to prevent conflicts.";
                }
                this.createMessageForSource(myMessage, null, 4, (EObject)element, this.getMessageAcceptor());
            }
        }
    }

    private void propageValidationResult(Diagnostic diagnostic, GeneratedMetamodel metamodel, ValidationMessageAcceptor acceptor) {
        if (diagnostic.getSeverity() != 0) {
            List data;
            if (diagnostic.getCode() != 0 && !(data = diagnostic.getData()).isEmpty() && data.get(0) instanceof EObject) {
                this.doPropagateValidationResult(diagnostic, metamodel, acceptor);
            }
            for (Diagnostic child : diagnostic.getChildren()) {
                this.propageValidationResult(child, metamodel, acceptor);
            }
        }
    }

    private void doPropagateValidationResult(Diagnostic diagnostic, GeneratedMetamodel metamodel, ValidationMessageAcceptor acceptor) {
        boolean foundEObject = false;
        Object firstData = null;
        for (Object data : diagnostic.getData()) {
            if (firstData == null) {
                firstData = diagnostic.getData().get(0);
            }
            if (!(data instanceof EObject)) continue;
            if (this.createMessageForSource(diagnostic, (EObject)data, acceptor)) {
                foundEObject = true;
            }
            if (!(data instanceof EStructuralFeature) || ((EStructuralFeature)data).getEContainingClass() == firstData) continue;
            EClass containingClass = ((EStructuralFeature)data).getEContainingClass();
            this.createMessageForSource(diagnostic, (EObject)containingClass, acceptor);
        }
        if (!foundEObject) {
            this.doCreateMessage(diagnostic, metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, acceptor);
        }
    }

    public boolean createMessageForSource(Diagnostic diagnostic, EObject object, ValidationMessageAcceptor acceptor) {
        String code = String.valueOf(XtextValidator.class.getName()) + ".PackageValidation." + diagnostic.getCode();
        int severity = diagnostic.getSeverity();
        if (diagnostic.getCode() == 29 || diagnostic.getCode() == 32) {
            severity = 4;
        }
        String message = diagnostic.getMessage();
        return this.createMessageForSource(message, code, severity, object, acceptor);
    }

    public void doCreateMessage(Diagnostic diagnostic, EObject object, EStructuralFeature feature, ValidationMessageAcceptor acceptor) {
        String code = String.valueOf(XtextValidator.class.getName()) + ".PackageValidation." + diagnostic.getCode();
        int severity = diagnostic.getSeverity();
        if (diagnostic.getCode() == 29 || diagnostic.getCode() == 32) {
            severity = 4;
        }
        String message = diagnostic.getMessage();
        this.doCreateMessage(message, code, severity, object, feature, acceptor);
    }

    public boolean createMessageForSource(String message, String code, int severity, EObject object, ValidationMessageAcceptor acceptor) {
        SourceAdapter sourceAdapter = SourceAdapter.find(object);
        boolean result = false;
        if (sourceAdapter != null) {
            for (EObject source : sourceAdapter.getSources()) {
                this.doCreateMessage(message, code, severity, source, null, acceptor);
                result = true;
            }
        }
        return result;
    }

    public void doCreateMessage(String message, String code, int severity, EObject context, EStructuralFeature feature, ValidationMessageAcceptor acceptor) {
        if (severity == 2) {
            acceptor.acceptWarning(message, context, feature, -1, code, new String[0]);
        } else if (severity == 4) {
            acceptor.acceptError(message, context, feature, -1, code, new String[0]);
        } else if (severity == 1) {
            acceptor.acceptInfo(message, context, feature, -1, code, new String[0]);
        }
    }

    @Check
    public void checkReferencedMetamodel(ReferencedMetamodel metamodel) throws ValueConverterException {
        if (metamodel.getEPackage() == null) {
            return;
        }
        String nsURI = metamodel.getEPackage().getNsURI();
        ArrayList allGeneratedMetamodels = new ArrayList();
        Grammar grammar = GrammarUtil.getGrammar(metamodel);
        HashSet visited = Sets.newHashSet();
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            Iterables.addAll(allGeneratedMetamodels, this.getAllGeneratedMetamodels(usedGrammar, visited));
        }
        if (allGeneratedMetamodels.isEmpty()) {
            return;
        }
        List<INode> nodes = NodeModelUtils.findNodesForFeature(metamodel, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE);
        if (nodes.size() != 1) {
            throw new IllegalArgumentException();
        }
        String text = nodes.get(0).getText();
        text = (String)this.valueConverter.toValue(text, "STRING", nodes.get(0));
        for (GeneratedMetamodel generatedMetamodel : allGeneratedMetamodels) {
            EPackage generatedPackage = generatedMetamodel.getEPackage();
            if (generatedPackage == null || !nsURI.equals(generatedPackage.getNsURI()) || text.equals(nsURI)) continue;
            this.error("Metamodels that have been generated by a super grammar must be referenced by nsURI: " + nsURI, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE);
        }
    }

    private Iterable<GeneratedMetamodel> getAllGeneratedMetamodels(Grammar grammar, Set<Grammar> visited) {
        Iterable result = Iterables.filter(grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        for (Grammar gr : grammar.getUsedGrammars()) {
            if (!visited.add(gr)) continue;
            result = Iterables.concat((Iterable)result, this.getAllGeneratedMetamodels(gr, visited));
        }
        return result;
    }

    @Check
    public void checkMetamodelUris(final AbstractMetamodelDeclaration declaration) {
        if (declaration.getEPackage() == null || declaration.getEPackage().getNsURI() == null) {
            return;
        }
        Grammar grammar = GrammarUtil.getGrammar(declaration);
        Iterable nsUris = Iterables.transform(grammar.getMetamodelDeclarations(), (Function)new Function<AbstractMetamodelDeclaration, String>(){

            public String apply(AbstractMetamodelDeclaration param) {
                if (param.getEPackage() != null) {
                    return param.getEPackage().getNsURI();
                }
                return null;
            }
        });
        int count = Iterables.size((Iterable)Iterables.filter((Iterable)nsUris, (Predicate)new Predicate<String>(){

            public boolean apply(String param) {
                return declaration.getEPackage().getNsURI().equals(param);
            }
        }));
        if (count != 1) {
            this.error("EPackage with ns-uri '" + declaration.getEPackage().getNsURI() + "' is used twice.", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE);
        }
    }

    @Check
    public void checkPackageImport(Grammar grammar) {
        HashMap nsUriToImportedMetamodel = Maps.newHashMap();
        for (AbstractMetamodelDeclaration metamodel : grammar.getMetamodelDeclarations()) {
            if (!(metamodel instanceof ReferencedMetamodel) || metamodel.getEPackage() == null || metamodel.getEPackage().eIsProxy()) continue;
            nsUriToImportedMetamodel.put(metamodel.getEPackage().getNsURI(), (ReferencedMetamodel)metamodel);
        }
        if (nsUriToImportedMetamodel.isEmpty()) {
            return;
        }
        for (AbstractMetamodelDeclaration declaration : GrammarUtil.allMetamodelDeclarations(grammar)) {
            if (declaration instanceof GeneratedMetamodel) {
                if (declaration.eContainer() == grammar) continue;
                nsUriToImportedMetamodel.remove(declaration.getEPackage().getNsURI());
                continue;
            }
            if (declaration.getEPackage() == null || declaration.getEPackage().eIsProxy()) continue;
            EPackage pack = declaration.getEPackage();
            if (declaration.eContainer() != grammar && nsUriToImportedMetamodel.containsKey(pack.getNsURI()) && ((ReferencedMetamodel)nsUriToImportedMetamodel.get(pack.getNsURI())).getEPackage() != pack) {
                String location = pack.getNsURI();
                if (pack.eResource() != null) {
                    location = pack.eResource().getURI().toString();
                }
                this.error("The package '" + pack.getNsURI() + "' was imported more than once from a different location: '" + location, (EObject)nsUriToImportedMetamodel.get(pack.getNsURI()), (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, -1);
                nsUriToImportedMetamodel.remove(pack.getNsURI());
            }
            Set<EPackage> referencedEPackages = this.findReferencedPackages(pack);
            for (EPackage referencedEPackage : referencedEPackages) {
                if (referencedEPackage.eResource() == null || !nsUriToImportedMetamodel.containsKey(referencedEPackage.getNsURI()) || ((ReferencedMetamodel)nsUriToImportedMetamodel.get(referencedEPackage.getNsURI())).getEPackage() == referencedEPackage) continue;
                this.error("The referenced package '" + referencedEPackage.getNsURI() + "' was imported from a different location. Here: '" + referencedEPackage.eResource().getURI(), (EObject)nsUriToImportedMetamodel.get(pack.getNsURI()), (EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, -1);
            }
        }
    }

    protected Set<EPackage> findReferencedPackages(EPackage pack) {
        Collection externalCrossReferences = EcoreUtil.ExternalCrossReferencer.find((EObject)pack).values();
        LinkedHashSet referencedEPackages = Sets.newLinkedHashSet();
        for (EStructuralFeature.Setting setting : Iterables.concat(externalCrossReferences)) {
            EPackage referencedPack;
            Object referenced;
            if (setting.getEStructuralFeature().isMany()) {
                referenced = (List)setting.get(true);
                Iterator iterator = referenced.iterator();
                while (iterator.hasNext()) {
                    EPackage referencedPack2;
                    Object object = iterator.next();
                    if (!(object instanceof EObject) || (referencedPack2 = EcoreUtil2.getContainerOfType((EObject)object, EPackage.class)) == null) continue;
                    if (object instanceof EDataType) {
                        if (referencedPack2 == EcorePackage.eINSTANCE) continue;
                        referencedEPackages.add(referencedPack2);
                        continue;
                    }
                    referencedEPackages.add(referencedPack2);
                }
                continue;
            }
            referenced = setting.get(true);
            if (!(referenced instanceof EObject) || (referencedPack = EcoreUtil2.getContainerOfType((EObject)referenced, EPackage.class)) == null) continue;
            if (referenced instanceof EDataType) {
                if (referencedPack == EcorePackage.eINSTANCE) continue;
                referencedEPackages.add(referencedPack);
                continue;
            }
            referencedEPackages.add(referencedPack);
        }
        return referencedEPackages;
    }

    @Check
    public void checkCrossReferenceTerminal(CrossReference reference) {
        if (reference.getTerminal() != null && reference.getTerminal() instanceof RuleCall) {
            RuleCall call = (RuleCall)reference.getTerminal();
            this.checkCrossReferenceTerminal(call);
        }
    }

    public boolean checkCrossReferenceTerminal(RuleCall call) {
        EClassifier type;
        if (call.getRule() != null && call.getRule().getType() != null && (type = call.getRule().getType().getClassifier()) != null && EcorePackage.Literals.ESTRING != type) {
            this.error("The rule '" + call.getRule().getName() + "' is not valid for a cross reference since it does not return " + "an EString. You'll have to wrap it in a data type rule.", (EObject)call, null, -1, null, new String[0]);
            return true;
        }
        return false;
    }

    @Check
    public void checkRuleName(AbstractRule rule) {
        Grammar grammar = GrammarUtil.getGrammar(rule);
        Multimap<String, AbstractRule> rules = this.getAllRules(grammar, rule.getName());
        rules.remove((Object)rule.getName(), (Object)rule);
        if (!rules.isEmpty()) {
            TreeSet names = Sets.newTreeSet((Iterable)rules.keySet());
            if (names.size() == 1) {
                String name = (String)names.first();
                if (name.equals(rule.getName())) {
                    String message = "A rule's name has to be unique.";
                    this.error("A rule's name has to be unique.", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
                    return;
                }
                String message = "A rule's name has to be unique even case insensitive.";
                boolean superGrammar = false;
                for (AbstractRule otherRule : rules.get((Object)name)) {
                    if (GrammarUtil.getGrammar(otherRule) == grammar) continue;
                    message = String.valueOf(message) + " A used grammar contains another rule '" + name + "'.";
                    superGrammar = true;
                    break;
                }
                if (!superGrammar) {
                    message = String.valueOf(message) + " This grammar contains another rule '" + name + "'.";
                }
                this.error(message, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
            } else {
                String message = "A rule's name has to be unique even case insensitive.";
                StringBuilder builder = new StringBuilder((rule.getName().length() + 4) * names.size() - 2);
                int i = 0;
                for (String name : names) {
                    if (builder.length() != 0) {
                        if (i < names.size() - 1) {
                            builder.append(", ");
                        } else {
                            builder.append(" and ");
                        }
                    }
                    ++i;
                    builder.append("'").append(name).append("'");
                }
                this.error(String.valueOf(message) + " The conflicting rules are " + builder + ".", (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME);
            }
        }
    }

    private Multimap<String, AbstractRule> getAllRules(Grammar grammar, String name) {
        ArrayListMultimap result = ArrayListMultimap.create();
        HashSet<Grammar> grammars = new HashSet<Grammar>();
        HashSet<String> validNames = new HashSet<String>();
        this.collectRules(grammar, (Multimap<String, AbstractRule>)result, grammars, name, validNames);
        return result;
    }

    private void collectRules(Grammar grammar, Multimap<String, AbstractRule> result, Set<Grammar> visited, String name, Set<String> validNames) {
        if (!visited.add(grammar)) {
            return;
        }
        ArrayList<String> allNames = new ArrayList<String>();
        for (AbstractRule rule : grammar.getRules()) {
            if (validNames.contains(rule.getName())) continue;
            allNames.add(rule.getName());
            if (!rule.getName().equalsIgnoreCase(name)) continue;
            result.put((Object)rule.getName(), (Object)rule);
        }
        validNames.addAll(allNames);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.collectRules(usedGrammar, result, visited, name, validNames);
        }
    }

    @Check
    public void checkUnassignedActionAfterAssignment(Action action) {
        if (action.getFeature() == null) {
            this.checkCurrentMustBeUnassigned(action);
        }
    }

    @Check
    public void checkUnassignedRuleCallAllowed(RuleCall call) {
        if (call.getRule() != null && !call.getRule().eIsProxy() && GrammarUtil.containingAssignment(call) == null) {
            AbstractRule container = EcoreUtil2.getContainerOfType(call, AbstractRule.class);
            if (call.getRule() instanceof ParserRule) {
                if (container instanceof TerminalRule) {
                    this.getMessageAcceptor().acceptError("Cannot call parser rule from terminal rule.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
                } else if (!GrammarUtil.isDatatypeRule((ParserRule)call.getRule())) {
                    this.checkCurrentMustBeUnassigned(call);
                }
            }
            if (call.getRule() instanceof EnumRule && container instanceof TerminalRule) {
                this.getMessageAcceptor().acceptError("Cannot call enum rule from terminal rule.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
            }
        }
    }

    @Check
    public void checkTerminalFragmentCalledFromTerminalRule(RuleCall call) {
        AbstractRule container;
        if (call.getRule() != null && !call.getRule().eIsProxy() && call.getRule() instanceof TerminalRule && ((TerminalRule)call.getRule()).isFragment() && !((container = EcoreUtil2.getContainerOfType(call, AbstractRule.class)) instanceof TerminalRule)) {
            this.getMessageAcceptor().acceptError("Only terminal rules may use terminal fragments.", (EObject)call, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
        }
    }

    private void checkCurrentMustBeUnassigned(final AbstractElement element) {
        ParserRule rule = GrammarUtil.containingParserRule(element);
        if (GrammarUtil.isDatatypeRule(rule)) {
            return;
        }
        XtextSwitch<Boolean> visitor = new XtextSwitch<Boolean>(){
            private boolean isNull = true;

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                return this.isNull;
            }

            @Override
            public Boolean caseAlternatives(Alternatives object) {
                boolean wasIsNull;
                boolean localIsNull = wasIsNull = this.isNull;
                for (AbstractElement element2 : object.getElements()) {
                    this.isNull = wasIsNull;
                    localIsNull &= ((Boolean)this.doSwitch(element2)).booleanValue();
                }
                this.isNull = localIsNull;
                return this.isNull;
            }

            @Override
            public Boolean caseUnorderedGroup(UnorderedGroup object) {
                boolean wasIsNull;
                boolean localIsNull = wasIsNull = this.isNull;
                for (AbstractElement element2 : object.getElements()) {
                    this.isNull = wasIsNull;
                    localIsNull |= ((Boolean)this.doSwitch(element2)).booleanValue();
                }
                this.isNull = localIsNull;
                return this.isNull;
            }

            @Override
            public Boolean caseAssignment(Assignment object) {
                this.isNull = false;
                return this.isNull;
            }

            @Override
            public Boolean caseGroup(Group object) {
                for (AbstractElement element2 : object.getElements()) {
                    this.doSwitch(element2);
                }
                return this.isNull;
            }

            @Override
            public Boolean caseAction(Action object) {
                if (object == element && (!this.isNull || this.isMany(object))) {
                    XtextValidator.this.error("An unassigned action is not allowed, when the 'current' was already created.", null);
                    XtextValidator.this.checkDone();
                }
                this.isNull = false;
                return this.isNull;
            }

            @Override
            public Boolean caseRuleCall(RuleCall object) {
                if (object == element && (!this.isNull || this.isMany(object))) {
                    XtextValidator.this.error("An unassigned rule call is not allowed, when the 'current' was already created.", null);
                    XtextValidator.this.checkDone();
                }
                return (Boolean)this.doSwitch(object.getRule());
            }

            @Override
            public Boolean caseParserRule(ParserRule object) {
                this.isNull = GrammarUtil.isDatatypeRule(object);
                return this.isNull;
            }

            @Override
            public Boolean caseTerminalRule(TerminalRule object) {
                this.isNull = true;
                return this.isNull;
            }

            public boolean isMany(AbstractElement element2) {
                return GrammarUtil.isMultipleCardinality(element2) || element2.eContainer() instanceof AbstractElement && this.isMany((AbstractElement)element2.eContainer());
            }
        };
        visitor.doSwitch(rule.getAlternatives());
    }

    @Check
    public void checkAssignedActionAfterAssignment(final Action action) {
        if (action.getFeature() != null) {
            ParserRule rule = GrammarUtil.containingParserRule(action);
            XtextSwitch<Boolean> visitor = new XtextSwitch<Boolean>(){
                private boolean assignedActionAllowed = false;

                @Override
                public Boolean caseAbstractElement(AbstractElement object) {
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAlternatives(Alternatives object) {
                    boolean wasActionAllowed = this.assignedActionAllowed;
                    boolean localActionAllowed = true;
                    for (AbstractElement element : object.getElements()) {
                        this.assignedActionAllowed = wasActionAllowed;
                        localActionAllowed &= ((Boolean)this.doSwitch(element)).booleanValue();
                    }
                    this.assignedActionAllowed = wasActionAllowed || localActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseUnorderedGroup(UnorderedGroup object) {
                    boolean wasActionAllowed = this.assignedActionAllowed;
                    boolean localActionAllowed = false;
                    for (AbstractElement element : object.getElements()) {
                        this.assignedActionAllowed = wasActionAllowed;
                        localActionAllowed |= ((Boolean)this.doSwitch(element)).booleanValue();
                    }
                    this.assignedActionAllowed = wasActionAllowed || localActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAssignment(Assignment object) {
                    this.assignedActionAllowed = this.assignedActionAllowed || !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseGroup(Group object) {
                    boolean wasAssignedActionAllowed = this.assignedActionAllowed;
                    for (AbstractElement element : object.getElements()) {
                        this.doSwitch(element);
                    }
                    this.assignedActionAllowed = wasAssignedActionAllowed || this.assignedActionAllowed && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseAction(Action object) {
                    if (object == action && !this.assignedActionAllowed) {
                        XtextValidator.this.error("An action is not allowed, when the current may still be unassigned.", null);
                        XtextValidator.this.checkDone();
                    }
                    this.assignedActionAllowed = true;
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseRuleCall(RuleCall object) {
                    this.assignedActionAllowed = this.assignedActionAllowed || (Boolean)this.doSwitch(object.getRule()) != false && !GrammarUtil.isOptionalCardinality(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseParserRule(ParserRule object) {
                    this.assignedActionAllowed = !GrammarUtil.isDatatypeRule(object);
                    return this.assignedActionAllowed;
                }

                @Override
                public Boolean caseTerminalRule(TerminalRule object) {
                    return this.assignedActionAllowed;
                }
            };
            visitor.doSwitch(rule.getAlternatives());
        }
    }

    @Check
    public void checkEnumLiteralIsUnique(EnumLiteralDeclaration decl) {
        EnumRule rule = GrammarUtil.containingEnumRule(decl);
        List<EnumLiteralDeclaration> declarations = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
        String literal = decl.getLiteral().getValue();
        if (literal != null) {
            for (EnumLiteralDeclaration otherDecl : declarations) {
                if (otherDecl == decl || !literal.equals(otherDecl.getLiteral().getValue())) continue;
                this.error("Enum literal '" + literal + "' is used multiple times in enum rule '" + rule.getName() + "'.", (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__LITERAL);
            }
        }
    }

    @Check
    public void checkGeneratedEnumIsValid(EnumLiteralDeclaration decl) {
        EnumRule rule = GrammarUtil.containingEnumRule(decl);
        if (!(rule.getType().getMetamodel() instanceof GeneratedMetamodel)) {
            return;
        }
        if (!(rule.getType().getClassifier() instanceof EEnum)) {
            return;
        }
        EEnum eEnum = (EEnum)rule.getType().getClassifier();
        List<EnumLiteralDeclaration> declarations = EcoreUtil2.getAllContentsOfType(rule, EnumLiteralDeclaration.class);
        if (declarations.size() == eEnum.getELiterals().size()) {
            return;
        }
        for (EnumLiteralDeclaration otherDecl : declarations) {
            if (decl == otherDecl) {
                return;
            }
            if (otherDecl.getEnumLiteral() != decl.getEnumLiteral()) continue;
            if (!decl.getEnumLiteral().getLiteral().equals(decl.getLiteral().getValue())) {
                this.warning("Enum literal '" + decl.getEnumLiteral().getName() + "' has already been defined with literal '" + decl.getEnumLiteral().getLiteral() + "'.", (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__ENUM_LITERAL);
            }
            return;
        }
    }

    @Check
    public void checkEnumLiteralIsValid(EnumLiteralDeclaration decl) {
        if ("".equals(decl.getLiteral().getValue())) {
            this.error("Enum literal must not be an empty string.", (EStructuralFeature)XtextPackage.Literals.ENUM_LITERAL_DECLARATION__LITERAL, -1, EMPTY_ENUM_LITERAL, decl.getEnumLiteral().getName());
        }
    }

    @Check
    public void checkForOverriddenValue(ParserRule rule) {
        OverriddenValueInspector inspector = new OverriddenValueInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkInstanceCreated(ParserRule rule) {
        RuleWithoutInstantiationInspector inspector = new RuleWithoutInstantiationInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkInstanceCreatedForEntryRule(ParserRule rule) {
        ValidEntryRuleInspector inspector = new ValidEntryRuleInspector(this);
        inspector.inspect(rule);
    }

    @Check
    public void checkKeywordHidesTerminalRule(Keyword keyword) {
        if (this.keywordHidesTerminalInspector == null) {
            this.keywordHidesTerminalInspector = new KeywordInspector(this);
        }
        this.keywordHidesTerminalInspector.inspectKeywordHidesTerminalRule(keyword);
    }

    @Check
    public void checkForLeftRecursion(Grammar grammar) {
        GrammarWithoutLeftRecursionInspector inspector = new GrammarWithoutLeftRecursionInspector(this);
        inspector.inspect(grammar);
    }

    @Check
    public void checkActionInUnorderedGroup(Action action) {
        if (EcoreUtil2.getContainerOfType(action, UnorderedGroup.class) != null) {
            this.error("Actions may not be used in unordered groups.", (EObject)action, null, -1, INVALID_ACTION_USAGE, new String[0]);
        }
    }

    @Check
    public void checkRuleCallInUnorderedGroup(RuleCall call) {
        if (call.getRule() == null || call.getRule().eIsProxy() || !(call.getRule() instanceof ParserRule)) {
            return;
        }
        if (GrammarUtil.isDatatypeRule((ParserRule)call.getRule())) {
            return;
        }
        if (GrammarUtil.isAssigned(call)) {
            return;
        }
        if (EcoreUtil2.getContainerOfType(call, UnorderedGroup.class) != null) {
            this.error("Unassigned rule calls may not be used in unordered groups.", (EObject)call, null, -1, null, new String[0]);
        }
    }

    @Check
    public void checkCrossReferenceType(CrossReference reference) {
        this.checkTypeIsEClass(reference.getType());
    }

    private void checkTypeIsEClass(TypeRef type) {
        EClassifier classifier;
        if (type != null && (classifier = type.getClassifier()) != null && !classifier.eIsProxy() && !(classifier instanceof EClass)) {
            this.error("Type of cross reference must be an EClass.", (EObject)type, null, -1, null, new String[0]);
        }
    }

    @Check
    public void checkInstantiatedType(Action action) {
        this.checkTypeIsEClass(action.getType());
    }

    @Check
    public void checkHiddenTokenIsNotAFragment(ParserRule rule) {
        if (rule.isDefinesHiddenTokens()) {
            this.checkHiddenTokenIsNotAFragment(rule, (List<AbstractRule>)rule.getHiddenTokens(), XtextPackage.Literals.PARSER_RULE__HIDDEN_TOKENS);
        }
    }

    @Check
    public void checkHiddenTokenIsNotAFragment(Grammar grammar) {
        if (grammar.isDefinesHiddenTokens()) {
            this.checkHiddenTokenIsNotAFragment(grammar, (List<AbstractRule>)grammar.getHiddenTokens(), XtextPackage.Literals.GRAMMAR__HIDDEN_TOKENS);
        }
    }

    protected void checkHiddenTokenIsNotAFragment(EObject owner, List<AbstractRule> hiddenTokens, EReference reference) {
        int i = 0;
        while (i < hiddenTokens.size()) {
            AbstractRule hiddenToken = hiddenTokens.get(i);
            if (hiddenToken instanceof TerminalRule) {
                if (((TerminalRule)hiddenToken).isFragment()) {
                    this.error("Cannot use terminal fragments as hidden tokens.", owner, (EStructuralFeature)reference, i, INVALID_HIDDEN_TOKEN_FRAGMENT, String.valueOf(i));
                }
            } else {
                this.error("Only terminal rules may be used as hidden tokens.", owner, (EStructuralFeature)reference, i, INVALID_HIDDEN_TOKEN, String.valueOf(i));
            }
            ++i;
        }
    }

    @Check
    public void checkUnorderedGroupIsNotPredicated(Grammar grammar) {
        PredicateUsesUnorderedGroupInspector inspector = new PredicateUsesUnorderedGroupInspector(this.getMessageAcceptor());
        inspector.inspect(grammar);
    }
}

