/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.validation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;

public class ClasspathBasedChecks
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkFileNamingConventions(XtendFile xtendFile) {
        XtendClass xtendClass;
        Resource resource = xtendFile.eResource();
        URI resourceURI = resource.getURI();
        String packageName = xtendFile.getPackage();
        StringBuilder classpathURIBuilder = new StringBuilder("classpath");
        classpathURIBuilder.append(":/");
        if (packageName != null) {
            classpathURIBuilder.append(packageName.replace(".", "/")).append("/");
        }
        classpathURIBuilder.append(resourceURI.lastSegment());
        URI classpathURI = URI.createURI((String)classpathURIBuilder.toString());
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        try {
            URI normalizedURI = uriConverter.normalize(classpathURI);
            if (!resourceURI.equals((Object)normalizedURI)) {
                this.reportInvalidPackage(packageName, classpathURI);
            }
        }
        catch (ClasspathUriResolutionException e) {
            this.reportInvalidPackage(packageName, classpathURI);
        }
        if ((xtendClass = xtendFile.getXtendClass()) != null && xtendClass.getName() != null && !Strings.equal((String)resourceURI.trimFileExtension().lastSegment(), (String)xtendClass.getName())) {
            this.error("The class '" + (packageName != null ? String.valueOf(Strings.notNull((Object)packageName)) + "." : "") + xtendClass.getName() + "' must be defined in its own file", xtendClass, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, -1, "org.eclipse.xtext.xtend2.validation.IssueCodes.wrong_file", new String[0]);
        }
    }

    protected void reportInvalidPackage(String packageName, URI classpathURI) {
        this.error("The declared package '" + Strings.notNull((Object)packageName) + "' does not match the expected package", (EStructuralFeature)Xtend2Package.Literals.XTEND_FILE__PACKAGE, -1, "org.eclipse.xtext.xtend2.validation.IssueCodes.wrong_package", new String[0]);
    }
}

