/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.linking;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.linking.BestMatchingJvmFeatureScope;
import org.eclipse.xtext.xbase.linking.FeatureCallChecker;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

public class XbaseLinkingScopeProvider
implements IScopeProvider {
    @Inject
    private IScopeProvider delegate;
    @Inject
    private Provider<FeatureCallChecker> featureCallCheckerProvider;
    @Inject
    private XbaseTypeConformanceComputer conformanceChecker;

    public IScope getScope(EObject context, EReference reference) {
        if (context == null || context.eResource() == null || context.eResource().getResourceSet() == null) {
            return IScope.NULLSCOPE;
        }
        IScope scope = this.delegate.getScope(context, reference);
        if (this.isFeatureCallScope(reference)) {
            return this.wrapFeatureCallScope(scope, context, reference);
        }
        return scope;
    }

    protected IScope wrapFeatureCallScope(IScope scope, EObject context, EReference reference) {
        FeatureCallChecker featureCallChecker = this.getFeatureCallChecker(context, reference);
        return new BestMatchingJvmFeatureScope(this.conformanceChecker, context, reference, scope, featureCallChecker);
    }

    protected boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE || reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
    }

    protected FeatureCallChecker getFeatureCallChecker(EObject context, EReference reference) {
        FeatureCallChecker predicate = (FeatureCallChecker)this.featureCallCheckerProvider.get();
        predicate.initialize(context, reference);
        return predicate;
    }
}

