/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.linking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.linking.FeatureCallChecker;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;
import org.eclipse.xtext.xbase.validation.IssueCodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestMatchingJvmFeatureScope
implements IScope {
    protected final EObject context;
    protected final EReference reference;
    private XbaseTypeConformanceComputer computer;
    private IScope delegate;
    private FeatureCallChecker featureCallChecker;

    public BestMatchingJvmFeatureScope(XbaseTypeConformanceComputer computer, EObject context, EReference ref, IScope delegate, FeatureCallChecker featureCallChecker) {
        this.computer = computer;
        this.context = context;
        this.reference = ref;
        this.delegate = delegate;
        this.featureCallChecker = featureCallChecker;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        throw new UnsupportedOperationException();
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        throw new UnsupportedOperationException();
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        Iterable unsorted = this.delegate.getElements(name);
        return this.setImplicitReceiverAndIsValid(this.getBestMatch(unsorted));
    }

    protected IEObjectDescription setImplicitReceiverAndIsValid(IEObjectDescription bestMatch) {
        if (bestMatch instanceof IValidatedEObjectDescription) {
            if (this.reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) {
                XExpression implicitReceiver;
                XAbstractFeatureCall featureCall = (XAbstractFeatureCall)this.context;
                IValidatedEObjectDescription validated = (IValidatedEObjectDescription)bestMatch;
                featureCall.setInvalidFeatureIssueCode(validated.getIssueCode());
                if (validated instanceof JvmFeatureDescription && (implicitReceiver = ((JvmFeatureDescription)validated).getImplicitReceiver()) != null) {
                    featureCall.setImplicitReceiver((XExpression)EcoreUtil2.clone((EObject)implicitReceiver));
                }
            } else if (this.reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR) {
                XConstructorCall constructorCall = (XConstructorCall)this.context;
                constructorCall.setInvalidFeatureIssueCode(((IValidatedEObjectDescription)bestMatch).getIssueCode());
            }
        }
        return bestMatch;
    }

    protected IEObjectDescription getBestMatch(Iterable<IEObjectDescription> iterable) {
        IEObjectDescription bestMatch = null;
        for (IEObjectDescription description : iterable) {
            this.featureCallChecker.check(description);
            bestMatch = bestMatch == null ? description : this.getBestMatch(bestMatch, description);
        }
        return bestMatch;
    }

    protected IEObjectDescription getBestMatch(IEObjectDescription a, IEObjectDescription b) {
        if (a instanceof IValidatedEObjectDescription && b instanceof IValidatedEObjectDescription) {
            IValidatedEObjectDescription descA = (IValidatedEObjectDescription)a;
            IValidatedEObjectDescription descB = (IValidatedEObjectDescription)b;
            if (descA.isValid()) {
                if (!descB.isValid()) {
                    return a;
                }
            } else {
                if (descB.isValid()) {
                    return b;
                }
                if (!descA.isValid() && !descB.isValid() && descA.getIssueCode() != null && descB.getIssueCode() != null) {
                    int issueCodeComparison = IssueCodes.compareIssueCodes(descA.getIssueCode(), descB.getIssueCode());
                    if (issueCodeComparison < 0) {
                        return descA;
                    }
                    if (issueCodeComparison > 0) {
                        return descB;
                    }
                }
            }
            if (a instanceof JvmFeatureDescription && b instanceof JvmFeatureDescription && descA.getEObjectOrProxy() instanceof JvmExecutable && descB.getEObjectOrProxy() instanceof JvmExecutable) {
                JvmExecutable opA = (JvmExecutable)descA.getEObjectOrProxy();
                JvmExecutable opB = (JvmExecutable)descB.getEObjectOrProxy();
                if (descA.isValid() && descB.isValid()) {
                    if (opA.isVarArgs()) {
                        if (!opB.isVarArgs()) {
                            return b;
                        }
                    } else if (opB.isVarArgs()) {
                        return a;
                    }
                }
                TypeArgumentContext contextA = ((JvmFeatureDescription)descA).getContext();
                TypeArgumentContext contextB = ((JvmFeatureDescription)descB).getContext();
                int numParamsA = opA.getParameters().size();
                int numParamsB = opB.getParameters().size();
                int i = 0;
                while (i < Math.min(numParamsA, numParamsB)) {
                    JvmTypeReference pA = ((JvmFormalParameter)opA.getParameters().get(numParamsA - i - 1)).getParameterType();
                    JvmTypeReference pB = ((JvmFormalParameter)opB.getParameters().get(numParamsB - i - 1)).getParameterType();
                    if (!this.computer.isConformant(contextB.getLowerBound(pB), contextA.getLowerBound(pA), true)) {
                        return b;
                    }
                    ++i;
                }
                return a;
            }
        }
        return a;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " -> " + this.delegate;
    }
}

