/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.linking.XbaseLazyLinker;

public class JvmModelXbaseLazyLinker
extends XbaseLazyLinker {
    @Inject
    private IJvmModelInferrer jvmModelInferrer;
    @Inject
    private IReferableElementsUnloader.GenericUnloader unloader;

    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        Resource resource = model.eResource();
        Adapter adapter = EcoreUtil.getAdapter((List)resource.eAdapters(), UnloadJvmModelAdapter.class);
        if (adapter != null) {
            resource.eAdapters().remove((Object)adapter);
        }
        this.removeInferredJvmModels(resource);
        super.beforeModelLinked(model, diagnosticsConsumer);
    }

    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        super.afterModelLinked(model, diagnosticsConsumer);
        if (model != null) {
            Resource resource = model.eResource();
            List<? extends JvmDeclaredType> jvmModel = this.jvmModelInferrer.inferJvmModel(model);
            for (EObject eObject : jvmModel) {
                eObject.eAdapters().add((Object)new JvmModelMarker());
            }
            model.eResource().getContents().addAll(jvmModel);
            resource.eAdapters().add((Object)new UnloadJvmModelAdapter());
        }
    }

    protected boolean isJvmModel(EObject element) {
        return EcoreUtil.getAdapter((List)element.eAdapters(), JvmModelMarker.class) != null;
    }

    protected void removeInferredJvmModels(Object notifier) {
        Resource resource = (Resource)notifier;
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!this.isJvmModel(object)) continue;
            this.unloader.unloadRoot(object);
            iterator.remove();
        }
    }

    protected static class JvmModelMarker
    extends AdapterImpl {
        protected JvmModelMarker() {
        }

        public boolean isAdapterForType(Object type) {
            return type == JvmModelMarker.class;
        }
    }

    protected class UnloadJvmModelAdapter
    extends EContentAdapter {
        protected UnloadJvmModelAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch() && notification.getNotifier() instanceof EObject || notification.getNotifier() instanceof Resource && notification.getFeatureID(null) == 2) {
                Object notifier = notification.getNotifier();
                if (notifier instanceof EObject) {
                    notifier = ((EObject)notifier).eResource();
                }
                if (notifier instanceof Resource) {
                    JvmModelXbaseLazyLinker.this.removeInferredJvmModels(notifier);
                }
            }
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return type == UnloadJvmModelAdapter.class;
        }

        protected boolean resolve() {
            return false;
        }
    }
}

