/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCallToJavaMapping {
    protected boolean isStaticJavaFeature(JvmIdentifiableElement feature) {
        if (feature instanceof JvmOperation) {
            return ((JvmOperation)feature).isStatic();
        }
        return false;
    }

    public XExpression getActualReceiver(XAbstractFeatureCall call) {
        return this.getActualReceiver(call, call.getFeature(), call.getImplicitReceiver());
    }

    public XExpression getActualReceiver(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver) {
        if (this.isStaticJavaFeature(feature)) {
            return null;
        }
        if (implicitReceiver != null) {
            return implicitReceiver;
        }
        EList<XExpression> allArguments = featureCall.getExplicitArguments();
        if (allArguments.isEmpty()) {
            return null;
        }
        return (XExpression)allArguments.get(0);
    }

    public List<XExpression> getActualArguments(XAbstractFeatureCall featureCall) {
        return this.getActualArguments(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
    }

    public List<XExpression> getActualArguments(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver) {
        EList<XExpression> explicitArguments = featureCall.getExplicitArguments();
        if (this.isStaticJavaFeature(feature)) {
            if (implicitReceiver == null || explicitArguments.contains(implicitReceiver)) {
                return Lists.newArrayList(explicitArguments);
            }
            ArrayList result = Lists.newArrayList((Object[])new XExpression[]{implicitReceiver});
            result.addAll(explicitArguments);
            return result;
        }
        if (implicitReceiver != null) {
            return Lists.newArrayList(explicitArguments);
        }
        if (explicitArguments.size() <= 1) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(explicitArguments.subList(1, explicitArguments.size()));
    }

    public boolean isTargetsMemberSyntaxCall(XAbstractFeatureCall featureCall) {
        return this.isTargetsMemberSyntaxCall(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
    }

    public boolean isTargetsMemberSyntaxCall(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver) {
        return !this.isStaticJavaFeature(feature);
    }
}

