/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.highlighting;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    private Map<String, String> highlightedIdentifiers;
    private BitSet idLengthsToHighlight;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null || resource.getParseResult() == null || resource.getParseResult().getRootASTElement() == null) {
            return;
        }
        if (this.highlightedIdentifiers == null) {
            this.highlightedIdentifiers = this.initializeHighlightedIdentifiers();
            this.idLengthsToHighlight = new BitSet();
            for (String s : this.highlightedIdentifiers.keySet()) {
                this.idLengthsToHighlight.set(s.length());
            }
        }
        this.doProvideHighlightingFor(resource, acceptor);
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        ICompositeNode node = resource.getParseResult().getRootNode();
        this.highlightSpecialIdentifiers(acceptor, node);
    }

    protected void highlightSpecialIdentifiers(IHighlightedPositionAcceptor acceptor, ICompositeNode root) {
        TerminalRule idRule = this.grammarAccess.getIDRule();
        for (ILeafNode leaf : root.getLeafNodes()) {
            if (leaf.isHidden()) continue;
            this.highlightSpecialIdentifiers(leaf, acceptor, idRule);
        }
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        String text;
        String highlightingID;
        EObject element;
        if (this.idLengthsToHighlight.get(leafNode.getLength()) && ((element = leafNode.getGrammarElement()) == idRule || element instanceof RuleCall && ((RuleCall)element).getRule() == idRule) && (highlightingID = this.highlightedIdentifiers.get(text = leafNode.getText())) != null) {
            acceptor.addPosition(leafNode.getOffset(), leafNode.getLength(), new String[]{highlightingID});
        }
    }

    protected Map<String, String> initializeHighlightedIdentifiers() {
        HashMap result = Maps.newHashMap();
        Primitives.Primitive[] primitiveArray = Primitives.Primitive.values();
        int n = primitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            Primitives.Primitive p = primitiveArray[n2];
            result.put(p.name().toLowerCase(), "keyword");
            ++n2;
        }
        result.put("this", "keyword");
        return result;
    }

    protected void highlightNode(INode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
            }
        }
    }
}

