/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerExtensions {
    public static int operator_minus(Integer a) {
        return -a.intValue();
    }

    public static int operator_plus(Integer a, Number b) {
        return a + b.intValue();
    }

    public static int operator_minus(Integer a, Number b) {
        return a - b.intValue();
    }

    public static int operator_multiply(Integer a, Number b) {
        return a * b.intValue();
    }

    public static int operator_divide(Integer a, Number b) {
        return a / b.intValue();
    }

    public static int operator_modulo(Integer a, Number b) {
        return a % b.intValue();
    }

    public static int operator_power(Integer a, Number b) {
        return (int)Math.pow(a.intValue(), b.intValue());
    }

    public static Iterable<Integer> operator_upTo(final Integer a, Number b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        final int upTo = b.intValue() + 1;
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new IntIterator(a, upTo);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IntIterator
    implements Iterator<Integer> {
        private int current;
        private int upTo;
        private boolean increases;

        public IntIterator(int start, int upTo) {
            this.current = start;
            this.upTo = upTo;
            this.increases = start < upTo;
        }

        @Override
        public boolean hasNext() {
            if (this.increases) {
                return this.current < this.upTo;
            }
            return this.current > this.upTo;
        }

        @Override
        public Integer next() {
            if (this.increases) {
                return this.current++;
            }
            return this.current--;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

