/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnChangeEvictingCache
implements IResourceScopeCache {
    @Override
    public void clear(Resource resource) {
        this.getOrCreate(resource).clearValues();
    }

    @Override
    public <T> T get(Object key, Resource resource, Provider<T> provider) {
        if (resource == null) {
            return (T)provider.get();
        }
        CacheAdapter adapter = this.getOrCreate(resource);
        Object element = adapter.get(key);
        if (element == null) {
            element = provider.get();
            adapter.set(key, element);
        }
        return element;
    }

    public CacheAdapter getOrCreate(Resource resource) {
        CacheAdapter adapter = (CacheAdapter)EcoreUtil.getAdapter((List)resource.eAdapters(), CacheAdapter.class);
        if (adapter == null) {
            adapter = new CacheAdapter();
            resource.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    public <Result, Param extends Resource> Result execWithoutCacheClear(Param resource, IUnitOfWork<Result, Param> transaction) throws WrappedException {
        CacheAdapter cacheAdapter = this.getOrCreate(resource);
        boolean wasIgnoreNotifications = cacheAdapter.isIgnoreNotifications();
        try {
            cacheAdapter.setIgnoreNotifications(true);
            Result Result = transaction.exec(resource);
            return Result;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            cacheAdapter.setIgnoreNotifications(wasIgnoreNotifications);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheAdapter
    extends EContentAdapter {
        private static final Object NULL = new Object();
        private Map<Object, Object> values = new ConcurrentHashMap<Object, Object>(500);
        private Collection<Listener> listeners = Sets.newHashSet();
        private volatile boolean ignoreNotifications = false;
        private volatile boolean empty = true;

        public void set(Object name, Object value) {
            this.empty = false;
            if (value != null) {
                this.values.put(name, value);
            } else {
                this.values.put(name, NULL);
            }
        }

        public <T> T get(Object name) {
            if (this.empty) {
                return null;
            }
            Object result = this.values.get(name);
            if (result != NULL) {
                return (T)result;
            }
            return null;
        }

        public void addCacheListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void removeCacheListener(Listener listener) {
            this.listeners.remove(listener);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!this.ignoreNotifications && this.isSemanticStateChange(notification)) {
                this.clearValues();
                Iterator<Listener> iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    Listener next = iter.next();
                    iter.remove();
                    next.onEvict(this);
                }
            }
        }

        public void clearValues() {
            if (!this.empty) {
                this.values.clear();
                this.empty = true;
            }
        }

        private boolean isSemanticStateChange(Notification notification) {
            return !notification.isTouch() && !(notification.getNewValue() instanceof Resource.Diagnostic);
        }

        public boolean isAdapterForType(Object type) {
            return type == ((Object)((Object)this)).getClass();
        }

        public void setIgnoreNotifications(boolean ignoreNotifications) {
            this.ignoreNotifications = ignoreNotifications;
        }

        public boolean isIgnoreNotifications() {
            return this.ignoreNotifications;
        }

        protected boolean resolve() {
            return false;
        }
    }

    public static interface Listener {
        public void onEvict(CacheAdapter var1);
    }
}

