/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.CompoundXtextEditorCallback;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.editor.XtextMarkerRulerAction;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.folding.IFoldingStructureProvider;
import org.eclipse.xtext.ui.editor.model.CommonWordIterator;
import org.eclipse.xtext.ui.editor.model.DocumentCharacterIterator;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingHelper;
import org.eclipse.xtext.ui.editor.syntaxcoloring.TextAttributeProvider;
import org.eclipse.xtext.ui.editor.toggleComments.ToggleSLCommentAction;

public class XtextEditor
extends TextEditor {
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.warning";
    private static final Logger log = Logger.getLogger(XtextEditor.class);
    public static final String ID = "org.eclipse.xtext.baseEditor";
    @Inject
    private IFoldingStructureProvider foldingStructureProvider;
    @Inject(optional=true)
    private AnnotationPainter.IDrawingStrategy projectionAnnotationDrawingStrategy;
    @Inject
    private CompoundXtextEditorCallback callback;
    @Inject
    private XtextSourceViewerConfiguration sourceViewerConfiguration;
    private IContentOutlinePage outlinePage;
    @Inject(optional=true)
    private Provider<IContentOutlinePage> outlinePageProvider;
    @Inject
    private Provider<XtextDocumentProvider> documentProvider;
    @Inject
    private XtextSourceViewer.Factory sourceViewerFactory;
    @Inject
    private IHighlightingHelper highlightingHelper;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private TextAttributeProvider textAttributeProvider;
    private ISelectionChangedListener selectionChangedListener;
    private IPropertyListener dirtyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && !XtextEditor.this.isDirty()) {
                XtextEditor.this.callback.afterSave(XtextEditor.this);
            }
        }
    };
    private String languageName;
    @Inject
    private IActionContributor.CompositeImpl actioncontributor;
    @Inject
    private ICharacterPairMatcher characterPairMatcher;
    private ProjectionSupport projectionSupport;

    public XtextEditor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Xtext Editor. Instance: [" + ((Object)((Object)this)).toString() + "]"));
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get(this.getSourceViewer());
    }

    @Inject
    public void setLanguageName(@Named(value="languageName") String name) {
        this.languageName = name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetInput:" + input));
            log.debug((Object)("Editor instance is [" + ((Object)((Object)this)).toString() + "]"));
        }
        this.removePropertyListener(this.dirtyListener);
        this.callback.beforeSetInput(this);
        super.doSetInput(input);
        this.callback.afterSetInput(this);
        this.addPropertyListener(this.dirtyListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init:" + input));
        }
        this.setDocumentProvider((IDocumentProvider)this.documentProvider.get());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.setPreferenceStore(this.preferenceStoreAccess.getContextPreferenceStore(input));
        super.init(site, input);
    }

    protected void setPreferenceStore(IPreferenceStore preferenceStore) {
        super.setPreferenceStore(preferenceStore);
        if (this.getSourceViewerConfiguration() instanceof XtextSourceViewerConfiguration) {
            XtextSourceViewerConfiguration xtextSourceViewerConfiguration = (XtextSourceViewerConfiguration)this.getSourceViewerConfiguration();
            xtextSourceViewerConfiguration.setPreferenceStore(preferenceStore);
        }
    }

    public XtextSourceViewerConfiguration getXtextSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.callback.afterSave(this);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.callback.afterSave(this);
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.callback.afterSave(this);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.xtext.ui.XtextEditorScope"});
    }

    public IResource getResource() {
        Object adapter = this.getEditorInput().getAdapter(IResource.class);
        if (adapter != null) {
            return (IResource)adapter;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.isAssignableFrom(adapter)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    private IContentOutlinePage createOutlinePage() {
        IContentOutlinePage page = null;
        if (this.outlinePageProvider != null && (page = (IContentOutlinePage)this.outlinePageProvider.get()) != null) {
            if (page instanceof ISourceViewerAware) {
                ((ISourceViewerAware)page).setSourceViewer(this.getSourceViewer());
            }
            if (page instanceof IXtextEditorAware) {
                ((IXtextEditorAware)page).setEditor(this);
            }
        }
        return page;
    }

    public void outlinePageClosed() {
        if (this.outlinePage != null) {
            this.outlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void createActions() {
        ToggleSLCommentAction action;
        super.createActions();
        if (this.getSourceViewerConfiguration().getContentFormatter(this.getSourceViewer()) != null) {
            action = new TextOperationAction(XtextUIMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
            action.setActionDefinitionId("org.eclipse.xtext.ui.FormatAction");
            this.setAction("Format", (IAction)action);
            this.markAsStateDependentAction("Format", true);
            this.markAsSelectionDependentAction("Format", true);
        }
        action = new ToggleSLCommentAction(XtextUIMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.xtext.ui.ToggleCommentAction");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.markAsSelectionDependentAction("ToggleComment", true);
        this.configureToggleCommentAction(action);
        XtextMarkerRulerAction markerAction = new XtextMarkerRulerAction(XtextUIMessages.getResourceBundle(), "XtextSelectAnnotationRulerAction.", this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)markerAction);
        this.actioncontributor.contributeActions(this);
    }

    protected void configureToggleCommentAction(ToggleSLCommentAction action) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        action.configure(sourceViewer, configuration);
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext undoContext) {
        final IOperationApprover result = super.getUndoRedoOperationApprover(undoContext);
        return new IOperationApprover(){

            public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus status = result.proceedRedoing(operation, history, info);
                return this.validateEditorInputState(info, status);
            }

            public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus status = result.proceedUndoing(operation, history, info);
                return this.validateEditorInputState(info, status);
            }

            protected IStatus validateEditorInputState(IAdaptable info, IStatus status) {
                if (Status.OK_STATUS.equals(status) && info != null && info.getAdapter(ITextEditor.class) == XtextEditor.this && !XtextEditor.this.validateEditorInputState()) {
                    return Status.CANCEL_STATUS;
                }
                return status;
            }
        };
    }

    public boolean isContentAssistAvailable() {
        boolean result = this.getSourceViewer().getTextOperationTarget().canDoOperation(13);
        return result;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Xtext source viewer.");
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        XtextSourceViewer projectionViewer = this.sourceViewerFactory.createSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        return projectionViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        if (this.characterPairMatcher != null) {
            support.setCharacterPairMatcher(this.characterPairMatcher);
            support.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = this.installProjectionSupport(projectionViewer);
        this.installFoldingSupport(projectionViewer);
        this.installHighlightingHelper();
        this.installSelectionChangedListener();
        this.callback.afterCreatePartControl(this);
    }

    protected ProjectionSupport installProjectionSupport(ProjectionViewer projectionViewer) {
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType(WARNING_ANNOTATION_TYPE);
        projectionSupport.addSummarizableAnnotationType(ERROR_ANNOTATION_TYPE);
        projectionSupport.setAnnotationPainterDrawingStrategy(this.projectionAnnotationDrawingStrategy);
        projectionSupport.install();
        return projectionSupport;
    }

    protected void installFoldingSupport(ProjectionViewer projectionViewer) {
        this.foldingStructureProvider.install(this, projectionViewer);
        projectionViewer.doOperation(19);
    }

    private void installSelectionChangedListener() {
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XtextEditor.this.updateStatusLine();
            }
        };
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
            postSelectionProvider.addPostSelectionChangedListener(this.selectionChangedListener);
        } else {
            this.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        }
    }

    private void installHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.install(this, (XtextSourceViewer)this.getSourceViewer());
        }
    }

    private void uninstallHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.uninstall();
        }
    }

    public void dispose() {
        this.callback.beforeDispose(this);
        this.actioncontributor.editorDisposed(this);
        super.dispose();
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage = null;
        }
        this.uninstallFoldingSupport();
        this.uninstallHighlightingHelper();
        this.uninstallSelectionChangedListener();
    }

    protected void uninstallFoldingSupport() {
        if (this.foldingStructureProvider != null) {
            this.foldingStructureProvider.uninstall();
            this.foldingStructureProvider = null;
        }
    }

    private void uninstallSelectionChangedListener() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
                postSelectionProvider.removePostSelectionChangedListener(this.selectionChangedListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
        }
    }

    public ISourceViewer getInternalSourceViewer() {
        return this.getSourceViewer();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.getSourceViewer() == null) {
            return;
        }
        boolean tokenStyleChanged = event.getProperty().contains(".syntaxColorer.tokenStyles");
        if (tokenStyleChanged) {
            this.textAttributeProvider.propertyChange(event);
            this.initializeViewerColors(this.getSourceViewer());
            this.getSourceViewer().invalidateTextPresentation();
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 4];
        more[0] = String.valueOf(this.getLanguageName()) + ".editor";
        more[1] = this.getLanguageName();
        more[2] = String.valueOf(this.getLanguageName()) + ".templates";
        more[3] = String.valueOf(this.getLanguageName()) + ".coloring";
        System.arraycopy(ids, 0, more, 4, ids.length);
        return more;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }
        };
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        String message = null;
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (this.isProblemMarkerAnnotation(annotation)) {
                message = annotation.getText();
            }
        }
        this.setStatusLineMessage(message);
    }

    public boolean validateEditorInputState() {
        return this.callback.onValidateEditorInputState(this) && super.validateEditorInputState();
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public Image getDefaultImage() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
        return imageDesc != null ? imageDesc.createImage() : super.getDefaultImage();
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(XtextUIMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
    }

    public void resetProjection() {
        if (this.foldingStructureProvider != null) {
            this.foldingStructureProvider.initialize();
        }
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator iterator = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation a = (Annotation)iterator.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    private boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public void setXtextEditorCallback(CompoundXtextEditorCallback callback) {
        this.callback = callback;
    }

    public void reveal(int offset, int length) {
        if (this.getSourceViewer() == null) {
            return;
        }
        StyledText widget = this.getSourceViewer().getTextWidget();
        widget.setRedraw(false);
        this.adjustHighlightRange(offset, length);
        this.getSourceViewer().revealRange(offset, length);
        this.markInNavigationHistory();
        widget.setRedraw(true);
    }

    protected CommonWordIterator createWordIterator() {
        return new CommonWordIterator(true);
    }

    protected DeleteNextSubWordAction createDeleteNextSubWordAction() {
        return new DeleteNextSubWordAction();
    }

    protected DeletePreviousSubWordAction createDeletePreviousSubWordAction() {
        return new DeletePreviousSubWordAction();
    }

    protected SelectNextSubWordAction createSelectNextSubWordAction() {
        return new SelectNextSubWordAction();
    }

    protected SelectPreviousSubWordAction createSelectPreviousSubWordAction() {
        return new SelectPreviousSubWordAction();
    }

    protected NavigateNextSubWordAction createNavigateNextSubWordAction() {
        return new NavigateNextSubWordAction();
    }

    protected NavigatePreviousSubWordAction createNavigatePreviousSubWordAction() {
        return new NavigatePreviousSubWordAction();
    }

    protected SmartLineStartAction createSmartLineStartAction(StyledText textWidget, boolean doSelect) {
        return new SmartLineStartAction(textWidget, doSelect);
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = this.createSmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = this.createSmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = this.createNavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = this.createNavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = this.createSelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = this.createSelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
        action = this.createDeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = this.createDeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        protected void setCaretPosition(int position) {
            if (!XtextEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (XtextEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = XtextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void update() {
            this.setEnabled(XtextEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        protected void setCaretPosition(int position) {
            if (!XtextEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (XtextEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = XtextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void update() {
            this.setEnabled(XtextEditor.this.isEditorInputModifiable());
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(XtextEditor.modelOffset2WidgetOffset((ISourceViewer)XtextEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(XtextEditor.modelOffset2WidgetOffset((ISourceViewer)XtextEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected CommonWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(XtextEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = XtextEditor.this.createWordIterator();
        }

        public void run() {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = XtextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (XtextEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if ((next = this.fIterator.following(next)) == -1) continue;
                widget = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected CommonWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(XtextEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = XtextEditor.this.createWordIterator();
        }

        public void run() {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = XtextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (XtextEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.fIterator.preceding(previous)) == -1) continue;
                widget = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = XtextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = XtextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)XtextEditor.this, textWidget, doSelect);
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            int index;
            block8: {
                String type;
                block6: {
                    block7: {
                        type = "__dftl_partition_content_type";
                        try {
                            type = TextUtilities.getContentType((IDocument)document, (String)"__dftl_partitioning", (int)offset, (boolean)false);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        index = super.getLineStartPosition(document, line, length, offset);
                        if (!type.equals("__comment") && !type.equals("__sl_comment")) break block6;
                        if (index >= length - 1 || line.charAt(index) != '*' || line.charAt(index + 1) == '/') break block7;
                        while (++index < length && Character.isWhitespace(line.charAt(index))) {
                        }
                        break block8;
                    }
                    if (index >= length - 1 || line.charAt(index) != '/' || line.charAt(index + 1) != '/' && line.charAt(index + 1) != '*') break block8;
                    ++index;
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                    break block8;
                }
                if (type.equals("__dftl_partition_content_type") && index < length - 1 && line.charAt(index) == '/' && (line.charAt(index + 1) == '/' || line.charAt(index + 1) == '*')) {
                    ++index;
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                }
            }
            return index;
        }
    }
}

