/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.junit.util;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.util.StringInputStream;

public class IResourcesSetupUtil {
    public static IWorkspaceRoot root() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IProject createProject(String name) throws CoreException, InvocationTargetException, InterruptedException {
        IProject project = IResourcesSetupUtil.root().getProject(name);
        IResourcesSetupUtil.createProject(project);
        return project;
    }

    public static IProject createProject(IProject project) throws CoreException {
        if (!project.exists()) {
            project.create(IResourcesSetupUtil.monitor());
        }
        project.open(IResourcesSetupUtil.monitor());
        return project;
    }

    public static void addNature(IProject project, String nature) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static void removeNature(IProject project, String nature) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (nature.equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public static void setReference(final IProject from, final IProject to) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription projectDescription = from.getDescription();
                IProject[] projects = projectDescription.getReferencedProjects();
                IProject[] newProjects = new IProject[projects.length + 1];
                System.arraycopy(projects, 0, newProjects, 0, projects.length);
                newProjects[projects.length] = to;
                projectDescription.setReferencedProjects(newProjects);
                from.setDescription(projectDescription, IResourcesSetupUtil.monitor());
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static void removeReference(final IProject from, final IProject to) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IProjectDescription projectDescription = from.getDescription();
                IProject[] projects = projectDescription.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (to.equals((Object)projects[i])) {
                        IProject[] newProjects = new IProject[projects.length - 1];
                        System.arraycopy(projects, 0, newProjects, 0, i);
                        System.arraycopy(projects, i + 1, newProjects, i, projects.length - i - 1);
                        projectDescription.setReferencedProjects(newProjects);
                        from.setDescription(projectDescription, null);
                        return;
                    }
                    ++i;
                }
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static IFolder createFolder(String wsRelativePath) throws InvocationTargetException, InterruptedException {
        return IResourcesSetupUtil.createFolder((IPath)new Path(wsRelativePath));
    }

    public static IFolder createFolder(IPath wsRelativePath) throws InvocationTargetException, InterruptedException {
        final IFolder folder = IResourcesSetupUtil.root().getFolder(wsRelativePath);
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IResourcesSetupUtil.create(folder.getParent());
                folder.delete(true, IResourcesSetupUtil.monitor());
                folder.create(true, true, IResourcesSetupUtil.monitor());
            }
        }.run(IResourcesSetupUtil.monitor());
        return folder;
    }

    public static IFile createFile(String wsRelativePath, String s) throws CoreException, InvocationTargetException, InterruptedException {
        return IResourcesSetupUtil.createFile((IPath)new Path(wsRelativePath), s);
    }

    public static IFile createFile(IPath wsRelativePath, final String s) throws CoreException, InvocationTargetException, InterruptedException {
        final IFile file = IResourcesSetupUtil.root().getFile(wsRelativePath);
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IResourcesSetupUtil.create(file.getParent());
                file.delete(true, IResourcesSetupUtil.monitor());
                file.create((InputStream)new StringInputStream(s), true, IResourcesSetupUtil.monitor());
            }
        }.run(IResourcesSetupUtil.monitor());
        return file;
    }

    public static IResource file(String path) {
        return IResourcesSetupUtil.root().findMember((IPath)new Path(path));
    }

    private static void create(final IContainer container) throws CoreException, InvocationTargetException, InterruptedException {
        new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (!container.exists()) {
                    IResourcesSetupUtil.create(container.getParent());
                    if (container instanceof IFolder) {
                        ((IFolder)container).create(true, true, IResourcesSetupUtil.monitor());
                    } else {
                        IProject iProject = (IProject)container;
                        IResourcesSetupUtil.createProject(iProject);
                    }
                }
            }
        }.run(IResourcesSetupUtil.monitor());
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }

    public static void fullBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, IResourcesSetupUtil.monitor());
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void cleanWorkspace() throws CoreException {
        IProject[] visibleProjects = IResourcesSetupUtil.root().getProjects();
        IResourcesSetupUtil.deleteProjects(visibleProjects);
        IProject[] hiddenProjects = IResourcesSetupUtil.root().getProjects(8);
        IResourcesSetupUtil.deleteProjects(hiddenProjects);
    }

    protected static void deleteProjects(IProject[] projects) throws CoreException {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.exists()) {
                iProject.delete(true, true, IResourcesSetupUtil.monitor());
            }
            ++n2;
        }
    }

    public static String printMarker(IMarker[] markers) throws CoreException {
        String s = "";
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            s = String.valueOf(s) + "," + iMarker.getAttribute("message");
            ++n2;
        }
        return s;
    }
}

