/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class JavaFileAccess
extends TextFileAccess {
    public static final Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"}));
    public static final int DONT_IMPORT_NESTED_TYPES = Integer.MAX_VALUE;
    protected final Map<String, String> imports = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    protected final TypeReference javaType;
    protected final CodeConfig codeConfig;
    @Accessors
    private int importNestedTypeThreshold = 8;
    @Accessors
    private boolean markedAsGenerated;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private ResourceSet resourceSet;

    protected JavaFileAccess(TypeReference typeRef, CodeConfig codeConfig) {
        boolean _greaterThan;
        List<String> _simpleNames = typeRef.getSimpleNames();
        int _length = ((Object[])Conversions.unwrapArray(_simpleNames, Object.class)).length;
        boolean bl = _greaterThan = _length > 1;
        if (_greaterThan) {
            throw new IllegalArgumentException("Nested type cannot be serialized: " + typeRef);
        }
        this.javaType = typeRef;
        this.codeConfig = codeConfig;
        String _path = typeRef.getPath();
        String _plus = String.valueOf(_path) + ".";
        String _fileExtension = this.getFileExtension();
        String _plus_1 = String.valueOf(_plus) + _fileExtension;
        this.setPath(_plus_1);
    }

    protected String getFileExtension() {
        return "java";
    }

    public String importType(TypeReference typeRef) {
        List<String> simpleNames = typeRef.getSimpleNames();
        String usableName = null;
        boolean _or = false;
        String _packageName = typeRef.getPackageName();
        boolean _equals = Objects.equal((Object)_packageName, (Object)"java.lang");
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            String _packageName_1 = typeRef.getPackageName();
            String _packageName_2 = this.javaType.getPackageName();
            _or = _equals_1 = Objects.equal((Object)_packageName_1, (Object)_packageName_2);
        }
        if (_or) {
            String _join;
            usableName = _join = IterableExtensions.join(simpleNames, (CharSequence)".");
        } else {
            boolean found = false;
            int i = ((Object[])Conversions.unwrapArray(simpleNames, Object.class)).length - 1;
            while (i >= 0 && !found) {
                boolean _not;
                String simpleName = simpleNames.get(i);
                usableName = usableName == null ? simpleName : String.valueOf(simpleName) + "." + usableName;
                boolean _and = false;
                boolean _isJavaDefaultType = CodeGenUtil.isJavaDefaultType((String)simpleName);
                boolean bl = _not = !_isJavaDefaultType;
                if (!_not) {
                    _and = false;
                } else {
                    boolean _not_1;
                    int _length;
                    boolean _lessEqualsThan;
                    boolean _and_1 = false;
                    _and_1 = i <= 0 ? false : (_lessEqualsThan = (_length = simpleName.length()) <= this.importNestedTypeThreshold);
                    _and = _not_1 = !_and_1;
                }
                if (_and) {
                    String _packageName_3 = typeRef.getPackageName();
                    String _plus = String.valueOf(_packageName_3) + ".";
                    List<String> _subList = simpleNames.subList(0, i + 1);
                    String _join_1 = IterableExtensions.join(_subList, (CharSequence)".");
                    String importable = String.valueOf(_plus) + _join_1;
                    String imported = this.imports.get(usableName);
                    if (imported == null) {
                        this.imports.put(usableName, importable);
                        found = true;
                    } else {
                        boolean _equals_2 = Objects.equal((Object)imported, (Object)importable);
                        if (_equals_2) {
                            found = true;
                        }
                    }
                }
                --i;
            }
            if (!found) {
                String _name;
                usableName = _name = typeRef.getName();
            }
        }
        List<TypeReference> _typeArguments = typeRef.getTypeArguments();
        Functions.Function1<TypeReference, CharSequence> _function = new Functions.Function1<TypeReference, CharSequence>(){

            public CharSequence apply(TypeReference it) {
                return JavaFileAccess.this.importType(it);
            }
        };
        String _join_1 = IterableExtensions.join(_typeArguments, (CharSequence)"<", (CharSequence)", ", (CharSequence)">", (Functions.Function1)_function);
        return String.valueOf(usableName) + _join_1;
    }

    @Override
    public void setContent(StringConcatenationClient javaContent) {
        JavaTypeAwareStringConcatenation javaStringConcat = new JavaTypeAwareStringConcatenation(this);
        javaStringConcat.append(javaContent);
        this.internalContents = javaStringConcat;
    }

    protected boolean appendSemicolons() {
        return true;
    }

    @Override
    public CharSequence getContent() {
        StringConcatenation _builder = new StringConcatenation();
        String _fileHeader = this.codeConfig.getFileHeader();
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        String _packageName = this.javaType.getPackageName();
        _builder.append((Object)_packageName, "");
        boolean _appendSemicolons = this.appendSemicolons();
        if (_appendSemicolons) {
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Collection<String> _values = this.imports.values();
        Set _set = IterableExtensions.toSet(_values);
        List _sort = IterableExtensions.sort((Iterable)_set);
        for (String importName : _sort) {
            _builder.append((Object)"import ");
            _builder.append((Object)importName, "");
            boolean _appendSemicolons_1 = this.appendSemicolons();
            if (_appendSemicolons_1) {
                _builder.append((Object)";");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _internalContent = this.getInternalContent();
        _builder.append((Object)_internalContent, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence getInternalContent() {
        return this.internalContents;
    }

    @Pure
    public int getImportNestedTypeThreshold() {
        return this.importNestedTypeThreshold;
    }

    public void setImportNestedTypeThreshold(int importNestedTypeThreshold) {
        this.importNestedTypeThreshold = importNestedTypeThreshold;
    }

    @Pure
    public boolean isMarkedAsGenerated() {
        return this.markedAsGenerated;
    }

    public void setMarkedAsGenerated(boolean markedAsGenerated) {
        this.markedAsGenerated = markedAsGenerated;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    protected static class JavaTypeAwareStringConcatenation
    extends StringConcatenation {
        private final JavaFileAccess access;

        public JavaTypeAwareStringConcatenation(JavaFileAccess access) {
            super(access.codeConfig.getLineDelimiter());
            this.access = access;
        }

        public String getStringRepresentation(Object object) {
            String _xifexpression = null;
            if (object instanceof TypeReference) {
                _xifexpression = this.access.importType((TypeReference)object);
            } else {
                String _xifexpression_1 = null;
                if (object instanceof Class) {
                    TypeReference _typeReference = new TypeReference((Class)object);
                    _xifexpression_1 = this.access.importType(_typeReference);
                } else {
                    String _xifexpression_2 = null;
                    boolean _and = false;
                    if (!(object instanceof EClass)) {
                        _and = false;
                    } else {
                        boolean bl = _and = this.access.resourceSet != null;
                    }
                    if (_and) {
                        TypeReference _typeReference_1 = new TypeReference((EClass)object, this.access.resourceSet);
                        _xifexpression_2 = this.access.importType(_typeReference_1);
                    } else {
                        String _xifexpression_3 = null;
                        boolean _and_1 = false;
                        if (!(object instanceof EPackage)) {
                            _and_1 = false;
                        } else {
                            boolean bl = _and_1 = this.access.resourceSet != null;
                        }
                        if (_and_1) {
                            TypeReference _typeReference_2 = new TypeReference((EPackage)object, this.access.resourceSet);
                            _xifexpression_3 = this.access.importType(_typeReference_2);
                        } else {
                            _xifexpression_3 = object.toString();
                        }
                        _xifexpression_2 = _xifexpression_3;
                    }
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        }
    }
}

