/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.ecore;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenPackageImpl;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe2.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.StandaloneSetupAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

@Log
public class EMFGeneratorFragment2
extends AbstractXtextGeneratorFragment {
    @Inject
    private CodeConfig codeConfig;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String basePackage;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String modelPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String javaModelDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateEdit = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateEditor = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editorPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editorDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String genModel;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean skipGenerate = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean updateBuildProperties = true;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean longFileNames = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean suppressLoadInitialization = false;
    private GenRuntimeVersion emfRuntimeVersion;
    private GenJDKLevel jdkLevel = GenJDKLevel.JDK60_LITERAL;
    private static final Logger LOG = Logger.getLogger(EMFGeneratorFragment2.class);

    public void setEmfRuntimeVersion(String emfRuntimeVersion) {
        GenRuntimeVersion _get;
        this.emfRuntimeVersion = _get = GenRuntimeVersion.get((String)emfRuntimeVersion);
        if (this.emfRuntimeVersion == null) {
            LOG.warn((Object)("Illegal EMF runtime version: " + emfRuntimeVersion));
        }
    }

    public void setJdkLevel(String jdkLevel) {
        GenJDKLevel _byName;
        this.jdkLevel = _byName = GenJDKLevel.getByName((String)jdkLevel);
        if (this.jdkLevel == null) {
            LOG.warn((Object)("Illegal JDK level: " + jdkLevel));
        }
    }

    protected String getModelPluginID() {
        String _elvis = null;
        if (this.modelPluginID != null) {
            _elvis = this.modelPluginID;
        } else {
            String _name;
            IXtextProjectConfig _projectConfig = this.getProjectConfig();
            IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
            _elvis = _name = _runtime.getName();
        }
        return _elvis;
    }

    protected String getJavaModelDirectory() {
        boolean _startsWith;
        if (this.javaModelDirectory != null) {
            return this.javaModelDirectory;
        }
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _srcGen = _runtime.getSrcGen();
        String srcGenPath = _srcGen.getPath();
        IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
        IRuntimeProjectConfig _runtime_1 = _projectConfig_1.getRuntime();
        IXtextGeneratorFileSystemAccess _root = _runtime_1.getRoot();
        String rootPath = _root.getPath();
        boolean _and = false;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)rootPath);
        boolean _not = !_isNullOrEmpty;
        _and = !_not ? false : (_startsWith = srcGenPath.startsWith(rootPath));
        if (_and) {
            String _modelPluginID = this.getModelPluginID();
            String _plus = "/" + _modelPluginID;
            int _length = rootPath.length();
            String _substring = srcGenPath.substring(_length);
            return String.valueOf(_plus) + _substring;
        }
        throw new RuntimeException("Could not derive the Java model directory from the project configuration. Please set the property 'javaModelDirectory' explicitly.");
    }

    protected String getModelName(Grammar grammar) {
        String _xifexpression = null;
        if (this.longFileNames) {
            String _name = grammar.getName();
            _xifexpression = _name.replace(".", "_");
        } else {
            _xifexpression = GrammarUtil.getSimpleName((Grammar)grammar);
        }
        return _xifexpression;
    }

    protected String getEcoreFilePath(Grammar grammar) {
        String _xblockexpression = null;
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        String ecoreModelFolder = _runtime.getEcoreModelFolder();
        String _modelPluginID = this.getModelPluginID();
        String _plus = "/" + _modelPluginID;
        String _plus_1 = String.valueOf(_plus) + "/";
        String _plus_2 = String.valueOf(_plus_1) + ecoreModelFolder;
        String _plus_3 = String.valueOf(_plus_2) + "/";
        String _modelName = this.getModelName(grammar);
        String _plus_4 = String.valueOf(_plus_3) + _modelName;
        _xblockexpression = String.valueOf(_plus_4) + ".ecore";
        return _xblockexpression;
    }

    protected URI getEcoreFileUri(Grammar grammar) {
        String _ecoreFilePath = this.getEcoreFilePath(grammar);
        return URI.createPlatformResourceURI((String)_ecoreFilePath, (boolean)true);
    }

    protected String getGenModelPath(Grammar grammar) {
        String _elvis = null;
        if (this.genModel != null) {
            _elvis = this.genModel;
        } else {
            String _xblockexpression = null;
            IXtextProjectConfig _projectConfig = this.getProjectConfig();
            IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
            String ecoreModelFolder = _runtime.getEcoreModelFolder();
            String _modelPluginID = this.getModelPluginID();
            String _plus = "/" + _modelPluginID;
            String _plus_1 = String.valueOf(_plus) + "/";
            String _plus_2 = String.valueOf(_plus_1) + ecoreModelFolder;
            String _plus_3 = String.valueOf(_plus_2) + "/";
            String _modelName = this.getModelName(grammar);
            String _plus_4 = String.valueOf(_plus_3) + _modelName;
            _elvis = _xblockexpression = String.valueOf(_plus_4) + ".genmodel";
        }
        return _elvis;
    }

    protected URI getGenModelUri(Grammar grammar) {
        String _genModelPath = this.getGenModelPath(grammar);
        return URI.createPlatformResourceURI((String)_genModelPath, (boolean)true);
    }

    protected String getRelativePath(String pathInRoot) {
        String _xblockexpression = null;
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        String _name = _runtime.getName();
        String projectPath = "/" + _name;
        String _xifexpression = null;
        boolean _startsWith = pathInRoot.startsWith(projectPath);
        if (_startsWith) {
            int _length = projectPath.length();
            int _plus = _length + 1;
            _xifexpression = pathInRoot.substring(_plus);
        } else {
            _xifexpression = pathInRoot;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String getEditPluginID() {
        String _elvis = null;
        if (this.editPluginID != null) {
            _elvis = this.editPluginID;
        } else {
            String _plus;
            String _modelPluginID = this.getModelPluginID();
            _elvis = _plus = String.valueOf(_modelPluginID) + ".edit";
        }
        return _elvis;
    }

    protected String getEditDirectory() {
        String _elvis = null;
        if (this.editDirectory != null) {
            _elvis = this.editDirectory;
        } else {
            String _plus_1;
            String _editPluginID = this.getEditPluginID();
            String _plus = "/" + _editPluginID;
            _elvis = _plus_1 = String.valueOf(_plus) + "/src";
        }
        return _elvis;
    }

    protected String getEditorPluginID() {
        String _elvis = null;
        if (this.editorPluginID != null) {
            _elvis = this.editorPluginID;
        } else {
            String _plus;
            String _modelPluginID = this.getModelPluginID();
            _elvis = _plus = String.valueOf(_modelPluginID) + ".editor";
        }
        return _elvis;
    }

    protected String getEditorDirectory() {
        String _elvis = null;
        if (this.editorDirectory != null) {
            _elvis = this.editorDirectory;
        } else {
            String _plus;
            String _editorPluginID = this.getEditorPluginID();
            _elvis = _plus = String.valueOf(_editorPluginID) + "/src";
        }
        return _elvis;
    }

    protected String getBasePackage(Grammar grammar) {
        String _namespace;
        String _elvis = null;
        _elvis = this.basePackage != null ? this.basePackage : (_namespace = GrammarUtil.getNamespace((Grammar)grammar));
        return _elvis;
    }

    @Override
    public void initialize(Injector injector) {
        boolean _not;
        super.initialize(injector);
        Map _extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        boolean _containsKey = _extensionToFactoryMap.containsKey("genmodel");
        boolean bl = _not = !_containsKey;
        if (_not) {
            Map _extensionToFactoryMap_1 = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
            EcoreResourceFactoryImpl _ecoreResourceFactoryImpl = new EcoreResourceFactoryImpl();
            _extensionToFactoryMap_1.put("genmodel", _ecoreResourceFactoryImpl);
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
    }

    @Override
    public void generate() {
        Grammar _grammar = this.getGrammar();
        EList _metamodelDeclarations = _grammar.getMetamodelDeclarations();
        Iterable _filter = Iterables.filter((Iterable)_metamodelDeclarations, GeneratedMetamodel.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        if (_isEmpty) {
            return;
        }
        try {
            boolean _isEmpty_1;
            boolean _not;
            Grammar _grammar_1 = this.getGrammar();
            Grammar clonedGrammar = this.cloneGrammarIntoNewResourceSet(_grammar_1);
            Resource _eResource = clonedGrammar.eResource();
            ResourceSet workingResourceSet = _eResource.getResourceSet();
            EList _metamodelDeclarations_1 = clonedGrammar.getMetamodelDeclarations();
            Iterable _filter_1 = Iterables.filter((Iterable)_metamodelDeclarations_1, GeneratedMetamodel.class);
            Functions.Function1<GeneratedMetamodel, EPackage> _function = new Functions.Function1<GeneratedMetamodel, EPackage>(){

                public EPackage apply(GeneratedMetamodel it) {
                    return it.getEPackage();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function);
            List generatedPackages = IterableExtensions.toList((Iterable)_map);
            if (this.genModel != null) {
                URIConverter _uRIConverter = workingResourceSet.getURIConverter();
                this.registerUsedGenModel(_uRIConverter, clonedGrammar);
            }
            boolean bl = _not = !(_isEmpty_1 = generatedPackages.isEmpty());
            if (_not) {
                Map<String, EPackage> usedEPackages = this.findAllUsedEPackages(generatedPackages);
                Set<String> _keySet = usedEPackages.keySet();
                Map<String, EPackage> loadedEPackages = this.findEPackagesInGenPackages(_keySet, workingResourceSet);
                Map<EObject, EObject> eNamedElementMapping = this.createENamedElementMapping(usedEPackages, loadedEPackages);
                this.replaceReferencesInGeneratedPackages(generatedPackages, eNamedElementMapping);
                Resource ePackageResource = this.createResourceForEPackages(clonedGrammar, generatedPackages, workingResourceSet);
                if (!this.skipGenerate) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Generating EMF model");
                    if (this.generateEdit) {
                        if (this.generateEditor) {
                            _builder.append((Object)", edit");
                        } else {
                            _builder.append((Object)" and edit");
                        }
                    }
                    if (this.generateEditor) {
                        _builder.append((Object)" and editor");
                    }
                    _builder.append((Object)" code");
                    LOG.info((Object)_builder);
                    GenModel genModel = this.getSaveAndReconcileGenModel(clonedGrammar, generatedPackages, workingResourceSet);
                    genModel.reconcile();
                    this.doGenerate(genModel);
                    this.addProjectContributions(clonedGrammar, generatedPackages, workingResourceSet);
                }
                this.saveResource(ePackageResource);
            }
            this.updateBuildProperties();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                LOG.error((Object)"Failed to execute EMF generator", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void addProjectContributions(Grammar grammar, List<EPackage> generatedPackages, ResourceSet rs) {
        IXtextProjectConfig _projectConfig_2;
        IRuntimeProjectConfig _runtime_2;
        ManifestAccess _manifest;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        IXtextProjectConfig _projectConfig = this.getProjectConfig();
        IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
        PluginXmlAccess _pluginXml = _runtime.getPluginXml();
        boolean bl = _tripleNotEquals = _pluginXml != null;
        if (_tripleNotEquals) {
            IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_1 = _projectConfig_1.getRuntime();
            PluginXmlAccess _pluginXml_1 = _runtime_1.getPluginXml();
            List<CharSequence> _entries = _pluginXml_1.getEntries();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"<extension point=\"org.eclipse.emf.ecore.generated_package\">");
            _builder.newLine();
            for (EPackage pack : generatedPackages) {
                _builder.append((Object)"\t");
                _builder.append((Object)"<package ");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"uri = \"");
                String _nsURI = pack.getNsURI();
                _builder.append((Object)_nsURI, "\t\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"class = \"");
                GenPackage _genPackage = GenModelUtil2.getGenPackage(pack, rs);
                String _qualifiedPackageInterfaceName = _genPackage.getQualifiedPackageInterfaceName();
                _builder.append((Object)_qualifiedPackageInterfaceName, "\t\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"genModel = \"");
                String _genModelPath = this.getGenModelPath(grammar);
                String _relativePath = this.getRelativePath(_genModelPath);
                _builder.append((Object)_relativePath, "\t\t");
                _builder.append((Object)"\" />");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</extension>");
            _builder.newLine();
            _entries.add(_builder.toString());
        }
        boolean bl2 = _tripleNotEquals_1 = (_manifest = (_runtime_2 = (_projectConfig_2 = this.getProjectConfig()).getRuntime()).getManifest()) != null;
        if (_tripleNotEquals_1) {
            IXtextProjectConfig _projectConfig_3 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_3 = _projectConfig_3.getRuntime();
            ManifestAccess _manifest_1 = _runtime_3.getManifest();
            Set<String> _requiredBundles = _manifest_1.getRequiredBundles();
            CollectionExtensions.addAll(_requiredBundles, (Object[])new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"});
        }
        for (final EPackage pack_1 : generatedPackages) {
            boolean _equals;
            final GenPackage genPackage = GenModelUtil2.getGenPackage(pack_1, rs);
            boolean _and = false;
            IXtextProjectConfig _projectConfig_4 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_4 = _projectConfig_4.getRuntime();
            ManifestAccess _manifest_2 = _runtime_4.getManifest();
            boolean _tripleNotEquals_2 = _manifest_2 != null;
            _and = !_tripleNotEquals_2 ? false : (_equals = Objects.equal((Object)this.modelPluginID, null));
            if (_and) {
                IXtextProjectConfig _projectConfig_5 = this.getProjectConfig();
                IRuntimeProjectConfig _runtime_5 = _projectConfig_5.getRuntime();
                ManifestAccess _manifest_3 = _runtime_5.getManifest();
                Set<String> _exportedPackages = _manifest_3.getExportedPackages();
                String _interfacePackageName = genPackage.getInterfacePackageName();
                String _classPackageName = genPackage.getClassPackageName();
                String _utilitiesPackageName = genPackage.getUtilitiesPackageName();
                CollectionExtensions.addAll(_exportedPackages, (Object[])new String[]{_interfacePackageName, _classPackageName, _utilitiesPackageName});
            }
            IXtextGeneratorLanguage _language = this.getLanguage();
            StandaloneSetupAccess _runtimeGenSetup = _language.getRuntimeGenSetup();
            List<StringConcatenationClient> _registrations = _runtimeGenSetup.getRegistrations();
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (!");
                    _builder.append(EPackage.class, "");
                    _builder.append((Object)".Registry.INSTANCE.containsKey(\"");
                    String _nsURI = pack_1.getNsURI();
                    _builder.append((Object)_nsURI, "");
                    _builder.append((Object)"\")) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append(EPackage.class, "\t");
                    _builder.append((Object)".Registry.INSTANCE.put(\"");
                    String _nsURI_1 = pack_1.getNsURI();
                    _builder.append((Object)_nsURI_1, "\t");
                    _builder.append((Object)"\", ");
                    String _qualifiedPackageInterfaceName = genPackage.getQualifiedPackageInterfaceName();
                    TypeReference _typeReference = new TypeReference(_qualifiedPackageInterfaceName);
                    _builder.append((Object)_typeReference, "\t");
                    _builder.append((Object)".eINSTANCE);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            _registrations.add(_client);
        }
    }

    private Grammar cloneGrammarIntoNewResourceSet(Grammar original) {
        Resource originalResource = original.eResource();
        XtextResourceSet _xtextResourceSet = new XtextResourceSet();
        ResourceSet _resourceSet = originalResource.getResourceSet();
        XtextResourceSet clonedResourceSet = (XtextResourceSet)EcoreUtil2.clone((ResourceSet)_xtextResourceSet, (ResourceSet)_resourceSet);
        URI _uRI = originalResource.getURI();
        Resource clonedResource = clonedResourceSet.getResource(_uRI, false);
        EList _contents = clonedResource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        return (Grammar)_head;
    }

    private void registerUsedGenModel(URIConverter converter, Grammar grammar) {
        URI genModelUri = this.getGenModelUri(grammar);
        boolean _exists = converter.exists(genModelUri, null);
        if (_exists) {
            try {
                GenModelHelper _genModelHelper = new GenModelHelper();
                XtextResourceSet _xtextResourceSet = new XtextResourceSet();
                _genModelHelper.registerGenModel((ResourceSet)_xtextResourceSet, genModelUri);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    LOG.error((Object)"Failed to register GenModel", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    private Map<String, EPackage> findAllUsedEPackages(List<EPackage> generatedPackages) {
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EList _eCrossReferences = current.eCrossReferences();
            for (EObject referenced : _eCrossReferences) {
                boolean _not;
                boolean _eIsProxy = referenced.eIsProxy();
                if (_eIsProxy) {
                    throw new RuntimeException("Unresolved proxy: " + referenced + " in " + current);
                }
                if (!(referenced instanceof EClassifier)) continue;
                EPackage referencedPackage = ((EClassifier)referenced).getEPackage();
                boolean _contains = generatedPackages.contains(referencedPackage);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                String _nsURI = referencedPackage.getNsURI();
                result.put(_nsURI, referencedPackage);
            }
        }
        return result;
    }

    private Map<String, EPackage> findEPackagesInGenPackages(Collection<String> packageNsURIs, ResourceSet resourceSet) {
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        for (String nsURI : packageNsURIs) {
            EList _contents;
            Iterable _filter;
            GenModel loadedGenModel;
            boolean _notEquals;
            Resource resource = GenModelUtil2.getGenModelResource(null, nsURI, resourceSet);
            boolean bl = _notEquals = !Objects.equal((Object)resource, null);
            if (!_notEquals || (loadedGenModel = (GenModel)IterableExtensions.head((Iterable)(_filter = Iterables.filter((Iterable)(_contents = resource.getContents()), GenModel.class)))) == null) continue;
            GenPackage genPackage = this.findGenPackageByNsURI(loadedGenModel, nsURI);
            EPackage _ecorePackage = genPackage.getEcorePackage();
            result.put(nsURI, _ecorePackage);
        }
        return result;
    }

    private GenPackage findGenPackageByNsURI(GenModel genModel, String nsURI) {
        List allGenPackages = genModel.getAllGenUsedAndStaticGenPackagesWithClassifiers();
        for (GenPackage genPackage : allGenPackages) {
            boolean _eIsProxy;
            EPackage ecorePackage = genPackage.getEcorePackage();
            boolean _or = false;
            _or = ecorePackage == null ? true : (_eIsProxy = ecorePackage.eIsProxy());
            if (_or) {
                Resource _eResource = genModel.eResource();
                URI _uRI = _eResource.getURI();
                String _plus = "Unresolved proxy: " + ecorePackage + " in " + _uRI;
                throw new RuntimeException(_plus);
            }
            String _nsURI = ecorePackage.getNsURI();
            boolean _equals = Objects.equal((Object)nsURI, (Object)_nsURI);
            if (!_equals) continue;
            return genPackage;
        }
        Resource _eResource = genModel.eResource();
        URI _uRI = _eResource.getURI();
        String _plus = "No GenPackage for NsURI " + nsURI + " found in " + _uRI;
        throw new RuntimeException(_plus);
    }

    private Map<EObject, EObject> createENamedElementMapping(Map<String, EPackage> usedEPackages, Map<String, EPackage> loadedEPackages) {
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Set<Map.Entry<String, EPackage>> _entrySet = usedEPackages.entrySet();
        for (Map.Entry<String, EPackage> entry : _entrySet) {
            EPackage _value = entry.getValue();
            String _key = entry.getKey();
            EPackage _get = loadedEPackages.get(_key);
            this.putMappingData(result, _value, _get);
        }
        return result;
    }

    private void putMappingData(Map<EObject, EObject> result, EPackage usedEPackage, EPackage loadedEPackage) {
        boolean _notEquals;
        boolean _and = false;
        _and = loadedEPackage == null ? false : (_notEquals = !Objects.equal((Object)usedEPackage, (Object)loadedEPackage));
        if (_and) {
            result.put((EObject)usedEPackage, (EObject)loadedEPackage);
            EList _eClassifiers = usedEPackage.getEClassifiers();
            for (EClassifier usedClassifier : _eClassifiers) {
                String _name = usedClassifier.getName();
                EClassifier loadedClassifier = loadedEPackage.getEClassifier(_name);
                if (loadedClassifier == null) {
                    String _name_1 = usedClassifier.getName();
                    String _plus = "Cannot find classifier '" + _name_1;
                    String _plus_1 = String.valueOf(_plus) + "' in loaded EPackage from ";
                    Resource _eResource = loadedEPackage.eResource();
                    URI _uRI = _eResource.getURI();
                    String _plus_2 = String.valueOf(_plus_1) + _uRI;
                    throw new RuntimeException(_plus_2);
                }
                result.put((EObject)usedClassifier, (EObject)loadedClassifier);
            }
            EList _eSubpackages = usedEPackage.getESubpackages();
            for (final EPackage usedNestedPackage : _eSubpackages) {
                Functions.Function1<EPackage, Boolean> _function;
                EList _eSubpackages_1 = loadedEPackage.getESubpackages();
                EPackage loadedNestedPackage = (EPackage)IterableExtensions.findFirst((Iterable)_eSubpackages_1, (Functions.Function1)(_function = new Functions.Function1<EPackage, Boolean>(){

                    public Boolean apply(EPackage it) {
                        String _name = it.getName();
                        String _name_1 = usedNestedPackage.getName();
                        return Objects.equal((Object)_name, (Object)_name_1);
                    }
                }));
                if (loadedNestedPackage == null) continue;
                this.putMappingData(result, usedNestedPackage, loadedNestedPackage);
            }
        }
    }

    private void replaceReferencesInGeneratedPackages(List<EPackage> generatedPackages, Map<EObject, EObject> eNamedElementMapping) {
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EClass _eClass = current.eClass();
            EList _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)_eAllStructuralFeatures).crossReferences();
            if (crossReferenceFeatures == null) continue;
            EStructuralFeature[] eStructuralFeatureArray = crossReferenceFeatures;
            int n = crossReferenceFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature crossReferenceFeature = eStructuralFeatureArray[n2];
                boolean _isChangeable = crossReferenceFeature.isChangeable();
                if (_isChangeable) {
                    EReference reference = (EReference)crossReferenceFeature;
                    boolean _isMany = reference.isMany();
                    if (_isMany) {
                        Object _eGet = current.eGet((EStructuralFeature)reference);
                        List values = (List)_eGet;
                        for (EObject value : values) {
                            boolean _containsKey = eNamedElementMapping.containsKey(value);
                            if (!_containsKey) continue;
                            EObject _get = eNamedElementMapping.get(value);
                            EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)_get);
                        }
                    } else {
                        Object _eGet_1 = current.eGet((EStructuralFeature)reference);
                        EObject value_1 = (EObject)_eGet_1;
                        boolean _containsKey_1 = eNamedElementMapping.containsKey(value_1);
                        if (_containsKey_1) {
                            EObject _get_1 = eNamedElementMapping.get(value_1);
                            EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value_1, (Object)_get_1);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected Resource createResourceForEPackages(Grammar grammar, List<EPackage> packs, ResourceSet rs) {
        URI ecoreFileUri = this.getEcoreFileUri(grammar);
        Resource existing = rs.getResource(ecoreFileUri, false);
        if (existing != null) {
            existing.unload();
            EList _resources = rs.getResources();
            _resources.remove((Object)existing);
        }
        Resource ecoreFile = rs.createResource(ecoreFileUri, "");
        EList _contents = ecoreFile.getContents();
        _contents.addAll(packs);
        return ecoreFile;
    }

    protected GenModel getSaveAndReconcileGenModel(Grammar grammar, List<EPackage> packs, ResourceSet rs) {
        GenModel genModel = this.getGenModel(rs, grammar);
        genModel.initialize(packs);
        EList _genPackages = genModel.getGenPackages();
        for (GenPackage genPackage : _genPackages) {
            boolean _not;
            String _basePackage = this.getBasePackage(grammar);
            genPackage.setBasePackage(_basePackage);
            if (this.suppressLoadInitialization) {
                genPackage.setLoadInitialization(false);
            }
            boolean _and = false;
            IXtextGeneratorLanguage _language = this.getLanguage();
            List<String> _fileExtensions = _language.getFileExtensions();
            boolean _isEmpty = _fileExtensions.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) {
                _and = false;
            } else {
                boolean _contains;
                EPackage _ecorePackage = genPackage.getEcorePackage();
                _and = _contains = packs.contains(_ecorePackage);
            }
            if (!_and) continue;
            IXtextGeneratorLanguage _language_1 = this.getLanguage();
            List<String> _fileExtensions_1 = _language_1.getFileExtensions();
            String _join = IterableExtensions.join(_fileExtensions_1, (CharSequence)",");
            genPackage.setFileExtensions(_join);
        }
        Set<EPackage> referencedEPackages = this.getReferencedEPackages(packs);
        List<GenPackage> usedGenPackages = this.getGenPackagesForPackages(genModel, referencedEPackages);
        this.reconcileMissingGenPackagesInUsedModels(usedGenPackages);
        EList _usedGenPackages = genModel.getUsedGenPackages();
        _usedGenPackages.addAll(usedGenPackages);
        Resource _eResource = genModel.eResource();
        this.saveResource(_eResource);
        GenModelHelper _genModelHelper = new GenModelHelper();
        _genModelHelper.registerGenModel(genModel);
        return genModel;
    }

    private void reconcileMissingGenPackagesInUsedModels(List<GenPackage> usedGenPackages) {
        int _size = usedGenPackages.size();
        HashSet processedModels = Sets.newHashSetWithExpectedSize((int)_size);
        for (GenPackage usedGenPackage : usedGenPackages) {
            GenModel genModel = usedGenPackage.getGenModel();
            boolean _add = processedModels.add(genModel);
            if (!_add) continue;
            List missingPackages = genModel.getMissingPackages();
            List<GenPackage> missingGenPackages = this.getGenPackagesForPackages(genModel, missingPackages);
            EList _usedGenPackages = genModel.getUsedGenPackages();
            _usedGenPackages.addAll(missingGenPackages);
        }
    }

    protected GenModel getGenModel(ResourceSet rs, Grammar grammar) {
        try {
            URI genModelUri = this.getGenModelUri(grammar);
            Resource resource = rs.getResource(genModelUri, false);
            if (resource != null) {
                resource.unload();
                EList _resources = rs.getResources();
                _resources.remove((Object)resource);
            }
            Resource genModelFile = rs.createResource(genModelUri, "");
            GenModelImpl genModel = null;
            URIConverter _uRIConverter = rs.getURIConverter();
            boolean _exists = _uRIConverter.exists(genModelUri, null);
            if (_exists) {
                genModelFile.load(null);
                boolean _hasFragment = genModelUri.hasFragment();
                if (_hasFragment) {
                    String _fragment = genModelUri.fragment();
                    EObject _eObject = genModelFile.getEObject(_fragment);
                    genModel = (GenModel)_eObject;
                } else {
                    EList _contents = genModelFile.getContents();
                    EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
                    genModel = (GenModel)_head;
                }
            } else {
                boolean _tripleNotEquals;
                genModel = new GenModelImpl(){

                    public GenPackage createGenPackage() {
                        return new GenPackageImpl(){

                            public String getSerializedPackageFilename() {
                                String _name = this.getName();
                                return String.valueOf(_name) + ".loadinitialization_ecore";
                            }
                        };
                    }
                };
                String _modelName = this.getModelName(grammar);
                genModel.setModelName(_modelName);
                String _modelPluginID = this.getModelPluginID();
                genModel.setModelPluginID(_modelPluginID);
                String _javaModelDirectory = this.getJavaModelDirectory();
                genModel.setModelDirectory(_javaModelDirectory);
                if (this.generateEdit) {
                    String _editPluginID = this.getEditPluginID();
                    genModel.setEditPluginID(_editPluginID);
                    String _editDirectory = this.getEditDirectory();
                    genModel.setEditDirectory(_editDirectory);
                }
                if (this.generateEditor) {
                    String _editorPluginID = this.getEditorPluginID();
                    genModel.setEditorPluginID(_editorPluginID);
                    String _editorDirectory = this.getEditorDirectory();
                    genModel.setEditorDirectory(_editorDirectory);
                }
                genModel.setValidateModel(false);
                genModel.setForceOverwrite(true);
                genModel.setFacadeHelperClass(null);
                genModel.setBundleManifest(true);
                genModel.setUpdateClasspath(false);
                genModel.setComplianceLevel(this.jdkLevel);
                genModel.setRuntimeVersion(this.emfRuntimeVersion);
                genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
                String _lineDelimiter = this.codeConfig.getLineDelimiter();
                genModel.setLineDelimiter(_lineDelimiter);
                String _fileHeader = this.codeConfig.getFileHeader();
                boolean bl = _tripleNotEquals = _fileHeader != null;
                if (_tripleNotEquals) {
                    String _fileHeader_1 = this.codeConfig.getFileHeader();
                    String _trimMultiLineComment = EMFGeneratorFragment2.trimMultiLineComment(_fileHeader_1);
                    genModel.setCopyrightText(_trimMultiLineComment);
                }
            }
            EList _contents_1 = genModelFile.getContents();
            _contents_1.add((Object)genModel);
            return genModel;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String trimMultiLineComment(String string) {
        String _replace = string.replace("*/", "");
        String _replace_1 = _replace.replace("/*", "");
        String _replace_2 = _replace_1.replace(" * ", "");
        return _replace_2.trim();
    }

    protected Set<EPackage> getReferencedEPackages(List<EPackage> packs) {
        HashSet result = CollectionLiterals.newHashSet((Object[])new EPackage[0]);
        for (EPackage pkg : packs) {
            TreeIterator iterator = pkg.eAllContents();
            while (iterator.hasNext()) {
                EObject obj = (EObject)iterator.next();
                EList _eCrossReferences = obj.eCrossReferences();
                for (EObject crossRef : _eCrossReferences) {
                    boolean _eIsProxy = crossRef.eIsProxy();
                    if (_eIsProxy) {
                        URI _eProxyURI = ((InternalEObject)crossRef).eProxyURI();
                        String _plus = "Proxy '" + _eProxyURI;
                        String _plus_1 = String.valueOf(_plus) + "' could not be resolved";
                        LOG.error((Object)_plus_1);
                        continue;
                    }
                    EPackage p = (EPackage)EcoreUtil2.getContainerOfType((EObject)crossRef, EPackage.class);
                    if (p == null) continue;
                    result.add(p);
                }
            }
        }
        result.removeAll(packs);
        result.remove(EcorePackage.eINSTANCE);
        result.remove(XMLTypePackage.eINSTANCE);
        result.remove(XMLNamespacePackage.eINSTANCE);
        return result;
    }

    protected List<GenPackage> getGenPackagesForPackages(GenModel existingGenModel, Collection<EPackage> packs) {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new GenPackage[0]);
        for (final EPackage pkg : packs) {
            boolean _not;
            Functions.Function1<GenPackage, Boolean> _function;
            EList _genPackages = existingGenModel.getGenPackages();
            boolean _exists = IterableExtensions.exists((Iterable)_genPackages, (Functions.Function1)(_function = new Functions.Function1<GenPackage, Boolean>(){

                public Boolean apply(GenPackage it) {
                    EPackage _ecorePackage = it.getEcorePackage();
                    String _nsURI = null;
                    if (_ecorePackage != null) {
                        _nsURI = _ecorePackage.getNsURI();
                    }
                    String _nsURI_1 = pkg.getNsURI();
                    return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                }
            }));
            boolean bl = _not = !_exists;
            if (!_not) continue;
            Resource _eResource = existingGenModel.eResource();
            ResourceSet _resourceSet = _eResource.getResourceSet();
            GenPackage _genPackage = GenModelUtil2.getGenPackage(pkg, _resourceSet);
            result.add(_genPackage);
        }
        Comparator<GenPackage> _function_1 = new Comparator<GenPackage>(){

            @Override
            public int compare(GenPackage o1, GenPackage o2) {
                URI _uRI = EcoreUtil.getURI((EObject)o1);
                String _string = _uRI.toString();
                URI _uRI_1 = EcoreUtil.getURI((EObject)o2);
                String _string_1 = _uRI_1.toString();
                return _string.compareTo(_string_1);
            }
        };
        Collections.sort(result, _function_1);
        return result;
    }

    private void saveResource(Resource resource) {
        try {
            HashMap saveOptions = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            saveOptions.put("URI_HANDLER", new URIHandlerImpl.AbsoluteCrossBundleAware(){

                public URI deresolve(URI uri) {
                    boolean _not;
                    boolean _isPlatform = uri.isPlatform();
                    boolean bl = _not = !_isPlatform;
                    if (_not) {
                        Map _platformResourceMap = EcorePlugin.getPlatformResourceMap();
                        Set _entrySet = _platformResourceMap.entrySet();
                        for (Map.Entry entry : _entrySet) {
                            String _key = (String)entry.getKey();
                            String _plus = "platform:/resource/" + _key;
                            String _plus_1 = String.valueOf(_plus) + "/";
                            URI newPrefix = URI.createURI((String)_plus_1);
                            URI _value = (URI)entry.getValue();
                            URI uri2 = uri.replacePrefix(_value, newPrefix);
                            if (uri2 == null) continue;
                            return super.deresolve(uri2);
                        }
                    }
                    return super.deresolve(uri);
                }
            });
            String _lineDelimiter = this.codeConfig.getLineDelimiter();
            saveOptions.put("LINE_DELIMITER", _lineDelimiter);
            resource.save((Map)saveOptions);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void doGenerate(GenModel genModel) {
        boolean _notEquals;
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                boolean _equals = Objects.equal((Object)this.jControlModel, null);
                if (_equals) {
                    JControlModel _jControlModel;
                    this.jControlModel = _jControlModel = new JControlModel();
                    this.jControlModel.initialize(null, this.options.mergeRulesURI);
                }
                return this.jControlModel;
            }
        };
        GeneratorAdapterFactory.Descriptor.Registry _adapterFactoryDescriptorRegistry = generator.getAdapterFactoryDescriptorRegistry();
        String _lineDelimiter = this.codeConfig.getLineDelimiter();
        CvsIdFilteringGeneratorAdapterFactoryDescriptor _cvsIdFilteringGeneratorAdapterFactoryDescriptor = new CvsIdFilteringGeneratorAdapterFactoryDescriptor(_lineDelimiter);
        _adapterFactoryDescriptorRegistry.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)_cvsIdFilteringGeneratorAdapterFactoryDescriptor);
        genModel.setCanGenerate(true);
        generator.setInput((Object)genModel);
        BasicMonitor _basicMonitor = new BasicMonitor();
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)_basicMonitor);
        int _severity = diagnostic.getSeverity();
        boolean bl = _notEquals = _severity != 0;
        if (_notEquals) {
            LOG.warn((Object)diagnostic);
        }
        if (this.generateEdit) {
            boolean _notEquals_1;
            BasicMonitor _basicMonitor_1 = new BasicMonitor();
            Diagnostic editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)_basicMonitor_1);
            int _severity_1 = editDiag.getSeverity();
            boolean bl2 = _notEquals_1 = _severity_1 != 0;
            if (_notEquals_1) {
                LOG.warn((Object)editDiag);
            }
        }
        if (this.generateEditor) {
            boolean _notEquals_2;
            BasicMonitor _basicMonitor_2 = new BasicMonitor();
            Diagnostic editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)_basicMonitor_2);
            int _severity_2 = editorDiag.getSeverity();
            boolean bl3 = _notEquals_2 = _severity_2 != 0;
            if (_notEquals_2) {
                LOG.warn((Object)editorDiag);
            }
        }
    }

    private void updateBuildProperties() {
        try {
            IXtextProjectConfig _projectConfig;
            IRuntimeProjectConfig _runtime;
            ManifestAccess _manifest;
            boolean _tripleEquals;
            boolean _or = false;
            _or = !this.updateBuildProperties || this.modelPluginID != null ? true : (_tripleEquals = (_manifest = (_runtime = (_projectConfig = this.getProjectConfig()).getRuntime()).getManifest()) == null);
            if (_or) {
                return;
            }
            IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_1 = _projectConfig_1.getRuntime();
            IXtextGeneratorFileSystemAccess rootOutlet = _runtime_1.getRoot();
            String _path = rootOutlet.getPath();
            String buildPropertiesPath = String.valueOf(_path) + "/build.properties";
            IXtextProjectConfig _projectConfig_2 = this.getProjectConfig();
            IRuntimeProjectConfig _runtime_2 = _projectConfig_2.getRuntime();
            String modelContainer = _runtime_2.getEcoreModelFolder();
            Properties buildProperties = new Properties();
            File _file = new File(buildPropertiesPath);
            FileInputStream _fileInputStream = new FileInputStream(_file);
            String _encoding = this.codeConfig.getEncoding();
            Charset _forName = Charset.forName(_encoding);
            InputStreamReader reader = new InputStreamReader((InputStream)_fileInputStream, _forName);
            try {
                String existingContent = CharStreams.toString((Readable)reader);
                StringInputStream _stringInputStream = new StringInputStream(existingContent, "ISO-8859-1");
                buildProperties.load((InputStream)_stringInputStream);
                String binIncludes = buildProperties.getProperty("bin.includes");
                boolean changed = false;
                if (binIncludes == null) {
                    String _existingContent = existingContent;
                    String _newLine = Strings.newLine();
                    String _plus = "bin.includes = " + modelContainer + "/" + _newLine;
                    String _plus_1 = String.valueOf(_plus) + "               ";
                    existingContent = String.valueOf(_existingContent) + _plus_1;
                    changed = true;
                } else {
                    boolean _not;
                    boolean _contains = binIncludes.contains(modelContainer);
                    boolean bl = _not = !_contains;
                    if (_not) {
                        String _replace;
                        String _newLine_1 = Strings.newLine();
                        String _plus_2 = "bin.includes = " + modelContainer + "/,\\" + _newLine_1;
                        String _plus_3 = String.valueOf(_plus_2) + "               ";
                        existingContent = _replace = existingContent.replace("bin.includes = ", _plus_3);
                        changed = true;
                    }
                }
                if (changed) {
                    File _file_1 = new File(buildPropertiesPath);
                    FileOutputStream _fileOutputStream = new FileOutputStream(_file_1);
                    String _encoding_1 = this.codeConfig.getEncoding();
                    Charset _forName_1 = Charset.forName(_encoding_1);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)_fileOutputStream, _forName_1);
                    writer.write(existingContent);
                    writer.close();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setModelPluginID(String modelPluginID) {
        this.modelPluginID = modelPluginID;
    }

    public void setJavaModelDirectory(String javaModelDirectory) {
        this.javaModelDirectory = javaModelDirectory;
    }

    public void setGenerateEdit(boolean generateEdit) {
        this.generateEdit = generateEdit;
    }

    public void setEditPluginID(String editPluginID) {
        this.editPluginID = editPluginID;
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setGenerateEditor(boolean generateEditor) {
        this.generateEditor = generateEditor;
    }

    public void setEditorPluginID(String editorPluginID) {
        this.editorPluginID = editorPluginID;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setGenModel(String genModel) {
        this.genModel = genModel;
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public void setUpdateBuildProperties(boolean updateBuildProperties) {
        this.updateBuildProperties = updateBuildProperties;
    }

    public void setLongFileNames(boolean longFileNames) {
        this.longFileNames = longFileNames;
    }

    public void setSuppressLoadInitialization(boolean suppressLoadInitialization) {
        this.suppressLoadInitialization = suppressLoadInitialization;
    }
}

