/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.ui.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.validation.UniqueClassNameValidator;

public class ProjectAwareUniqueClassNameValidator
extends UniqueClassNameValidator {
    private static final String OUTPUT_CONFIGS = "ProjectAwareUniqueClassNameValidator.outputConfigs";
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;

    public boolean doCheckUniqueName(QualifiedName name, JvmDeclaredType type) {
        boolean _doCheckUniqueName = super.doCheckUniqueName(name, type);
        if (_doCheckUniqueName) {
            try {
                return this.doCheckUniqueInProject(name, type);
            }
            catch (Throwable _t) {
                if (_t instanceof JavaModelException) {
                    JavaModelException e = (JavaModelException)_t;
                    return true;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return false;
    }

    private SourceTraversal doCheckUniqueInProjectSource(String packageName, String typeName, JvmDeclaredType type, IPackageFragmentRoot[] sourceFolders) throws JavaModelException {
        IndexManager indexManager = JavaModelManager.getIndexManager();
        IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _greaterThan;
            IPackageFragmentRoot sourceFolder = iPackageFragmentRootArray[n2];
            int _awaitingJobsCount = indexManager.awaitingJobsCount();
            boolean bl = _greaterThan = _awaitingJobsCount > 0;
            if (_greaterThan) {
                IPackageFragment packageFragment;
                boolean _exists;
                boolean _not;
                IResource _resource = sourceFolder.getResource();
                boolean _isDerived = this.isDerived(_resource);
                boolean bl2 = _not = !_isDerived;
                if (_not && (_exists = (packageFragment = sourceFolder.getPackageFragment(packageName)).exists())) {
                    ICompilationUnit[] units;
                    ICompilationUnit[] iCompilationUnitArray = units = packageFragment.getCompilationUnits();
                    int n3 = units.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType javaType;
                        boolean _exists_1;
                        boolean _not_1;
                        ICompilationUnit unit = iCompilationUnitArray[n4];
                        IResource resource = unit.getResource();
                        boolean _isDerived_1 = this.isDerived(resource);
                        boolean bl3 = _not_1 = !_isDerived_1;
                        if (_not_1 && (_exists_1 = (javaType = unit.getType(typeName)).exists())) {
                            String _elementName = unit.getElementName();
                            this.addIssue(type, _elementName);
                            return SourceTraversal.DUPLICATE;
                        }
                        ++n4;
                    }
                }
            } else {
                return SourceTraversal.INTERRUPT;
            }
            ++n2;
        }
        return SourceTraversal.UNIQUE;
    }

    public boolean doCheckUniqueInProject(QualifiedName name, final JvmDeclaredType type) throws JavaModelException {
        IndexQueryRequestor _function_1;
        boolean _notEquals;
        int _awaitingJobsCount;
        boolean _greaterThan;
        boolean _equals;
        Resource _eResource = type.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        IJavaProject javaProject = this.javaProjectProvider.getJavaProject(_resourceSet);
        Map _context = this.getContext();
        Resource _eResource_1 = type.eResource();
        Set _outputConfigurations = this.outputConfigurationProvider.getOutputConfigurations(_eResource_1);
        _context.put(OUTPUT_CONFIGS, _outputConfigurations);
        String packageName = type.getPackageName();
        String typeName = type.getSimpleName();
        IPackageFragmentRoot[] _packageFragmentRoots = javaProject.getPackageFragmentRoots();
        Functions.Function1<IPackageFragmentRoot, Boolean> _function = new Functions.Function1<IPackageFragmentRoot, Boolean>(){

            public Boolean apply(IPackageFragmentRoot it) {
                try {
                    int _kind = it.getKind();
                    return _kind == 1;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable sourceFolders = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_packageFragmentRoots)), (Functions.Function1)_function);
        IndexManager indexManager = JavaModelManager.getIndexManager();
        boolean _or = false;
        int _length = ((Object[])Conversions.unwrapArray((Object)sourceFolders, Object.class)).length;
        boolean bl = _equals = _length == 0;
        _or = _equals ? true : (_greaterThan = (_awaitingJobsCount = indexManager.awaitingJobsCount()) > 0);
        if (_or) {
            String _elvis = null;
            _elvis = packageName != null ? packageName : "";
            SourceTraversal _doCheckUniqueInProjectSource = this.doCheckUniqueInProjectSource(_elvis, typeName, type, (IPackageFragmentRoot[])Conversions.unwrapArray((Object)sourceFolders, IPackageFragmentRoot.class));
            if (_doCheckUniqueInProjectSource != null) {
                switch (_doCheckUniqueInProjectSource) {
                    case DUPLICATE: {
                        return false;
                    }
                    case UNIQUE: {
                        return true;
                    }
                }
            }
        }
        final HashSet workingCopyPaths = CollectionLiterals.newHashSet((Object[])new String[0]);
        ICompilationUnit[] copies = this.getWorkingCopies(type);
        boolean bl2 = _notEquals = !Objects.equal((Object)copies, null);
        if (_notEquals) {
            ICompilationUnit[] iCompilationUnitArray = copies;
            int n = copies.length;
            int n2 = 0;
            while (n2 < n) {
                IResource _resource;
                boolean _isDerived;
                boolean _not;
                ICompilationUnit workingCopy = iCompilationUnitArray[n2];
                IPath path = workingCopy.getPath();
                boolean _and = false;
                IPath _path = javaProject.getPath();
                boolean _isPrefixOf = _path.isPrefixOf(path);
                _and = !_isPrefixOf ? false : (_not = !(_isDerived = this.isDerived(_resource = workingCopy.getResource())));
                if (_and) {
                    IType result;
                    boolean _exists_1;
                    IPackageDeclaration _packageDeclaration = workingCopy.getPackageDeclaration(packageName);
                    boolean _exists = _packageDeclaration.exists();
                    if (_exists && (_exists_1 = (result = workingCopy.getType(typeName)).exists())) {
                        String _elementName = workingCopy.getElementName();
                        this.addIssue(type, _elementName);
                        return false;
                    }
                    IPath _path_1 = workingCopy.getPath();
                    String _string = _path_1.toString();
                    workingCopyPaths.add(_string);
                }
                ++n2;
            }
        }
        char[] _xifexpression = null;
        boolean _equals_1 = Objects.equal((Object)packageName, null);
        _xifexpression = _equals_1 ? CharOperation.NO_CHAR : packageName.toCharArray();
        char[] _charArray = typeName.toCharArray();
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(_xifexpression, CharOperation.NO_CHAR_CHAR, _charArray, '\u0000', 8);
        IndexQueryRequestor searchRequestor = _function_1 = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                boolean _not;
                Path _path;
                boolean _contains = workingCopyPaths.contains(documentPath);
                if (_contains) {
                    return true;
                }
                IWorkspace _workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot _root = _workspace.getRoot();
                IFile file = _root.getFile((IPath)(_path = new Path(documentPath)));
                boolean _isDerived = ProjectAwareUniqueClassNameValidator.this.isDerived((IResource)file);
                boolean bl = _not = !_isDerived;
                if (_not) {
                    String _name = file.getName();
                    ProjectAwareUniqueClassNameValidator.this.addIssue(type, _name);
                    return false;
                }
                return true;
            }
        };
        try {
            SearchParticipant _defaultSearchParticipant = BasicSearchEngine.getDefaultSearchParticipant();
            IJavaSearchScope _createJavaSearchScope = BasicSearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])Conversions.unwrapArray((Object)sourceFolders, IJavaElement.class)));
            PatternSearchJob _patternSearchJob = new PatternSearchJob((SearchPattern)pattern, _defaultSearchParticipant, _createJavaSearchScope, searchRequestor);
            indexManager.performConcurrentJob((IJob)_patternSearchJob, 3, null);
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof OperationCanceledException) {
                OperationCanceledException oce = (OperationCanceledException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private ICompilationUnit[] getWorkingCopies(JvmDeclaredType type) {
        ResourceSetContext _get = ResourceSetContext.get((Notifier)type);
        boolean _isBuilder = _get.isBuilder();
        if (_isBuilder) {
            return new ICompilationUnit[0];
        }
        JavaModelManager _javaModelManager = JavaModelManager.getJavaModelManager();
        return _javaModelManager.getWorkingCopies((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, false);
    }

    protected boolean isDerived(IResource resource) {
        try {
            boolean _notEquals;
            boolean _greaterEqualsThan;
            IMarker[] _findDerivedResourceMarkers = this.derivedResourceMarkers.findDerivedResourceMarkers(resource);
            int _length = _findDerivedResourceMarkers.length;
            boolean bl = _greaterEqualsThan = _length >= 1;
            if (_greaterEqualsThan) {
                return true;
            }
            Map _context = this.getContext();
            Object _get = _context.get(OUTPUT_CONFIGS);
            Collection outputConfigurations = (Collection)_get;
            boolean bl2 = _notEquals = !Objects.equal((Object)outputConfigurations, null);
            if (_notEquals) {
                IPath projectRelativePath = resource.getProjectRelativePath();
                Iterator iterator = outputConfigurations.iterator();
            }
            return false;
        }
        finally {
            Throwable _t;
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        URI objectURI = EcoreUtil.getURI((EObject)type);
        boolean _isPlatformResource = objectURI.isPlatformResource();
        if (_isPlatformResource) {
            final String project = objectURI.segment(1);
            Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

                public Boolean apply(IEObjectDescription it) {
                    URI candidate = it.getEObjectURI();
                    boolean _and = false;
                    boolean _isPlatformResource = candidate.isPlatformResource();
                    if (!_isPlatformResource) {
                        _and = false;
                    } else {
                        boolean _equals;
                        String _segment = candidate.segment(1);
                        _and = _equals = Objects.equal((Object)_segment, (Object)project);
                    }
                    return _and;
                }
            };
            Iterable _filter = IterableExtensions.filter(descriptions, (Functions.Function1)_function);
            return super.checkUniqueInIndex(type, _filter);
        }
        return true;
    }

    private static enum SourceTraversal {
        INTERRUPT,
        DUPLICATE,
        UNIQUE;

    }
}

