/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class ResourceURICollector {
    private static final Logger LOG = Logger.getLogger(ResourceURICollector.class);

    public Set<URI> collectAllResources(Iterable<URI> roots, Set<String> fileExtensions) {
        boolean _isInfoEnabled = LOG.isInfoEnabled();
        if (_isInfoEnabled) {
            LOG.info((Object)"Collecting source models.");
        }
        long startedAt = System.currentTimeMillis();
        Set<URI> result = this.collectResources(roots, fileExtensions);
        boolean _isDebugEnabled = LOG.isDebugEnabled();
        if (_isDebugEnabled) {
            long _currentTimeMillis = System.currentTimeMillis();
            long _minus = _currentTimeMillis - startedAt;
            String _plus = "Finished collecting source models. Took: " + Long.valueOf(_minus);
            String _plus_1 = String.valueOf(_plus) + " ms.";
            LOG.debug((Object)_plus_1);
        }
        return result;
    }

    protected Set<URI> collectResources(Iterable<URI> roots, Set<String> fileExtensions) {
        Iterable _plus = Iterables.concat(fileExtensions, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"})));
        final Set extensions = IterableExtensions.toSet((Iterable)_plus);
        PathTraverser _pathTraverser = new PathTraverser();
        Functions.Function1<URI, String> _function = new Functions.Function1<URI, String>(){

            public String apply(URI it) {
                return it.toFileString();
            }
        };
        Iterable _map = IterableExtensions.map(roots, (Functions.Function1)_function);
        List _list = IterableExtensions.toList((Iterable)_map);
        Predicate<URI> _function_1 = new Predicate<URI>(){

            public boolean apply(URI it) {
                String _fileExtension = it.fileExtension();
                return extensions.contains(_fileExtension);
            }
        };
        Multimap modelsFound = _pathTraverser.resolvePathes(_list, (Predicate)_function_1);
        Map _asMap = modelsFound.asMap();
        Procedures.Procedure2<String, Collection<URI>> _function_2 = new Procedures.Procedure2<String, Collection<URI>>(){

            public void apply(String path, Collection<URI> resource) {
                boolean _isDirectory;
                boolean _not;
                boolean _notEquals;
                File file = new File(path);
                boolean _and = false;
                boolean _and_1 = false;
                boolean bl = _notEquals = !Objects.equal(resource, null);
                _and_1 = !_notEquals ? false : (_not = !(_isDirectory = file.isDirectory()));
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _endsWith;
                    String _name = file.getName();
                    _and = _endsWith = _name.endsWith(".jar");
                }
                if (_and) {
                    ResourceURICollector.this.registerBundle(file);
                }
            }
        };
        MapExtensions.forEach((Map)_asMap, (Procedures.Procedure2)_function_2);
        Collection _values = modelsFound.values();
        return IterableExtensions.toSet((Iterable)_values);
    }

    protected void registerBundle(File file) {
        block34: {
            JarFile jarFile;
            block32: {
                String name;
                block33: {
                    Map _platformResourceMap;
                    boolean _containsKey;
                    boolean _notEquals;
                    Manifest manifest;
                    block31: {
                        JarFile _jarFile;
                        jarFile = null;
                        jarFile = _jarFile = new JarFile(file);
                        manifest = jarFile.getManifest();
                        boolean _equals = Objects.equal((Object)manifest, null);
                        if (!_equals) break block31;
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                        return;
                    }
                    Attributes _mainAttributes = manifest.getMainAttributes();
                    name = _mainAttributes.getValue("Bundle-SymbolicName");
                    boolean bl = _notEquals = !Objects.equal((Object)name, null);
                    if (!_notEquals) break block32;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        String _substring;
                        name = _substring = name.substring(0, indexOf);
                    }
                    if (!(_containsKey = (_platformResourceMap = EcorePlugin.getPlatformResourceMap()).containsKey(name))) break block33;
                    try {
                        boolean _notEquals_1;
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                        if (_notEquals_1) {
                            jarFile.close();
                        }
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof IOException) {
                            IOException e_2 = (IOException)_t_1;
                            LOG.error((Object)jarFile, (Throwable)e_2);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                    return;
                }
                try {
                    try {
                        String _absolutePath = file.getAbsolutePath();
                        URI _createFileURI = URI.createFileURI((String)_absolutePath);
                        String _plus = "archive:" + _createFileURI;
                        String path = String.valueOf(_plus) + "!/";
                        Map _platformResourceMap_1 = EcorePlugin.getPlatformResourceMap();
                        URI _createURI = URI.createURI((String)path);
                        _platformResourceMap_1.put(name, _createURI);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ZipException) {
                            ZipException e = (ZipException)_t;
                            String _absolutePath_1 = file.getAbsolutePath();
                            String _plus_1 = "Could not open Jar file " + _absolutePath_1;
                            String _plus_2 = String.valueOf(_plus_1) + ".";
                            LOG.info((Object)_plus_2);
                        } else if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            String _absolutePath_2 = file.getAbsolutePath();
                            LOG.error((Object)_absolutePath_2, (Throwable)e_1);
                        } else {
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                            break block34;
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block34;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    block35: {
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal(jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block35;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                    throw throwable;
                }
            }
            try {
                boolean _notEquals_1;
                boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                if (_notEquals_1) {
                    jarFile.close();
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof IOException) {
                    IOException e_2 = (IOException)_t_1;
                    LOG.error((Object)jarFile, (Throwable)e_2);
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
    }
}

