/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.ide.outline.XtendEObjectNode;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeFactory;

public class XtendOutlineNodeFactory
extends OutlineNodeFactory {
    @Inject
    private IXtendJvmAssociations associations;

    public XtendFeatureNode createXtendFeatureNode(IOutlineNode parentNode, EObject modelElement, ImageDescriptor imageDescriptor, Object text, boolean isLeaf, boolean synthetic, int inheritanceDepth) {
        XtendFeatureNode featureNode = new XtendFeatureNode(modelElement, parentNode, imageDescriptor, text, isLeaf);
        this.configureNode(parentNode, modelElement, inheritanceDepth, featureNode);
        featureNode.setSynthetic(synthetic);
        return featureNode;
    }

    public XtendEObjectNode createXtendEObjectNode(IOutlineNode parentNode, EObject modelElement, ImageDescriptor imageDescriptor, Object text, boolean isLeaf, int inheritanceDepth) {
        XtendEObjectNode featureNode = new XtendEObjectNode(modelElement, parentNode, imageDescriptor, text, isLeaf);
        this.configureNode(parentNode, modelElement, inheritanceDepth, featureNode);
        return featureNode;
    }

    private void configureNode(IOutlineNode parentNode, EObject modelElement, int inheritanceDepth, XtendEObjectNode featureNode) {
        EObject primarySourceElement = this.associations.getPrimarySourceElement(modelElement);
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)(primarySourceElement == null ? modelElement : primarySourceElement));
        if (parserNode != null) {
            featureNode.setTextRegion(parserNode.getTextRegion());
        }
        if (this.isLocalElement(parentNode, modelElement)) {
            featureNode.setShortTextRegion(this.getLocationInFileProvider().getSignificantTextRegion(primarySourceElement == null ? modelElement : primarySourceElement));
        }
        featureNode.setStatic(this.isStatic(modelElement));
        featureNode.setInheritanceDepth(inheritanceDepth);
    }

    protected boolean isStatic(EObject element) {
        if (element instanceof JvmFeature) {
            return ((JvmFeature)element).isStatic();
        }
        if (element instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)element).isStatic();
        }
        if (element instanceof XtendMember) {
            return ((XtendMember)element).isStatic();
        }
        return false;
    }
}

