/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EclipseProjectConfig
extends ProjectConfig {
    private IProject project;
    private EclipseOutputConfigurationProvider configurationProvider;

    public EclipseProjectConfig(IProject project, EclipseOutputConfigurationProvider configurationProvider) {
        super(project.getName());
        this.project = project;
        this.configurationProvider = configurationProvider;
    }

    public Path getContainingSourceFolder(Path path) {
        try {
            Map _sourceFolderMappings = super.getSourceFolderMappings();
            boolean _isEmpty = _sourceFolderMappings.isEmpty();
            if (_isEmpty) {
                IClasspathEntry[] _rawClasspath;
                IJavaProject _create = JavaCore.create((IProject)this.project);
                IClasspathEntry[] iClasspathEntryArray = _rawClasspath = _create.getRawClasspath();
                int n = _rawClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath _path;
                    String _string;
                    Path cpPath;
                    boolean _startsWith;
                    boolean _equals;
                    IClasspathEntry cp = iClasspathEntryArray[n2];
                    int _entryKind = cp.getEntryKind();
                    boolean bl = _equals = _entryKind == 3;
                    if (_equals && (_startsWith = path.startsWith(cpPath = new Path(_string = (_path = cp.getPath()).toString())))) {
                        return cpPath;
                    }
                    ++n2;
                }
            }
            return super.getContainingSourceFolder(path);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Map<Path, Path> getSourceFolderMappings() {
        try {
            Map map = super.getSourceFolderMappings();
            boolean _isEmpty = map.isEmpty();
            if (_isEmpty) {
                IPackageFragmentRoot[] _packageFragmentRoots;
                Set _outputConfigurations = this.configurationProvider.getOutputConfigurations(this.project);
                OutputConfiguration config = (OutputConfiguration)IterableExtensions.head((Iterable)_outputConfigurations);
                IJavaProject jp = JavaCore.create((IProject)this.project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = _packageFragmentRoots = jp.getPackageFragmentRoots();
                int n = _packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource _underlyingResource;
                    boolean _notEquals;
                    boolean _equals;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    boolean _and = false;
                    int _kind = root.getKind();
                    boolean bl = _equals = _kind == 1;
                    _and = !_equals ? false : (_notEquals = !Objects.equal((Object)(_underlyingResource = root.getUnderlyingResource()), null));
                    if (_and) {
                        boolean _notEquals_1;
                        IResource _underlyingResource_1 = root.getUnderlyingResource();
                        IContainer container = (IContainer)_underlyingResource_1;
                        IFolder target = null;
                        boolean _isUseOutputPerSourceFolder = config.isUseOutputPerSourceFolder();
                        if (_isUseOutputPerSourceFolder) {
                            IFolder _folder;
                            IPath _fullPath = container.getFullPath();
                            IPath _fullPath_1 = this.project.getFullPath();
                            IPath _makeRelativeTo = _fullPath.makeRelativeTo(_fullPath_1);
                            String projectRelativeSource = _makeRelativeTo.toString();
                            String _outputDirectory = config.getOutputDirectory(projectRelativeSource);
                            org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_outputDirectory);
                            target = _folder = this.project.getFolder((IPath)_path);
                        } else {
                            IFolder _folder_1;
                            IContainer _parent = container.getParent();
                            String _outputDirectory_1 = config.getOutputDirectory();
                            org.eclipse.core.runtime.Path _path_1 = new org.eclipse.core.runtime.Path(_outputDirectory_1);
                            target = _folder_1 = _parent.getFolder((IPath)_path_1);
                        }
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)container, (Object)target);
                        if (_notEquals_1) {
                            IPath _fullPath_2 = container.getFullPath();
                            String _string = _fullPath_2.toString();
                            Path _path_2 = new Path(_string);
                            IPath _fullPath_3 = target.getFullPath();
                            String _string_1 = _fullPath_3.toString();
                            Path _path_3 = new Path(_string_1);
                            map.put(_path_2, _path_3);
                        }
                    }
                    ++n2;
                }
            }
            return map;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

