/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.formatting2.RichStringFormatter;
import org.eclipse.xtend.core.formatting2.XtendFormatterPreferenceKeys;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendFormatter
extends XbaseWithAnnotationsFormatter {
    @Inject
    @Extension
    private XtendGrammarAccess _xtendGrammarAccess;
    @Inject
    private RichStringFormatter.Factory richStringFormatterFactory;

    protected void _format(XtendFile xtendFile, @Extension IFormattableDocument format) {
        boolean _notEquals;
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        format.prepend((EObject)xtendFile, (Procedures.Procedure1)_function);
        ISemanticRegion pkg = this.regionAccess.regionForFeature((EObject)xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.prepend(pkg, (Procedures.Procedure1)_function_1);
        ISemanticRegion pkgSemicolon = this.regionAccess.immediatelyFollowingKeyword((ISequentialRegion)pkg, ";");
        boolean bl = _notEquals = !Objects.equal((Object)pkgSemicolon, null);
        if (_notEquals) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            format.append(pkg, (Procedures.Procedure1)_function_2);
            format.append(pkgSemicolon, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesAfterPackageDecl);
        } else {
            format.append(pkg, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesAfterPackageDecl);
        }
        XImportSection _importSection = xtendFile.getImportSection();
        if (_importSection != null) {
            this.format(_importSection, format);
        }
        EList<XtendTypeDeclaration> _xtendTypes = xtendFile.getXtendTypes();
        for (XtendTypeDeclaration clazz : _xtendTypes) {
            boolean _notEquals_1;
            this.format(clazz, format);
            EList<XtendTypeDeclaration> _xtendTypes_1 = xtendFile.getXtendTypes();
            XtendTypeDeclaration _last = (XtendTypeDeclaration)IterableExtensions.last(_xtendTypes_1);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)clazz, (Object)_last);
            if (!_notEquals_1) continue;
            format.append((EObject)clazz, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenClasses);
        }
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.newLine();
            }
        };
        format.append((EObject)xtendFile, (Procedures.Procedure1)_function_3);
    }

    protected void formatAnnotations(XtendAnnotationTarget target, @Extension IFormattableDocument document, Procedures.Procedure1<? super IHiddenRegionFormatter> configKey) {
        EList<XAnnotation> _annotations = target.getAnnotations();
        boolean _isEmpty = _annotations.isEmpty();
        if (_isEmpty) {
            return;
        }
        EList<XAnnotation> _annotations_1 = target.getAnnotations();
        for (XAnnotation a : _annotations_1) {
            this.format(a, document);
            document.append((EObject)a, configKey);
        }
    }

    protected void _format(XtendClass clazz, @Extension IFormattableDocument format) {
        this.formatAnnotations(clazz, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(clazz, format);
        EList<JvmTypeParameter> _typeParameters = clazz.getTypeParameters();
        this.formatTypeParameters(clazz, (List<? extends JvmTypeParameter>)_typeParameters, format);
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)clazz, "class");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.append(_regionForKeyword, (Procedures.Procedure1)_function);
        ISemanticRegion _regionForKeyword_1 = this.regionAccess.regionForKeyword((EObject)clazz, "extends");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.surround(_regionForKeyword_1, (Procedures.Procedure1)_function_1);
        JvmTypeReference _extends = clazz.getExtends();
        this.format(_extends, format);
        ISemanticRegion _regionForKeyword_2 = this.regionAccess.regionForKeyword((EObject)clazz, "implements");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.surround(_regionForKeyword_2, (Procedures.Procedure1)_function_2);
        EList<JvmTypeReference> _implements = clazz.getImplements();
        for (JvmTypeReference imp : _implements) {
            ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)imp, ",");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_3);
            Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            format.append(_prepend, (Procedures.Procedure1)_function_4);
            this.format(imp, format);
        }
        this.formatBody(clazz, format);
    }

    protected ISemanticRegion formatTypeParameters(XtendMember member, List<? extends JvmTypeParameter> typeParameters, @Extension IFormattableDocument format) {
        boolean _not;
        ISemanticRegion _xifexpression = null;
        boolean _isEmpty = typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegion _xblockexpression = null;
            ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)member, "<");
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            format.surround(_regionForKeyword, (Procedures.Procedure1)_function);
            for (JvmTypeParameter jvmTypeParameter : typeParameters) {
                this.format(jvmTypeParameter, format);
                ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)jvmTypeParameter, ",");
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.noSpace();
                    }
                };
                ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_1);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                format.append(_prepend, (Procedures.Procedure1)_function_2);
            }
            ISemanticRegion iSemanticRegion = this.regionAccess.regionForKeyword((EObject)member, ">");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            _xifexpression = _xblockexpression = format.prepend(iSemanticRegion, (Procedures.Procedure1)_function_1);
        }
        return _xifexpression;
    }

    protected ISemanticRegion formatBody(XtendTypeDeclaration type, @Extension IFormattableDocument format) {
        boolean _not;
        ISemanticRegion _xblockexpression = null;
        ISemanticRegion clazzOpenBrace = this.regionAccess.regionForKeyword((EObject)type, "{");
        format.prepend(clazzOpenBrace, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        ISemanticRegion _xifexpression = null;
        EList<XtendMember> _members = type.getMembers();
        boolean _isEmpty = _members.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.increaseIndentation();
                }
            };
            format.append(clazzOpenBrace, (Procedures.Procedure1)_function);
            format.append(clazzOpenBrace, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBeforeFirstMember);
            EList<XtendMember> _members_1 = type.getMembers();
            int _size = _members_1.size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _lessThan;
                EList<XtendMember> _members_2 = type.getMembers();
                XtendMember current = (XtendMember)_members_2.get(i.intValue());
                this.format(current, format);
                EList<XtendMember> _members_3 = type.getMembers();
                int _size_1 = _members_3.size();
                int _minus_1 = _size_1 - 1;
                boolean bl2 = _lessThan = i < _minus_1;
                if (_lessThan) {
                    EList<XtendMember> _members_4 = type.getMembers();
                    XtendMember next = (XtendMember)_members_4.get(i + 1);
                    boolean _and = false;
                    _and = !(current instanceof XtendField) ? false : next instanceof XtendField;
                    if (_and) {
                        format.append((EObject)current, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenFields);
                        continue;
                    }
                    boolean _and_1 = false;
                    _and_1 = !(current instanceof XtendFunction) ? false : next instanceof XtendFunction;
                    if (_and_1) {
                        format.append((EObject)current, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenMethods);
                        continue;
                    }
                    format.append((EObject)current, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenFieldsAndMethods);
                    continue;
                }
                EList<XtendMember> _members_5 = type.getMembers();
                XtendMember member = (XtendMember)_members_5.get(i.intValue());
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.decreaseIndentation();
                    }
                };
                format.append((EObject)member, (Procedures.Procedure1)_function_1);
                format.append((EObject)member, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesAfterLastMember);
            }
        } else {
            ISemanticRegion _xifexpression_1 = null;
            IHiddenRegion _nextHiddenRegion = null;
            if (clazzOpenBrace != null) {
                _nextHiddenRegion = clazzOpenBrace.getNextHiddenRegion();
            }
            boolean _containsComment = false;
            if (_nextHiddenRegion != null) {
                _containsComment = _nextHiddenRegion.containsComment();
            }
            if (_containsComment) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.newLine();
                        it.increaseIndentation();
                        it.decreaseIndentation();
                    }
                };
                _xifexpression_1 = format.append(clazzOpenBrace, (Procedures.Procedure1)_function_1);
            } else {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.newLine();
                    }
                };
                _xifexpression_1 = format.append(clazzOpenBrace, (Procedures.Procedure1)_function_2);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void _format(XtendInterface interfaze, @Extension IFormattableDocument format) {
        this.formatAnnotations(interfaze, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(interfaze, format);
        EList<JvmTypeParameter> _typeParameters = interfaze.getTypeParameters();
        this.formatTypeParameters(interfaze, (List<? extends JvmTypeParameter>)_typeParameters, format);
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)interfaze, "interface");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.append(_regionForKeyword, (Procedures.Procedure1)_function);
        ISemanticRegion _regionForKeyword_1 = this.regionAccess.regionForKeyword((EObject)interfaze, "extends");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.surround(_regionForKeyword_1, (Procedures.Procedure1)_function_1);
        EList<JvmTypeReference> _extends = interfaze.getExtends();
        for (JvmTypeReference imp : _extends) {
            ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)imp, ",");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_2);
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            format.append(_prepend, (Procedures.Procedure1)_function_3);
            this.format(imp, format);
        }
        this.formatBody(interfaze, format);
    }

    protected void _format(XtendAnnotationType annotationType, @Extension IFormattableDocument format) {
        this.formatAnnotations(annotationType, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(annotationType, format);
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)annotationType, "annotation");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.append(_regionForKeyword, (Procedures.Procedure1)_function);
        this.formatBody(annotationType, format);
    }

    protected void _format(XtendEnum enumeration, @Extension IFormattableDocument format) {
        boolean _not;
        this.formatAnnotations(enumeration, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(enumeration, format);
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)enumeration, "enum");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.append(_regionForKeyword, (Procedures.Procedure1)_function);
        ISemanticRegion clazzOpenBrace = this.regionAccess.regionForKeyword((EObject)enumeration, "{");
        format.prepend(clazzOpenBrace, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        EList<XtendMember> _members = enumeration.getMembers();
        boolean _isEmpty = _members.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.increaseIndentation();
                }
            };
            format.append(clazzOpenBrace, (Procedures.Procedure1)_function_1);
            format.append(clazzOpenBrace, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBeforeFirstMember);
            EList<XtendMember> _members_1 = enumeration.getMembers();
            int _size = _members_1.size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _lessThan;
                EList<XtendMember> _members_2 = enumeration.getMembers();
                XtendMember current = (XtendMember)_members_2.get(i.intValue());
                this.format(current, format);
                EList<XtendMember> _members_3 = enumeration.getMembers();
                int _size_1 = _members_3.size();
                int _minus_1 = _size_1 - 1;
                boolean bl2 = _lessThan = i < _minus_1;
                if (_lessThan) {
                    ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)current, ",");
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                        public void apply(IHiddenRegionFormatter it) {
                            it.noSpace();
                        }
                    };
                    ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_2);
                    format.append(_prepend, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenEnumLiterals);
                    continue;
                }
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.decreaseIndentation();
                    }
                };
                format.append((EObject)current, (Procedures.Procedure1)_function_3);
                format.append((EObject)current, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesAfterLastMember);
            }
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.newLine();
                }
            };
            format.append(clazzOpenBrace, (Procedures.Procedure1)_function_2);
        }
    }

    protected void _format(XtendConstructor func, @Extension IFormattableDocument format) {
        boolean _not;
        this.formatAnnotations(func, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterConstructorAnnotations);
        this.formatModifiers(func, format);
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)func, "new");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        format.append(_regionForKeyword, (Procedures.Procedure1)_function);
        EList<JvmTypeParameter> _typeParameters = func.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegion _regionForKeyword_1 = this.regionAccess.regionForKeyword((EObject)func, "<");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            format.append(_regionForKeyword_1, (Procedures.Procedure1)_function_1);
            EList<JvmTypeParameter> _typeParameters_1 = func.getTypeParameters();
            for (JvmTypeParameter arg : _typeParameters_1) {
                this.format(arg, format);
                ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)arg, ",");
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.noSpace();
                    }
                };
                ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_2);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                format.append(_prepend, (Procedures.Procedure1)_function_3);
            }
            ISemanticRegion _regionForKeyword_2 = this.regionAccess.regionForKeyword((EObject)func, ">");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            format.surround(_regionForKeyword_2, (Procedures.Procedure1)_function_2);
        }
        ISemanticRegion open = this.regionAccess.regionForKeyword((EObject)func, "(");
        ISemanticRegion close = this.regionAccess.regionForKeyword((EObject)func, ")");
        format.append(close, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        EList<XtendParameter> _parameters = func.getParameters();
        this.formatCommaSeparatedList((Collection)_parameters, open, close, format);
        XExpression _expression = func.getExpression();
        this.format(_expression, format);
    }

    protected void _format(XtendFunction func, @Extension IFormattableDocument format) {
        boolean _notEquals;
        boolean _not;
        this.formatAnnotations(func, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterMethodAnnotations);
        this.formatModifiers(func, format);
        EList<JvmTypeParameter> _typeParameters = func.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)func, "<");
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            format.append(_regionForKeyword, (Procedures.Procedure1)_function);
            EList<JvmTypeParameter> _typeParameters_1 = func.getTypeParameters();
            for (JvmTypeParameter arg : _typeParameters_1) {
                this.format(arg, format);
                ISemanticRegion _immediatelyFollowingKeyword = this.regionAccess.immediatelyFollowingKeyword((EObject)arg, ",");
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.noSpace();
                    }
                };
                ISemanticRegion _prepend = format.prepend(_immediatelyFollowingKeyword, (Procedures.Procedure1)_function_1);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                format.append(_prepend, (Procedures.Procedure1)_function_2);
            }
            ISemanticRegion _regionForKeyword_1 = this.regionAccess.regionForKeyword((EObject)func, ">");
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            ISemanticRegion _prepend = format.prepend(_regionForKeyword_1, (Procedures.Procedure1)_function_1);
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            format.append(_prepend, (Procedures.Procedure1)_function_2);
        }
        ISemanticRegion nameNode = this.regionAccess.regionForFeature((EObject)func, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME);
        ISemanticRegion open = this.regionAccess.immediatelyFollowingKeyword((ISequentialRegion)nameNode, "(");
        ISemanticRegion close = this.regionAccess.regionForKeyword((EObject)func, ")");
        JvmTypeReference _returnType = func.getReturnType();
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.append((EObject)_returnType, (Procedures.Procedure1)_function_3);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        format.prepend(open, (Procedures.Procedure1)_function_4);
        XExpression _expression = func.getExpression();
        boolean bl2 = _notEquals = !Objects.equal((Object)_expression, null);
        if (_notEquals) {
            format.append(close, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        }
        EList<XtendParameter> _parameters = func.getParameters();
        this.formatCommaSeparatedList((Collection)_parameters, open, close, format);
        JvmTypeReference _returnType_1 = func.getReturnType();
        this.format(_returnType_1, format);
        XExpression _expression_1 = func.getExpression();
        this.format(_expression_1, format);
    }

    protected void _format(XtendField field, @Extension IFormattableDocument document) {
        boolean _notEquals;
        this.formatAnnotations(field, document, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterFieldAnnotations);
        this.formatModifiers(field, document);
        String _name = field.getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
        if (_notEquals) {
            JvmTypeReference _type = field.getType();
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            document.append((EObject)_type, (Procedures.Procedure1)_function);
        }
        ISemanticRegion _regionForKeyword = this.regionAccess.regionForKeyword((EObject)field, "=");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        ISemanticRegion _prepend = document.prepend(_regionForKeyword, (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(_prepend, (Procedures.Procedure1)_function_2);
        JvmTypeReference _type_1 = field.getType();
        this.format(_type_1, document);
        XExpression _initialValue = field.getInitialValue();
        this.format(_initialValue, document);
    }

    protected void _format(XtendParameter param, @Extension IFormattableDocument format) {
        this.formatAnnotations(param, format, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.newLineAfterParameterAnnotations);
        JvmTypeReference _parameterType = param.getParameterType();
        this.format(_parameterType, format);
        ISemanticRegion nameNode = this.regionAccess.regionForFeature((EObject)param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__NAME);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        format.prepend(nameNode, (Procedures.Procedure1)_function);
    }

    protected void _format(RichString rs, @Extension IFormattableDocument format) {
        FormatterRequest _request = this.getRequest();
        ITextRegionAccess _textRegionAccess = _request.getTextRegionAccess();
        RichStringFormatter richStringFormatter = this.richStringFormatterFactory.create(_textRegionAccess);
        richStringFormatter.format((EObject)rs, format);
    }

    protected void _format(AnonymousClass anonymousClass, @Extension IFormattableDocument format) {
        XConstructorCall _constructorCall = anonymousClass.getConstructorCall();
        this.format(_constructorCall, format);
        this.formatBody(anonymousClass, format);
    }

    protected void formatModifiers(XtendMember member, final @Extension IFormattableDocument document) {
        ParserRule _commonModifierRule = this._xtendGrammarAccess.getCommonModifierRule();
        ParserRule _methodModifierRule = this._xtendGrammarAccess.getMethodModifierRule();
        ParserRule _fieldModifierRule = this._xtendGrammarAccess.getFieldModifierRule();
        List _regionsForRuleCallsTo = this.regionAccess.regionsForRuleCallsTo((EObject)member, new AbstractRule[]{_commonModifierRule, _methodModifierRule, _fieldModifierRule});
        Procedures.Procedure1<ISemanticRegion> _function = new Procedures.Procedure1<ISemanticRegion>(){

            public void apply(ISemanticRegion it) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(it, (Procedures.Procedure1)_function);
            }
        };
        IterableExtensions.forEach((Iterable)_regionsForRuleCallsTo, (Procedures.Procedure1)_function);
    }

    protected boolean isSingleLineBlock(XBlockExpression expr) {
        IHiddenRegion _trailingHiddenRegion;
        ISemanticRegion _immediatelyPrecedingKeyword;
        IHiddenRegion _previousHiddenRegion;
        boolean _isMultiline;
        boolean _not;
        boolean _lessEqualsThan;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        EList _expressions = expr.getExpressions();
        int _size = _expressions.size();
        boolean bl = _lessEqualsThan = _size <= 1;
        if (!_lessEqualsThan) {
            _and_2 = false;
        } else {
            ITypedPreferenceValues _preferences = this.getPreferences();
            Boolean _preference = (Boolean)_preferences.getPreference((TypedPreferenceKey)XtendFormatterPreferenceKeys.keepOneLineMethods);
            _and_2 = _preference;
        }
        if (!_and_2) {
            _and_1 = false;
        } else {
            EObject _eContainer = expr.eContainer();
            _and_1 = _eContainer instanceof XtendFunction;
        }
        _and = !_and_1 ? false : (_not = !(_isMultiline = (_previousHiddenRegion = (_immediatelyPrecedingKeyword = this.regionAccess.immediatelyPrecedingKeyword((ISequentialRegion)(_trailingHiddenRegion = this.regionAccess.trailingHiddenRegion((EObject)expr)), "}")).getPreviousHiddenRegion()).isMultiline()));
        return _and;
    }

    protected XClosure builder(List<XExpression> params) {
        boolean _notEquals;
        XClosure _xifexpression = null;
        XExpression _last = (XExpression)IterableExtensions.last(params);
        boolean bl = _notEquals = !Objects.equal((Object)_last, null);
        if (_notEquals) {
            XClosure _xblockexpression = null;
            XExpression _last_1 = (XExpression)IterableExtensions.last(params);
            AbstractElement grammarElement = this.regionAccess.getInvokingGrammarElement((EObject)_last_1);
            XClosure _xifexpression_1 = null;
            boolean _or = false;
            boolean _or_1 = false;
            XbaseGrammarAccess.XMemberFeatureCallElements _xMemberFeatureCallAccess = this._xtendGrammarAccess.getXMemberFeatureCallAccess();
            RuleCall _memberCallArgumentsXClosureParserRuleCall_1_1_4_0 = _xMemberFeatureCallAccess.getMemberCallArgumentsXClosureParserRuleCall_1_1_4_0();
            boolean _equals = Objects.equal((Object)grammarElement, (Object)_memberCallArgumentsXClosureParserRuleCall_1_1_4_0);
            if (_equals) {
                _or_1 = true;
            } else {
                boolean _equals_1;
                XbaseGrammarAccess.XFeatureCallElements _xFeatureCallAccess = this._xtendGrammarAccess.getXFeatureCallAccess();
                RuleCall _featureCallArgumentsXClosureParserRuleCall_4_0 = _xFeatureCallAccess.getFeatureCallArgumentsXClosureParserRuleCall_4_0();
                _or_1 = _equals_1 = Objects.equal((Object)grammarElement, (Object)_featureCallArgumentsXClosureParserRuleCall_4_0);
            }
            if (_or_1) {
                _or = true;
            } else {
                boolean _equals_2;
                XtendGrammarAccess.XbaseConstructorCallElements _xbaseConstructorCallAccess = this._xtendGrammarAccess.getXbaseConstructorCallAccess();
                RuleCall _argumentsXClosureParserRuleCall_5_0 = _xbaseConstructorCallAccess.getArgumentsXClosureParserRuleCall_5_0();
                _or = _equals_2 = Objects.equal((Object)grammarElement, (Object)_argumentsXClosureParserRuleCall_5_0);
            }
            if (_or) {
                XExpression _last_2 = (XExpression)IterableExtensions.last(params);
                _xifexpression_1 = (XClosure)_last_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public void format(Object anonymousClass, IFormattableDocument format) {
        if (anonymousClass instanceof AnonymousClass) {
            this._format((AnonymousClass)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendAnnotationType) {
            this._format((XtendAnnotationType)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendClass) {
            this._format((XtendClass)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendConstructor) {
            this._format((XtendConstructor)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendEnum) {
            this._format((XtendEnum)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendFunction) {
            this._format((XtendFunction)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendInterface) {
            this._format((XtendInterface)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmTypeParameter) {
            this._format((JvmTypeParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof RichString) {
            this._format((RichString)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendField) {
            this._format((XtendField)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmFormalParameter) {
            this._format((JvmFormalParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtextResource) {
            this._format((XtextResource)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XAssignment) {
            this._format((XAssignment)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBinaryOperation) {
            this._format((XBinaryOperation)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XDoWhileExpression) {
            this._format((XDoWhileExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XFeatureCall) {
            this._format((XFeatureCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XMemberFeatureCall) {
            this._format((XMemberFeatureCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XWhileExpression) {
            this._format((XWhileExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XFunctionTypeRef) {
            this._format((XFunctionTypeRef)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendParameter) {
            this._format((XtendParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmGenericArrayTypeReference) {
            this._format((JvmGenericArrayTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmParameterizedTypeReference) {
            this._format((JvmParameterizedTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmWildcardTypeReference) {
            this._format((JvmWildcardTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBasicForLoopExpression) {
            this._format((XBasicForLoopExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBlockExpression) {
            this._format((XBlockExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XClosure) {
            this._format((XClosure)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XCollectionLiteral) {
            this._format((XCollectionLiteral)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XConstructorCall) {
            this._format((XConstructorCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XForLoopExpression) {
            this._format((XForLoopExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XIfExpression) {
            this._format((XIfExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XInstanceOfExpression) {
            this._format((XInstanceOfExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XReturnExpression) {
            this._format((XReturnExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XSwitchExpression) {
            this._format((XSwitchExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XSynchronizedExpression) {
            this._format((XSynchronizedExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XThrowExpression) {
            this._format((XThrowExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XTryCatchFinallyExpression) {
            this._format((XTryCatchFinallyExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XTypeLiteral) {
            this._format((XTypeLiteral)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XVariableDeclaration) {
            this._format((XVariableDeclaration)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XAnnotation) {
            this._format((XAnnotation)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendFile) {
            this._format((XtendFile)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmTypeConstraint) {
            this._format((JvmTypeConstraint)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XCatchClause) {
            this._format((XCatchClause)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XExpression) {
            this._format((XExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XImportDeclaration) {
            this._format((XImportDeclaration)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XImportSection) {
            this._format((XImportSection)anonymousClass, format);
            return;
        }
        if (anonymousClass == null) {
            this._format(null, format);
            return;
        }
        if (anonymousClass != null) {
            this._format(anonymousClass, format);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(anonymousClass, format).toString());
    }
}

