/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.linking;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.linking.XbaseLazyLinker;

public class Linker
extends XbaseLazyLinker {
    @Inject
    private IValueConverterService valueConverterService;

    protected boolean shouldCheckParentNode(INode node) {
        return false;
    }

    protected boolean isClearAllReferencesRequired(Resource resource) {
        return ResourceSetContext.get((Notifier)resource).isEditor();
    }

    protected boolean hasLeafNodes(INode node) {
        if (node.getTotalLength() > 0) {
            return true;
        }
        if (node instanceof ICompositeNode) {
            return ((ICompositeNode)node).getLastChild() instanceof ILeafNode;
        }
        return false;
    }

    protected void afterCreateAndSetProxy(EObject obj, INode node, EReference eRef, CrossReference xref, IDiagnosticProducer diagnosticProducer) {
        AbstractElement terminal = xref.getTerminal();
        if (!(terminal instanceof RuleCall)) {
            throw new IllegalArgumentException(String.valueOf(xref));
        }
        AbstractRule rule = ((RuleCall)terminal).getRule();
        try {
            String tokenText = NodeModelUtils.getTokenText((INode)node);
            this.valueConverterService.toValue(tokenText, rule.getName(), node);
        }
        catch (ValueConverterException e) {
            diagnosticProducer.addDiagnostic(new DiagnosticMessage(e.getMessage(), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Syntax", Strings.EMPTY_ARRAY));
        }
    }

    protected EClass getProxyType(EObject obj, EReference eRef) {
        EClass referenceType = eRef.getEReferenceType();
        if (referenceType == TypesPackage.Literals.JVM_TYPE || referenceType == TypesPackage.Literals.JVM_IDENTIFIABLE_ELEMENT) {
            return TypesPackage.Literals.JVM_VOID;
        }
        if (referenceType == TypesPackage.Literals.JVM_DECLARED_TYPE) {
            return TypesPackage.Literals.JVM_GENERIC_TYPE;
        }
        return referenceType;
    }
}

