/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmEnumerationTypeDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MutableJvmEnumerationTypeDeclarationImpl
extends JvmEnumerationTypeDeclarationImpl
implements MutableEnumerationTypeDeclaration {
    public void markAsRead() {
        this.checkMutable();
        this.getCompilationUnit().getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    public MutableMethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _findDeclaredMethod = super.findDeclaredMethod(name, parameterTypes);
        return (MutableMethodDeclaration)_findDeclaredMethod;
    }

    public MutableFieldDeclaration findDeclaredField(String name) {
        FieldDeclaration _findDeclaredField = super.findDeclaredField(name);
        return (MutableFieldDeclaration)_findDeclaredField;
    }

    public MutableTypeDeclaration findDeclaredType(String name) {
        TypeDeclaration _findDeclaredType = super.findDeclaredType(name);
        return (MutableTypeDeclaration)_findDeclaredType;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _findDeclaredConstructor = super.findDeclaredConstructor(parameterTypes);
        return (MutableConstructorDeclaration)_findDeclaredConstructor;
    }

    @Override
    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MethodDeclaration> _declaredMethods = super.getDeclaredMethods();
        return _declaredMethods;
    }

    @Override
    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<FieldDeclaration> _declaredFields = super.getDeclaredFields();
        return _declaredFields;
    }

    @Override
    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<ClassDeclaration> _declaredClasses = super.getDeclaredClasses();
        return _declaredClasses;
    }

    @Override
    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<ConstructorDeclaration> _declaredConstructors = super.getDeclaredConstructors();
        return _declaredConstructors;
    }

    @Override
    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<InterfaceDeclaration> _declaredInterfaces = super.getDeclaredInterfaces();
        return _declaredInterfaces;
    }

    @Override
    public Iterable<? extends MutableAnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        Iterable<AnnotationTypeDeclaration> _declaredAnnotationTypes = super.getDeclaredAnnotationTypes();
        return _declaredAnnotationTypes;
    }

    @Override
    public Iterable<? extends MutableEnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        Iterable<EnumerationTypeDeclaration> _declaredEnumerationTypes = super.getDeclaredEnumerationTypes();
        return _declaredEnumerationTypes;
    }

    @Override
    public Iterable<? extends MutableTypeDeclaration> getDeclaredTypes() {
        Iterable<TypeDeclaration> _declaredTypes = super.getDeclaredTypes();
        return _declaredTypes;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        Iterable<MemberDeclaration> _declaredMembers = super.getDeclaredMembers();
        return _declaredMembers;
    }

    public Iterable<? extends MutableEnumerationValueDeclaration> getDeclaredValues() {
        return Iterables.filter(this.getDeclaredMembers(), MutableEnumerationValueDeclaration.class);
    }

    public MutableEnumerationValueDeclaration findDeclaredValue(String name) {
        Functions.Function1 _function = value -> {
            String _simpleName = value.getSimpleName();
            return Objects.equals(_simpleName, name);
        };
        return (MutableEnumerationValueDeclaration)IterableExtensions.findFirst(this.getDeclaredValues(), (Functions.Function1)_function);
    }

    public MutableEnumerationValueDeclaration addValue(String name, Procedures.Procedure1<MutableEnumerationValueDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        Preconditions.checkArgument((initializer != null ? 1 : 0) != 0, (Object)"initializer cannot be null");
        JvmEnumerationLiteral jvmLiteral = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        jvmLiteral.setSimpleName(name);
        jvmLiteral.setVisibility(JvmVisibility.PUBLIC);
        ((JvmEnumerationType)this.getDelegate()).getMembers().add((Object)jvmLiteral);
        MemberDeclaration _memberDeclaration = this.getCompilationUnit().toMemberDeclaration((JvmMember)jvmLiteral);
        MutableEnumerationValueDeclaration mutableEnumerationValueDeclaration = (MutableEnumerationValueDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableEnumerationValueDeclaration);
        return mutableEnumerationValueDeclaration;
    }
}

