/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.internal.AbstractTrace;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.workspace.IProjectConfig;

public abstract class AbstractLocationInResource
implements ILocationInResource {
    private final AbstractTrace trace;
    private AbsoluteURI absoluteURI;

    protected AbstractLocationInResource(AbstractTrace trace) {
        this.trace = trace;
    }

    @Override
    public abstract SourceRelativeURI getSrcRelativeResourceURI();

    protected abstract int getOffset();

    protected abstract int getLength();

    protected abstract int getLineNumber();

    protected abstract int getEndLineNumber();

    @Override
    public ITextRegionWithLineInformation getTextRegion() {
        TextRegionWithLineInformation result = new TextRegionWithLineInformation(this.getOffset(), this.getLength(), this.getLineNumber(), this.getEndLineNumber());
        return result;
    }

    @Override
    public AbsoluteURI getAbsoluteResourceURI() {
        if (this.absoluteURI == null) {
            this.absoluteURI = this.trace.resolvePath(this.getSrcRelativeResourceURI());
        }
        return this.absoluteURI;
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.trace.getContents(this.getSrcRelativeResourceURI());
    }

    @Override
    public IProjectConfig getProjectConfig() {
        return this.trace.getLocalProjectConfig();
    }

    @Override
    public LanguageInfo getLanguage() {
        LanguageInfo result = this.trace.findLanguage(this.getAbsoluteResourceURI());
        return result;
    }

    protected AbstractTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " @ " + this.getTextRegion();
    }
}

