/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;

public abstract class AbstractCompositeHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2,
ISourceViewerAware {
    private List<ITextHover> hovers;
    private ITextHover currentHover;

    public List<ITextHover> getHovers() {
        if (this.hovers == null) {
            this.hovers = this.createHovers();
        }
        return this.hovers;
    }

    protected abstract List<ITextHover> createHovers();

    @Override
    public void setSourceViewer(ISourceViewer sourceViewer) {
        if (this.getHovers() != null) {
            for (ITextHover hover : this.getHovers()) {
                if (!(hover instanceof ISourceViewerAware)) continue;
                ((ISourceViewerAware)hover).setSourceViewer(sourceViewer);
            }
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.getHovers() != null) {
            for (ITextHover hover : this.getHovers()) {
                IRegion region = hover.getHoverRegion(textViewer, offset);
                if (region == null) continue;
                this.currentHover = hover;
                return region;
            }
        }
        this.currentHover = null;
        return null;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.currentHover != null) {
            return this.currentHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.currentHover != null) {
            if (this.currentHover instanceof ITextHoverExtension2) {
                return ((ITextHoverExtension2)this.currentHover).getHoverInfo2(textViewer, hoverRegion);
            }
            return this.currentHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.currentHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.currentHover).getHoverControlCreator();
        }
        return null;
    }
}

