/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.XtextStandaloneSetup;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.MergeableManifest2;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorException;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.LanguageModule;
import org.eclipse.xtext.xtext.generator.MweIssues;
import org.eclipse.xtext.xtext.generator.XtextDirectoryCleaner;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.XtextGeneratorStandaloneSetup;
import org.eclipse.xtext.xtext.generator.XtextGeneratorTemplates;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextGenerator
extends AbstractWorkflowComponent2 {
    private static final Logger LOG = Logger.getLogger(XtextGenerator.class);
    private DefaultGeneratorModule configuration = new DefaultGeneratorModule();
    private final List<XtextGeneratorLanguage> languageConfigs = new ArrayList<XtextGeneratorLanguage>();
    private XtextDirectoryCleaner cleaner = new XtextDirectoryCleaner();
    private XtextGeneratorStandaloneSetup standaloneSetup = new XtextGeneratorStandaloneSetup();
    private String grammarEncoding;
    private Injector injector;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private XtextGeneratorTemplates templates;
    @Inject
    private XtextGeneratorNaming naming;
    @Inject
    private CodeConfig codeConfig;

    public DefaultGeneratorModule getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DefaultGeneratorModule configuration) {
        this.configuration = configuration;
    }

    public List<XtextGeneratorLanguage> getLanguageConfigs() {
        return this.languageConfigs;
    }

    public XtextDirectoryCleaner getCleaner() {
        return this.cleaner;
    }

    public void setCleaner(XtextDirectoryCleaner cleaner) {
        this.cleaner = cleaner;
    }

    public XtextGeneratorStandaloneSetup getStandaloneSetup() {
        return this.standaloneSetup;
    }

    public void setStandaloneSetup(XtextGeneratorStandaloneSetup standaloneSetup) {
        this.standaloneSetup = standaloneSetup;
    }

    public String getGrammarEncoding() {
        return this.grammarEncoding;
    }

    public void setGrammarEncoding(String grammarEncoding) {
        this.grammarEncoding = grammarEncoding;
    }

    public XtextGenerator() {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    public void addLanguage(XtextGeneratorLanguage language) {
        this.languageConfigs.add(language);
    }

    protected void checkConfigurationInternal(Issues issues) {
        this.initialize();
        MweIssues generatorIssues = new MweIssues(this, issues);
        this.configuration.checkConfiguration(generatorIssues);
        HashMap<String, Grammar> uris = new HashMap<String, Grammar>();
        for (XtextGeneratorLanguage language : this.languageConfigs) {
            language.checkConfiguration(generatorIssues);
            for (GeneratedMetamodel generatedMetamodel : Iterables.filter((Iterable)language.getGrammar().getMetamodelDeclarations(), GeneratedMetamodel.class)) {
                String nsURI = generatedMetamodel.getEPackage().getNsURI();
                if (uris.containsKey(nsURI)) {
                    generatorIssues.addError("Duplicate generated grammar with nsURI '" + nsURI + "' in " + ((Grammar)uris.get(nsURI)).getName() + " and " + language.getGrammar().getName());
                    continue;
                }
                uris.put(nsURI, language.getGrammar());
            }
        }
    }

    public void initialize() {
        if (this.injector == null) {
            LOG.info((Object)"Initializing Xtext generator");
            new StandaloneSetup().addRegisterGeneratedEPackage("org.eclipse.xtext.common.types.TypesPackage");
            this.initializeEncoding();
            this.injector = this.createInjector();
            this.injector.injectMembers((Object)this);
            ((CodeConfig)this.injector.getInstance(CodeConfig.class)).initialize(this.injector);
            this.projectConfig.initialize(this.injector);
            this.cleaner.initialize(this.injector);
            this.standaloneSetup.initialize(this.injector);
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                Injector languageInjector = this.createLanguageInjector(this.injector, language);
                language.initialize(languageInjector);
            }
        }
    }

    protected void initializeEncoding() {
        IEncodingProvider encodingProvider;
        IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
        IResourceServiceProvider serviceProvider = (IResourceServiceProvider)serviceProviderRegistry.getExtensionToFactoryMap().get("xtext");
        String encoding = null;
        encoding = this.grammarEncoding != null ? this.grammarEncoding : this.configuration.getCode().getEncoding();
        if (serviceProvider != null && encoding != null && (encodingProvider = (IEncodingProvider)serviceProvider.get(IEncodingProvider.class)) instanceof IEncodingProvider.Runtime) {
            ((IEncodingProvider.Runtime)encodingProvider).setDefaultEncoding(encoding);
        }
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{this.configuration});
    }

    protected Injector createLanguageInjector(Injector parent, XtextGeneratorLanguage language) {
        return parent.createChildInjector(new Module[]{new LanguageModule(language)});
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.initialize();
        try {
            this.cleaner.clean();
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                try {
                    LOG.info((Object)("Generating " + language.getGrammar().getName()));
                    language.generate();
                    this.generateSetups(language);
                    this.generateModules(language);
                    this.generateExecutableExtensionFactory(language);
                }
                catch (Exception e) {
                    this.handleException(e, issues);
                }
            }
            LOG.info((Object)"Generating common infrastructure");
            this.generatePluginXmls();
            this.generateManifests();
            this.generateActivator();
            this.generateServices();
        }
        catch (Exception e) {
            this.handleException(e, issues);
        }
    }

    private void handleException(Exception ex, Issues issues) {
        if (ex instanceof CompositeGeneratorException) {
            ((CompositeGeneratorException)ex).getExceptions().forEach(it -> this.handleException((Exception)it, issues));
        } else {
            issues.addError((WorkflowComponent)this, "GeneratorException: ", null, (Throwable)ex, null);
        }
    }

    protected void generateSetups(IXtextGeneratorLanguage language) {
        this.templates.createRuntimeGenSetup(language).writeTo(this.projectConfig.getRuntime().getSrcGen());
        this.templates.createRuntimeSetup(language).writeTo(this.projectConfig.getRuntime().getSrc());
        this.templates.createIdeSetup(language).writeTo(this.projectConfig.getGenericIde().getSrc());
        this.templates.createWebSetup(language).writeTo(this.projectConfig.getWeb().getSrc());
    }

    protected void generateModules(IXtextGeneratorLanguage language) {
        this.templates.createRuntimeGenModule(language).writeTo(this.projectConfig.getRuntime().getSrcGen());
        this.templates.createRuntimeModule(language).writeTo(this.projectConfig.getRuntime().getSrc());
        this.templates.createIdeModule(language).writeTo(this.projectConfig.getGenericIde().getSrc());
        this.templates.createIdeGenModule(language).writeTo(this.projectConfig.getGenericIde().getSrcGen());
        this.templates.createEclipsePluginGenModule(language).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        this.templates.createEclipsePluginModule(language).writeTo(this.projectConfig.getEclipsePlugin().getSrc());
        this.templates.createWebGenModule(language).writeTo(this.projectConfig.getWeb().getSrcGen());
        this.templates.createWebModule(language).writeTo(this.projectConfig.getWeb().getSrc());
    }

    protected void generateExecutableExtensionFactory(IXtextGeneratorLanguage language) {
        if (this.projectConfig.getEclipsePlugin().getSrcGen() != null) {
            XtextGeneratorLanguage firstLanguageConfig = (XtextGeneratorLanguage)Iterables.getFirst(this.languageConfigs, null);
            this.templates.createEclipsePluginExecutableExtensionFactory(language, firstLanguageConfig).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        }
    }

    protected void generateManifests() {
        try {
            Iterable bundleProjects = Iterables.filter(this.projectConfig.getEnabledProjects(), BundleProjectConfig.class);
            List manifests = IterableExtensions.toList((Iterable)Iterables.transform((Iterable)bundleProjects, it -> Tuples.create((Object)it.getManifest(), (Object)it.getMetaInf(), (Object)it.getName())));
            HashMap uri2Manifest = Maps.newHashMapWithExpectedSize((int)manifests.size());
            ListIterator manifestIter = manifests.listIterator();
            while (manifestIter.hasNext()) {
                URI uri;
                Triple entry = (Triple)manifestIter.next();
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                if (manifest == null || metaInf == null) {
                    manifestIter.remove();
                    continue;
                }
                if (manifest.getActivator() == null && manifest == this.projectConfig.getEclipsePlugin().getManifest()) {
                    manifest.setActivator(this.naming.getEclipsePluginActivator());
                }
                if (uri2Manifest.containsKey(uri = metaInf.getURI(manifest.getPath()))) {
                    ((ManifestAccess)uri2Manifest.get(uri)).merge(manifest);
                    manifestIter.remove();
                    continue;
                }
                uri2Manifest.put(uri, manifest);
            }
            for (Triple entry : manifests) {
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                if (manifest.getBundleName() == null) {
                    manifest.setBundleName((String)entry.getThird());
                }
                if (metaInf.isFile(manifest.getPath())) {
                    if (manifest.isMerge()) {
                        this.mergeManifest(manifest, metaInf);
                        continue;
                    }
                    if (!manifest.getPath().endsWith(".MF")) continue;
                    manifest.setPath(String.valueOf(manifest.getPath()) + "_gen");
                    manifest.writeTo(metaInf);
                    continue;
                }
                manifest.writeTo(metaInf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void mergeManifest(ManifestAccess manifest, IXtextGeneratorFileSystemAccess metaInf) throws IOException {
        try (InputStream in = null;){
            in = metaInf.readBinaryFile(manifest.getPath());
            MergeableManifest2 merge = new MergeableManifest2(in, manifest.getBundleName());
            merge.setLineDelimiter(this.codeConfig.getLineDelimiter());
            merge.addExportedPackages(manifest.getExportedPackages());
            merge.addRequiredBundles(manifest.getRequiredBundles());
            merge.addImportedPackages(manifest.getImportedPackages());
            if (manifest.getActivator() != null && Strings.isNullOrEmpty((String)merge.getBundleActivator())) {
                merge.setBundleActivator(manifest.getActivator().getName());
            }
            if (merge.isModified()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                merge.write((OutputStream)out);
                metaInf.generateFile(manifest.getPath(), new ByteArrayInputStream(out.toByteArray()));
            }
        }
    }

    protected void generateServices() {
        if (this.projectConfig.getGenericIde().getSrcGen() == null || this.languageConfigs.isEmpty()) {
            return;
        }
        this.templates.createMetaInfServices(this.languageConfigs).writeTo(this.projectConfig.getGenericIde().getSrcGen());
    }

    protected void generateActivator() {
        if (this.projectConfig.getEclipsePlugin().getSrcGen() != null && !this.languageConfigs.isEmpty()) {
            this.templates.createEclipsePluginActivator(this.projectConfig, this.languageConfigs).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        }
    }

    protected void generatePluginXmls() {
        Iterable bundleProjects = Iterables.filter(this.projectConfig.getEnabledProjects(), BundleProjectConfig.class);
        List pluginXmls = IterableExtensions.toList((Iterable)Iterables.transform((Iterable)bundleProjects, it -> Pair.of((Object)it.getPluginXml(), (Object)it.getRoot())));
        HashMap uri2PluginXml = Maps.newHashMapWithExpectedSize((int)pluginXmls.size());
        ListIterator pluginXmlIter = pluginXmls.listIterator();
        while (pluginXmlIter.hasNext()) {
            Pair entry = (Pair)pluginXmlIter.next();
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            if (pluginXml == null || root == null) {
                pluginXmlIter.remove();
                continue;
            }
            URI uri = root.getURI(pluginXml.getPath());
            if (uri2PluginXml.containsKey(uri)) {
                ((PluginXmlAccess)uri2PluginXml.get(uri)).merge(pluginXml);
                pluginXmlIter.remove();
                continue;
            }
            uri2PluginXml.put(uri, pluginXml);
        }
        for (Pair entry : pluginXmls) {
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            if (root.isFile(pluginXml.getPath())) {
                if (pluginXml.getEntries().isEmpty()) continue;
                String textFileContent = null;
                CharSequence textFile = root.readTextFile(pluginXml.getPath());
                if (textFile != null) {
                    textFileContent = textFile.toString();
                }
                if (Objects.equal((Object)textFileContent, (Object)pluginXml.getContentString()) || !pluginXml.getPath().endsWith(".xml")) continue;
                pluginXml.setPath(String.valueOf(pluginXml.getPath()) + "_gen");
                pluginXml.writeTo(root);
                continue;
            }
            pluginXml.writeTo(root);
        }
    }
}

