/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.scoping.AbstractKnownTypesScope;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;

public class KnownTypesScope
extends AbstractKnownTypesScope {
    private final List<? extends JvmType> types;

    public KnownTypesScope(List<? extends JvmType> types, AbstractScope parent) {
        super(parent);
        this.types = types;
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        int i = 0;
        while (i < this.types.size()) {
            JvmType knownType = this.types.get(i);
            if (EcoreUtil.isAncestor((EObject)knownType, (EObject)type)) {
                this.doGetDescriptions(type, knownType, i, result);
            }
            ++i;
        }
        super.doGetElements(type, result);
    }

    @Override
    protected IEObjectDescription doGetSingleElement(QualifiedName name, String firstSegment, int dollarIndex) {
        int index = -1;
        JvmType result = null;
        int i = 0;
        while (i < this.types.size()) {
            JvmType type = this.types.get(i);
            JvmType exactMatch = this.getExactMatch(type, index, name);
            if (exactMatch != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)exactMatch);
            }
            if (this.isMatch(i, type, firstSegment, name)) {
                JvmType resolved = this.getUnambiguousResult(result, index, type, i, name);
                if (resolved == null) {
                    return null;
                }
                if (resolved != result) {
                    result = resolved;
                    index = i;
                }
            }
            ++i;
        }
        return this.toDescription(name, result, dollarIndex, index);
    }

    @Override
    protected IEObjectDescription toDescription(QualifiedName name, JvmType result, int dollarIndex, int index) {
        if (result != null) {
            JvmType actualResult;
            JvmType jvmType = actualResult = dollarIndex > 0 || name.getSegmentCount() > 0 ? this.findNestedType(result, index, name) : result;
            if (actualResult != null) {
                return EObjectDescription.create((QualifiedName)name, (EObject)actualResult);
            }
        }
        return null;
    }

    protected JvmType getExactMatch(JvmType type, int index, QualifiedName name) {
        String qn = type.getQualifiedName();
        if (Strings.isEmpty((String)qn)) {
            return null;
        }
        QualifiedName typeName = QualifiedName.create((List)Strings.split((String)qn, (char)'.'));
        if (name.equals((Object)typeName)) {
            return type;
        }
        if (name.startsWith(typeName)) {
            JvmType result = this.findNestedType(type, index, name.skipFirst(typeName.getSegmentCount() - 1));
            return result;
        }
        if (name.getSegmentCount() > typeName.getSegmentCount() && typeName.skipLast(1).equals((Object)name.skipLast(1)) && typeName.getLastSegment().equals(name.skipFirst(typeName.getSegmentCount() - 1).toString("$"))) {
            return type;
        }
        return null;
    }

    protected boolean isMatch(int index, JvmType type, String simpleName, QualifiedName relativeName) {
        return simpleName.equals(type.getSimpleName());
    }

    @Override
    protected void doGetDescriptions(JvmType type, JvmType knownType, int index, List<IEObjectDescription> result) {
        if (type == knownType) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)type.getSimpleName()), (EObject)type));
        } else if (type.eContainer() == knownType) {
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String[])new String[]{knownType.getSimpleName(), type.getSimpleName()}), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)(String.valueOf(knownType.getSimpleName()) + '$' + type.getSimpleName())), (EObject)type));
        } else {
            String knownTypeName = knownType.getQualifiedName();
            String withDollar = type.getQualifiedName('$');
            String withDot = type.getQualifiedName('.');
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((List)Strings.split((String)withDot.substring(knownTypeName.length()), (char)'.')), (EObject)type));
            result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)withDollar.substring(knownTypeName.length())), (EObject)type));
        }
    }
}

