/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationAdapter;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.util.internal.AlternateJdkLoader;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.GeneratorConfigProvider;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class XtendBatchCompiler {
    private static Logger log = Logger.getLogger((String)XtendBatchCompiler.class.getName());
    protected static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected Provider<JavaIoFileSystemAccess> javaIoFileSystemAccessProvider;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected Provider<ResourceSetBasedResourceDescriptions> resourceSetDescriptionsProvider;
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IStubGenerator stubGenerator;
    @Inject
    private IOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private GeneratorConfigProvider generatorConfigProvider;
    @Inject
    @Named(value="languageName")
    private String languageName;
    protected String sourcePath;
    protected String classPath;
    protected String bootClassPath;
    protected boolean useCurrentClassLoaderAsParent;
    protected String outputPath;
    protected String fileEncoding;
    protected boolean verbose = false;
    protected String tempDirectory = System.getProperty("java.io.tmpdir");
    protected boolean deleteTempDirectory = true;
    protected List<File> tempFolders = Lists.newArrayList();
    protected boolean writeTraceFiles = true;
    protected boolean writeStorageFiles = false;
    private GeneratorConfig generatorConfig = new GeneratorConfig();
    protected ClassLoader currentClassLoader = this.getClass().getClassLoader();
    private URI baseURI;
    private ClassLoader jvmTypesClassLoader;
    private ClassLoader annotationProcessingClassLoader;
    private FileProjectConfig projectConfig;
    private OutputConfiguration outputConfiguration;
    private static final Function<String, File> TO_FILE = new Function<String, File>(){

        public File apply(String from) {
            return new File(from);
        }
    };
    private static final Function<File, URL> TO_URL = new Function<File, URL>(){

        public URL apply(File from) {
            try {
                return from.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    @Deprecated
    protected Writer outputWriter = new CharArrayWriter();
    @Deprecated
    protected Writer errorWriter = new CharArrayWriter();

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public void setUseCurrentClassLoaderAsParent(boolean useCurrentClassLoaderAsParent) {
        this.useCurrentClassLoaderAsParent = useCurrentClassLoaderAsParent;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public boolean isWriteTraceFiles() {
        return this.writeTraceFiles;
    }

    public void setWriteTraceFiles(boolean writeTraceFiles) {
        this.writeTraceFiles = writeTraceFiles;
    }

    public boolean isWriteStorageFiles() {
        return this.writeStorageFiles;
    }

    public void setWriteStorageFiles(boolean writeStorageFiles) {
        this.writeStorageFiles = writeStorageFiles;
    }

    @Inject
    public void setResourceSetProvider(Provider<ResourceSet> resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    public boolean isDeleteTempDirectory() {
        return this.deleteTempDirectory;
    }

    public void setDeleteTempDirectory(boolean deletetempDirectory) {
        this.deleteTempDirectory = deletetempDirectory;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setBootClassPath(String bootClassPath) {
        JavaVersion version = JavaVersion.fromQualifier((String)this.getJavaSourceVersion());
        if (version.isAtLeast(JavaVersion.JAVA9)) {
            if (!bootClassPath.isEmpty()) {
                log.warn((Object)("Option bootClassPath is only valid for Java 8 and lower. The value '" + bootClassPath + "' will be ignored."));
            }
        } else {
            this.bootClassPath = bootClassPath;
        }
    }

    public void setBasePath(String basePath) {
        this.baseURI = UriUtil.createFolderURI((File)new File(basePath));
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Deprecated
    protected String getComplianceLevel() {
        return this.getJavaSourceVersion();
    }

    public boolean isGenerateSyntheticSuppressWarnings() {
        return this.generatorConfig.isGenerateSyntheticSuppressWarnings();
    }

    public void setGenerateSyntheticSuppressWarnings(boolean generateSyntheticSuppressWarnings) {
        this.generatorConfig.setGenerateSyntheticSuppressWarnings(generateSyntheticSuppressWarnings);
    }

    public boolean isGenerateGeneratedAnnotation() {
        return this.generatorConfig.isGenerateGeneratedAnnotation();
    }

    public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
        this.generatorConfig.setGenerateGeneratedAnnotation(generateGeneratedAnnotation);
    }

    public boolean isIncludeDateInGeneratedAnnotation() {
        return this.generatorConfig.isIncludeDateInGeneratedAnnotation();
    }

    public void setIncludeDateInGeneratedAnnotation(boolean includeDateInGeneratedAnnotation) {
        this.generatorConfig.setIncludeDateInGeneratedAnnotation(includeDateInGeneratedAnnotation);
    }

    public String getGeneratedAnnotationComment() {
        return this.generatorConfig.getGeneratedAnnotationComment();
    }

    public void setGeneratedAnnotationComment(String generatedAnnotationComment) {
        this.generatorConfig.setGeneratedAnnotationComment(generatedAnnotationComment);
    }

    public String getJavaSourceVersion() {
        return this.generatorConfig.getJavaSourceVersion().getQualifier();
    }

    public void setJavaSourceVersion(String javaSourceVersion) {
        JavaVersion javaVersion = JavaVersion.fromQualifier((String)javaSourceVersion);
        if (javaVersion == null) {
            ArrayList qualifiers = Lists.newArrayList();
            JavaVersion[] javaVersionArray = JavaVersion.values();
            int n = javaVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                JavaVersion version = javaVersionArray[n2];
                qualifiers.addAll(version.getAllQualifiers());
                ++n2;
            }
            throw new IllegalArgumentException("Unknown Java Version Qualifier: '" + javaSourceVersion + "'. Valid values are: '" + Joiner.on((String)", ").join((Iterable)qualifiers) + "'");
        }
        this.generatorConfig.setJavaSourceVersion(javaVersion);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public FileProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    private boolean configureWorkspace(ResourceSet resourceSet) {
        List<File> sourceFileList = this.getSourcePathFileList();
        File outputFile = this.getOutputPathFile();
        if (sourceFileList == null || outputFile == null) {
            return false;
        }
        File commonRoot = this.determineCommonRoot(outputFile, sourceFileList);
        if (commonRoot == null || commonRoot.getParent() == null || commonRoot.getParentFile().getParent() == null) {
            log.error((Object)"All source folders and the output folder should have a common parent non-top level folder (like project folder)");
            for (File sourceFile : sourceFileList) {
                log.error((Object)("(Source folder: '" + sourceFile + "')"));
            }
            log.error((Object)("(Output folder: '" + outputFile + "')"));
            return false;
        }
        this.projectConfig = new FileProjectConfig(commonRoot, commonRoot.getName());
        java.net.URI commonURI = commonRoot.toURI();
        java.net.URI relativizedTarget = commonURI.relativize(outputFile.toURI());
        if (relativizedTarget.isAbsolute()) {
            log.error((Object)("Target folder '" + outputFile + "' must be a child of the project folder '" + commonRoot + "'"));
            return false;
        }
        CharMatcher slash = CharMatcher.is((char)'/');
        String relativeTargetFolder = slash.trimTrailingFrom((CharSequence)relativizedTarget.getPath());
        this.outputConfiguration = (OutputConfiguration)Iterables.getOnlyElement((Iterable)this.outputConfigurationProvider.getOutputConfigurations());
        this.outputConfiguration.setOutputDirectory(relativeTargetFolder);
        for (File source : sourceFileList) {
            java.net.URI relativizedSrc = commonURI.relativize(source.toURI());
            if (relativizedSrc.isAbsolute()) {
                log.error((Object)("Source folder '" + source + "' must be a child of the project folder '" + commonRoot + "'"));
                return false;
            }
            this.projectConfig.addSourceFolder(slash.trimTrailingFrom((CharSequence)relativizedSrc.getPath()));
        }
        HashMap outputConfigurations = Maps.newHashMap();
        outputConfigurations.put(this.languageName, Sets.newHashSet((Object[])new OutputConfiguration[]{this.outputConfiguration}));
        ProjectConfigAdapter.install((ResourceSet)resourceSet, (IProjectConfig)this.projectConfig);
        resourceSet.eAdapters().add((Object)new OutputConfigurationAdapter((Map)outputConfigurations));
        return true;
    }

    private File getOutputPathFile() {
        return new File(this.outputPath).getAbsoluteFile();
    }

    private List<File> getSourcePathFileList() {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        for (String path : this.getSourcePathDirectories()) {
            sourceFileList.add(new File(path).getAbsoluteFile());
        }
        return sourceFileList;
    }

    /*
     * WARNING - void declaration
     */
    private File determineCommonRoot(File outputFile, List<File> sourceFileList) {
        if (this.baseURI != null && this.baseURI.isFile()) {
            return new File(this.baseURI.toFileString());
        }
        ArrayList<File> pathList = new ArrayList<File>(sourceFileList);
        pathList.add(outputFile);
        ArrayList pathParts = new ArrayList();
        for (File path : pathList) {
            void var8_9;
            ArrayList<void> partsList = new ArrayList<void>();
            File file = path;
            while (var8_9 != null) {
                partsList.add(var8_9);
                File file2 = var8_9.getParentFile();
            }
            pathParts.add(partsList);
        }
        int i = 1;
        File result = null;
        while (true) {
            File compareWith = null;
            for (List list : pathParts) {
                if (list.size() < i) {
                    return result;
                }
                File part = (File)list.get(list.size() - i);
                if (compareWith == null) {
                    compareWith = part;
                    continue;
                }
                if (compareWith.equals(part)) continue;
                return result;
            }
            result = compareWith;
            ++i;
        }
    }

    public boolean compile() {
        try {
            if (!this.checkConfiguration()) {
                return false;
            }
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            if (!this.configureWorkspace(resourceSet)) {
                return false;
            }
            this.generatorConfigProvider.install(resourceSet, this.generatorConfig);
            File classDirectory = this.createTempDir("classes");
            try {
                this.compilerPhases.setIndexing((Notifier)resourceSet, true);
                this.installJvmTypeProvider(resourceSet, classDirectory, true);
                this.loadXtendFiles(resourceSet);
                File sourceDirectory = this.createStubs(resourceSet);
                if (!this.preCompileStubs(sourceDirectory, classDirectory)) {
                    log.warn((Object)"Compilation of stubs had errors.");
                }
                if (!this.preCompileJava(sourceDirectory, classDirectory)) {
                    log.debug((Object)"Compilation of Java code against stubs had errors. This is expected and usually is not a probblem.");
                }
            }
            finally {
                this.compilerPhases.setIndexing((Notifier)resourceSet, false);
            }
            this.installJvmTypeProvider(resourceSet, classDirectory, false);
            ArrayList<Resource> toBeResolved = new ArrayList<Resource>(resourceSet.getResources().size());
            for (Resource resource : resourceSet.getResources()) {
                if (!this.isSourceFile(resource)) continue;
                toBeResolved.add(resource);
            }
            for (Resource resource : toBeResolved) {
                EcoreUtil.resolveAll((Resource)resource);
            }
            List<Issue> issues = this.validate(resourceSet);
            Iterable errors = Iterables.filter(issues, (Predicate)SeverityFilter.ERROR);
            Iterable warnings = Iterables.filter(issues, (Predicate)SeverityFilter.WARNING);
            this.reportIssues(Iterables.concat((Iterable)errors, (Iterable)warnings));
            if (!Iterables.isEmpty((Iterable)errors)) {
                return false;
            }
            this.generateJavaFiles(resourceSet);
        }
        finally {
            this.destroyClassLoader(this.jvmTypesClassLoader);
            this.destroyClassLoader(this.annotationProcessingClassLoader);
            if (this.isDeleteTempDirectory()) {
                this.deleteTmpFolders();
            }
        }
        return true;
    }

    protected void destroyClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                log.warn((Object)"Unable to close a classloader", (Throwable)e);
            }
        }
    }

    protected boolean checkConfiguration() {
        File output = this.getOutputPathFile();
        for (String sourcePath : this.getSourcePathDirectories()) {
            File sourceDirectory = new File(sourcePath);
            try {
                if (!this.isContainedIn(output.getCanonicalFile(), sourceDirectory.getCanonicalFile())) continue;
                log.error((Object)("The configured output path \"" + this.getOutputPathFile() + "\" cannot be a child of the configured source directory \"" + sourcePath + "\"."));
                return false;
            }
            catch (IOException e) {
                log.error((Object)"invalid configuration", (Throwable)e);
            }
        }
        return true;
    }

    private boolean isContainedIn(File child, File possibleParent) {
        File parent = child;
        while (parent != null) {
            if (parent.equals(possibleParent)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }

    protected ResourceSet loadXtendFiles(ResourceSet resourceSet) {
        this.encodingProvider.setDefaultEncoding(this.getFileEncoding());
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setExtension(this.fileExtensionProvider.getPrimaryFileExtension());
        PathTraverser pathTraverser = new PathTraverser();
        List<String> sourcePathDirectories = this.getSourcePathDirectories();
        Multimap pathes = pathTraverser.resolvePathes(sourcePathDirectories, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                return matches;
            }
        });
        for (String src : pathes.keySet()) {
            for (URI uri : pathes.get((Object)src)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("load xtend file '" + uri + "'"));
                }
                resourceSet.getResource(uri, true);
            }
        }
        return resourceSet;
    }

    @Deprecated
    protected ResourceSet loadXtendFiles() {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        return this.loadXtendFiles(resourceSet);
    }

    protected File createStubs(ResourceSet resourceSet) {
        File outputDirectory = this.createTempDir("stubs");
        JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        fileSystemAccess.setOutputPath(outputDirectory.toString());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            this.stubGenerator.doGenerateStubs((IFileSystemAccess)fileSystemAccess, description);
        }
        return outputDirectory;
    }

    protected boolean preCompileStubs(File tmpSourceDirectory, File classDirectory) {
        return this.preCompile(tmpSourceDirectory, Collections.singletonList(tmpSourceDirectory.toString()), this.getClassPathEntries());
    }

    protected boolean preCompileJava(File tmpSourceDirectory, File classDirectory) {
        return this.preCompile(classDirectory, this.getSourcePathDirectories(), Iterables.concat(Collections.singletonList(tmpSourceDirectory.toString()), this.getClassPathEntries()));
    }

    protected boolean preCompile(File classDirectory, Iterable<String> sourcePathDirectories, Iterable<String> classPathEntries) {
        List<String> bootClassPathEntries;
        JavaVersion version;
        ArrayList commandLine = Lists.newArrayList();
        if (this.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (this.getJavaSourceVersion() != null && !(version = JavaVersion.fromQualifier((String)this.getJavaSourceVersion())).isAtLeast(JavaVersion.JAVA9) && !Iterables.isEmpty(bootClassPathEntries = this.getBootClassPathEntries())) {
            commandLine.add("-bootclasspath \"" + Strings.concat((String)File.pathSeparator, bootClassPathEntries) + "\"");
        }
        if (!Iterables.isEmpty(classPathEntries)) {
            commandLine.add("-cp \"" + Joiner.on((String)File.pathSeparator).join(classPathEntries) + "\"");
        }
        commandLine.add("-d \"" + classDirectory.toString() + "\"");
        commandLine.add("-" + this.getComplianceLevel());
        commandLine.add("-proceedOnError");
        if (this.encodingProvider.getDefaultEncoding() != null) {
            commandLine.add("-encoding \"" + this.encodingProvider.getDefaultEncoding() + "\"");
        }
        ArrayList sourceDirectories = Lists.newArrayList(sourcePathDirectories);
        commandLine.add(Strings.concat((String)" ", (List)Lists.transform((List)sourceDirectories, (Function)new Function<String, String>(){

            public String apply(String path) {
                return "\"" + path + "\"";
            }
        })));
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke batch compiler with '" + Strings.concat((String)" ", (List)commandLine) + "'"));
        }
        PrintWriter outWriter = this.getStubCompilerOutputWriter();
        return BatchCompiler.compile((String)Strings.concat((String)" ", (List)commandLine), (PrintWriter)outWriter, (PrintWriter)outWriter, null);
    }

    private PrintWriter getStubCompilerOutputWriter() {
        Writer debugWriter = new Writer(){

            @Override
            public void write(char[] data, int offset, int count) throws IOException {
                String message = String.copyValueOf(data, offset, count);
                log.debug((Object)message);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        return new PrintWriter(debugWriter);
    }

    protected List<Issue> validate(ResourceSet resourceSet) {
        ArrayList issues = Lists.newArrayList();
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
            if (resourceServiceProvider == null || !this.isSourceFile(resource)) continue;
            IResourceValidator resourceValidator = resourceServiceProvider.getResourceValidator();
            List result = resourceValidator.validate(resource, CheckMode.ALL, null);
            Iterables.addAll((Collection)issues, (Iterable)result);
        }
        return issues;
    }

    protected boolean isSourceFile(Resource resource) {
        if (resource instanceof BatchLinkableResource) {
            return !((BatchLinkableResource)resource).isLoadedFromStorage();
        }
        return false;
    }

    @Deprecated
    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory) {
        this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, false);
    }

    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        if (skipIndexLookup) {
            this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, skipIndexLookup);
        } else {
            this.installJvmTypeProvider(resourceSet, tmpClassDirectory);
        }
    }

    private void internalInstallJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        ClassLoader parentClassLoader;
        Iterable classPathEntries = Iterables.concat(this.getClassPathEntries(), this.getSourcePathDirectories(), Arrays.asList(tmpClassDirectory.toString()));
        classPathEntries = Iterables.filter((Iterable)classPathEntries, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        });
        Iterable classpath = Iterables.transform((Iterable)classPathEntries, TO_FILE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("classpath used for Xtend compilation : " + classpath));
        }
        if (this.useCurrentClassLoaderAsParent) {
            parentClassLoader = this.currentClassLoader;
        } else if (Strings.isEmpty((String)this.bootClassPath)) {
            parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        } else {
            List bootClassPathEntries = Lists.transform(this.getBootClassPathEntries(), TO_FILE);
            parentClassLoader = new AlternateJdkLoader((Iterable)bootClassPathEntries);
        }
        this.jvmTypesClassLoader = this.createClassLoader(classpath, parentClassLoader);
        new ClasspathTypeProvider(this.jvmTypesClassLoader, resourceSet, skipIndexLookup ? null : this.indexedJvmTypeAccess, null);
        ((XtextResourceSet)resourceSet).setClasspathURIContext((Object)this.jvmTypesClassLoader);
        this.annotationProcessingClassLoader = this.createClassLoader(classpath, this.currentClassLoader);
        resourceSet.eAdapters().add((Object)new ProcessorInstanceForJvmTypeProvider.ProcessorClassloaderAdapter(this.annotationProcessingClassLoader));
    }

    protected ClassLoader createClassLoader(Iterable<File> jarsAndFolders, ClassLoader parentClassLoader) {
        return new URLClassLoader((URL[])Iterables.toArray((Iterable)Iterables.transform(jarsAndFolders, TO_URL), URL.class), parentClassLoader);
    }

    protected void reportIssues(Iterable<Issue> issues) {
        for (Issue issue : issues) {
            StringBuilder issueBuilder = this.createIssueMessage(issue);
            if (Severity.ERROR == issue.getSeverity()) {
                log.error((Object)issueBuilder.toString());
                continue;
            }
            if (Severity.WARNING != issue.getSeverity()) continue;
            log.warn((Object)issueBuilder.toString());
        }
    }

    private StringBuilder createIssueMessage(Issue issue) {
        StringBuilder issueBuilder = new StringBuilder("\n");
        issueBuilder.append(issue.getSeverity()).append(": \t");
        URI uriToProblem = issue.getUriToProblem();
        if (uriToProblem != null) {
            URI resourceUri = uriToProblem.trimFragment();
            issueBuilder.append(resourceUri.lastSegment()).append(" - ");
            if (resourceUri.isFile()) {
                issueBuilder.append(resourceUri.toFileString());
            }
        }
        issueBuilder.append("\n").append(issue.getLineNumber()).append(": ").append(issue.getMessage());
        return issueBuilder;
    }

    protected void generateJavaFiles(ResourceSet resourceSet) {
        JavaIoFileSystemAccess javaIoFileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        javaIoFileSystemAccess.setOutputPath(this.outputPath);
        javaIoFileSystemAccess.setWriteTrace(this.writeTraceFiles);
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        for (Resource resource : Lists.newArrayList((Iterable)resourceSet.getResources())) {
            if (!this.isSourceFile(resource)) continue;
            if (this.isWriteStorageFiles()) {
                StorageAwareResource storageAwareResource = (StorageAwareResource)resource;
                storageAwareResource.getResourceStorageFacade().saveResource(storageAwareResource, (IFileSystemAccessExtension3)javaIoFileSystemAccess);
            }
            this.generator.generate(resource, (IFileSystemAccess2)javaIoFileSystemAccess, (IGeneratorContext)context);
        }
    }

    protected ResourceSetBasedResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        ResourceSetBasedResourceDescriptions resourceDescriptions = (ResourceSetBasedResourceDescriptions)this.resourceSetDescriptionsProvider.get();
        resourceDescriptions.setContext((Notifier)resourceSet);
        resourceDescriptions.setRegistry(IResourceServiceProvider.Registry.INSTANCE);
        return resourceDescriptions;
    }

    protected XtendFile getXtendFile(Resource resource) {
        EObject model;
        XtextResource xtextResource = (XtextResource)resource;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (model = parseResult.getRootASTElement()) instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)model;
            return xtendFile;
        }
        return null;
    }

    protected List<String> getClassPathEntries() {
        return this.getDirectories(this.classPath);
    }

    protected List<String> getBootClassPathEntries() {
        return this.getDirectories(this.bootClassPath);
    }

    protected List<String> getSourcePathDirectories() {
        return this.getDirectories(this.sourcePath);
    }

    protected List<String> getDirectories(String path) {
        if (Strings.isEmpty((String)path)) {
            return Lists.newArrayList();
        }
        List split = Strings.split((String)Strings.emptyIfNull((String)path), (String)File.pathSeparator);
        return Lists.transform((List)split, (Function)new Function<String, String>(){

            public String apply(String from) {
                return new File(new File(from).getAbsoluteFile().toURI().normalize()).getAbsolutePath();
            }
        });
    }

    protected File createTempDir(String prefix) {
        File tempDir = new File(this.getTempDirectory(), String.valueOf(prefix) + System.nanoTime());
        XtendBatchCompiler.cleanFolder(tempDir, ACCEPT_ALL_FILTER, true, true);
        if (!tempDir.mkdirs()) {
            throw new RuntimeException("Error creating temp directory '" + tempDir.getAbsolutePath() + "'");
        }
        this.tempFolders.add(tempDir);
        return tempDir;
    }

    protected void deleteTmpFolders() {
        for (File file : this.tempFolders) {
            XtendBatchCompiler.cleanFolder(file, ACCEPT_ALL_FILTER, true, true);
        }
    }

    protected static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) {
        try {
            log.debug((Object)("Cleaning folder " + parentFolder.toString()));
            return Files.cleanFolder((File)parentFolder, null, (boolean)continueOnError, (boolean)deleteParentFolder);
        }
        catch (FileNotFoundException e) {
            return true;
        }
    }

    @Deprecated
    public Writer getOutputWriter() {
        log.warn((Object)"XtendBatchCompiler.getOutputWriter has been deprecated");
        return this.outputWriter;
    }

    @Deprecated
    public void setOutputWriter(Writer ouputWriter) {
        log.warn((Object)"XtendBatchCompiler.setOutputWriter has been deprecated");
        this.outputWriter = ouputWriter;
    }

    @Deprecated
    public Writer getErrorWriter() {
        log.warn((Object)"XtendBatchCompiler.getErrorWriter has been deprecated");
        return this.errorWriter;
    }

    @Deprecated
    public void setErrorWriter(Writer errorWriter) {
        log.warn((Object)"XtendBatchCompiler.setErrorWriter has been deprecated");
        this.errorWriter = errorWriter;
    }

    private static final class SeverityFilter
    implements Predicate<Issue> {
        private static final SeverityFilter WARNING = new SeverityFilter(Severity.WARNING);
        private static final SeverityFilter ERROR = new SeverityFilter(Severity.ERROR);
        private Severity severity;

        private SeverityFilter(Severity severity) {
            this.severity = severity;
        }

        public boolean apply(Issue issue) {
            return this.severity == issue.getSeverity();
        }
    }
}

