/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.JavaSource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@Deprecated
public class InMemoryJavaCompiler {
    private final INameEnvironment nameEnv;
    private final ClassLoader parentClassLoader;
    private final CompilerOptions compilerOptions;

    public InMemoryJavaCompiler(ClassLoader parent, JavaVersion javaVersion) {
        CompilerOptions _compilerOptions;
        ClassLoaderBasedNameEnvironment _classLoaderBasedNameEnvironment = new ClassLoaderBasedNameEnvironment(parent);
        this.nameEnv = _classLoaderBasedNameEnvironment;
        this.parentClassLoader = parent;
        this.compilerOptions = _compilerOptions = new CompilerOptions();
        long classFmt = this.toClassFmt(javaVersion);
        this.setSourceLevel(classFmt);
        this.setComplianceLevel(classFmt);
        this.compilerOptions.targetJDK = classFmt;
        this.compilerOptions.inlineJsrBytecode = true;
        this.compilerOptions.preserveAllLocalVariables = true;
    }

    public InMemoryJavaCompiler(ClassLoader parent, CompilerOptions compilerOptions) {
        CompilerOptions _compilerOptions;
        ClassLoaderBasedNameEnvironment _classLoaderBasedNameEnvironment = new ClassLoaderBasedNameEnvironment(parent);
        this.nameEnv = _classLoaderBasedNameEnvironment;
        this.parentClassLoader = parent;
        Map _map = compilerOptions.getMap();
        this.compilerOptions = _compilerOptions = new CompilerOptions(_map);
    }

    private long toClassFmt(JavaVersion version) {
        if (version != null) {
            switch (version) {
                case JAVA5: {
                    return 0x310000L;
                }
                case JAVA6: {
                    return 0x320000L;
                }
                case JAVA7: {
                    return 0x330000L;
                }
                case JAVA8: {
                    return 0x340000L;
                }
            }
        }
        return 0L;
    }

    private void setSourceLevel(long jdkVersion) {
        block5: {
            try {
                this.compilerOptions.sourceLevel = jdkVersion;
                try {
                    CompilerOptions.class.getField("originalSourceLevel").setLong(this.compilerOptions, jdkVersion);
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchFieldException) {
                        NoSuchFieldException noSuchFieldException = (NoSuchFieldException)_t;
                        break block5;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    private void setComplianceLevel(long jdkVersion) {
        block5: {
            try {
                this.compilerOptions.complianceLevel = jdkVersion;
                try {
                    CompilerOptions.class.getField("originalComplianceLevel").setLong(this.compilerOptions, jdkVersion);
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchFieldException) {
                        NoSuchFieldException noSuchFieldException = (NoSuchFieldException)_t;
                        break block5;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public Result compile(JavaSource ... sources) {
        final Result result = new Result(this.parentClassLoader);
        IErrorHandlingPolicy _proceedWithAllProblems = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        ICompilerRequestor _function = it -> {
            ClassFile[] _classFiles;
            ClassFile[] classFileArray = _classFiles = it.getClassFiles();
            int n = _classFiles.length;
            int n2 = 0;
            while (n2 < n) {
                ClassFile cf = classFileArray[n2];
                Functions.Function1 _function_1 = it_1 -> String.valueOf(it_1);
                result.classMap.put(IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)cf.getCompoundName())), (Functions.Function1)_function_1), (CharSequence)"."), cf.getBytes());
                ++n2;
            }
        };
        Compiler compiler = new Compiler(this.nameEnv, _proceedWithAllProblems, this.compilerOptions, _function, (IProblemFactory)new DefaultProblemFactory(){

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, elaborationId, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }

            public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
                CategorizedProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
                result.compilationProblems.add(problem);
                return problem;
            }
        });
        Functions.Function1 _function_1 = it -> {
            char[] _charArray = it.getCode().toCharArray();
            String _fileName = it.getFileName();
            return new CompilationUnit(_charArray, _fileName, null);
        };
        ICompilationUnit[] units = (ICompilationUnit[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)sources)), (Functions.Function1)_function_1), ICompilationUnit.class);
        compiler.compile(units);
        return result;
    }

    static class ByteClassLoader
    extends ClassLoader {
        private Map<String, byte[]> classMap;

        public ByteClassLoader(Map<String, byte[]> classMap, ClassLoader parent) {
            super(parent);
            this.classMap = classMap;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.classMap.get(name);
            if (bytes == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }

        @Override
        protected URL findResource(String path) {
            try {
                int _length;
                int _minus;
                String className;
                byte[] bytes;
                boolean _endsWith = path.endsWith(".class");
                if (_endsWith && (bytes = this.classMap.get(className = path.substring(0, _minus = (_length = path.length()) - 6).replace("/", "."))) != null) {
                    URLStreamHandler _function = new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL it) throws IOException {
                            return new URLConnection(it){

                                @Override
                                public void connect() {
                                }

                                @Override
                                public InputStream getInputStream() {
                                    return new ByteArrayInputStream(bytes);
                                }
                            };
                        }
                    };
                    return new URL("in-memory", null, -1, path, _function);
                }
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @FinalFieldsConstructor
    private static class ClassLoaderBasedNameEnvironment
    implements INameEnvironment {
        private final ClassLoader classLoader;
        private Map<String, NameEnvironmentAnswer> cache = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

        public void cleanup() {
            this.cache.clear();
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            URL url;
            String fileName;
            block4: {
                try {
                    Functions.Function1 _function = it -> String.valueOf(it);
                    String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)compoundTypeName)), (Functions.Function1)_function), (CharSequence)"/");
                    fileName = String.valueOf(_join) + ".class";
                    boolean _containsKey = this.cache.containsKey(fileName);
                    if (_containsKey) {
                        return this.cache.get(fileName);
                    }
                    url = this.classLoader.getResource(fileName);
                    if (url != null) break block4;
                    this.cache.put(fileName, null);
                    return null;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            ClassFileReader reader = ClassFileReader.read((InputStream)url.openStream(), (String)fileName);
            NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
            this.cache.put(fileName, result);
            return result;
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            URL url;
            String fileName;
            block4: {
                try {
                    Functions.Function1 _function = it -> String.valueOf(it);
                    String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)packageName)), (Functions.Function1)_function), (CharSequence)"/");
                    String _plus = String.valueOf(_join) + "/";
                    String _valueOf = String.valueOf(typeName);
                    String _plus_1 = String.valueOf(_plus) + _valueOf;
                    fileName = String.valueOf(_plus_1) + ".class";
                    boolean _containsKey = this.cache.containsKey(fileName);
                    if (_containsKey) {
                        return this.cache.get(fileName);
                    }
                    url = this.classLoader.getResource(fileName);
                    if (url != null) break block4;
                    this.cache.put(fileName, null);
                    return null;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            ClassFileReader reader = ClassFileReader.read((InputStream)url.openStream(), (String)fileName);
            NameEnvironmentAnswer result = new NameEnvironmentAnswer((IBinaryType)reader, null);
            this.cache.put(fileName, result);
            return result;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            return Character.isLowerCase(((Character)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)packageName)))).charValue());
        }

        public ClassLoaderBasedNameEnvironment(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }

    @FinalFieldsConstructor
    public static class Result {
        @Accessors
        private final Set<CategorizedProblem> compilationProblems = CollectionLiterals.newLinkedHashSet((Object[])new CategorizedProblem[0]);
        private final HashMap<String, byte[]> classMap = new HashMap();
        private final ClassLoader parentClassLoader;

        public ClassLoader getClassLoader() {
            return new ByteClassLoader(this.classMap, this.parentClassLoader);
        }

        public Result(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        @Pure
        public Set<CategorizedProblem> getCompilationProblems() {
            return this.compilationProblems;
        }
    }
}

