/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class EObjectDiagnosticImpl
extends AbstractDiagnostic {
    private EObject problematicObject;
    private EStructuralFeature problematicFeature;
    private int indexOfProblemanticValueInFeature = -1;
    private Severity severity;
    private String code;
    private String message;
    private String[] data;

    public EObjectDiagnosticImpl(Severity severity, String problemCode, String message, EObject problematicObject, EStructuralFeature problematicFeature, int indexOfProblemanticValueInFeature, String[] data) {
        this.severity = severity;
        this.code = problemCode;
        this.message = message;
        this.problematicObject = problematicObject;
        this.problematicFeature = problematicFeature;
        this.indexOfProblemanticValueInFeature = indexOfProblemanticValueInFeature;
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected INode getNode() {
        return this.doGetNode(this.problematicObject, this.problematicFeature, this.indexOfProblemanticValueInFeature);
    }

    protected INode doGetNode(EObject object, EStructuralFeature feature, int idx) {
        if (object == null) {
            return null;
        }
        if (feature == null) {
            ICompositeNode result = NodeModelUtils.findActualNodeFor(object);
            if (result != null) {
                return result;
            }
            return this.doGetNode(object.eContainer(), (EStructuralFeature)object.eContainmentFeature(), -1);
        }
        List<INode> nodesForFeature = NodeModelUtils.findNodesForFeature(object, feature);
        if (nodesForFeature.isEmpty()) {
            return this.doGetNode(object, null, -1);
        }
        if (idx == -1) {
            idx = 0;
        }
        if (nodesForFeature.size() > idx) {
            return nodesForFeature.get(idx);
        }
        return this.doGetNode(object, null, -1);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String[] getData() {
        return this.data;
    }

    @Override
    public URI getUriToProblem() {
        return EcoreUtil.getURI((EObject)this.problematicObject);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public EStructuralFeature getProblematicFeature() {
        return this.problematicFeature;
    }

    public EObject getProblematicObject() {
        return this.problematicObject;
    }
}

