/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.imports.ImportsAcceptor;
import org.eclipse.xtext.xbase.imports.ImportsCollector;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

public class ImportsUtil {
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;
    @Inject
    private ImportsCollector importsCollector;

    public Triple<Set<String>, Set<String>, Set<String>> collectImports(XtextResource xtextResource, ITextRegion textRegion) {
        ImportsAcceptor.DefaultImportsAcceptor acceptor = new ImportsAcceptor.DefaultImportsAcceptor();
        this.importsCollector.collectImports(xtextResource, textRegion, (ImportsAcceptor)acceptor);
        return Tuples.create((Object)acceptor.getTypes(), (Object)acceptor.getStaticImport(), (Object)acceptor.getExtensions());
    }

    public void addImports(final String[] typeImports, final String[] staticImports, final String[] extensionImports, IXtextDocument xtextDocument) {
        List result = (List)xtextDocument.modify((IUnitOfWork)new IUnitOfWork<List<ReplaceRegion>, XtextResource>(){

            public List<ReplaceRegion> exec(XtextResource state) throws Exception {
                Pair<String, String> pair;
                RewritableImportSection impSection = ImportsUtil.this.importSectionFactory.parse(state);
                String[] stringArray = typeImports;
                int n = typeImports.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeImport = stringArray[n2];
                    impSection.addImport(typeImport);
                    ++n2;
                }
                stringArray = staticImports;
                n = staticImports.length;
                n2 = 0;
                while (n2 < n) {
                    String staticImport = stringArray[n2];
                    pair = ImportsUtil.this.splitInTypeAndMember(staticImport);
                    impSection.addStaticImport((String)pair.getFirst(), (String)pair.getSecond());
                    ++n2;
                }
                stringArray = extensionImports;
                n = extensionImports.length;
                n2 = 0;
                while (n2 < n) {
                    String staticExtensionImport = stringArray[n2];
                    pair = ImportsUtil.this.splitInTypeAndMember(staticExtensionImport);
                    impSection.addStaticExtensionImport((String)pair.getFirst(), (String)pair.getSecond());
                    ++n2;
                }
                return impSection.rewrite();
            }
        });
        try {
            if (!result.isEmpty()) {
                this.replaceConverter.convertToTextEdit(result).apply((IDocument)xtextDocument);
            }
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    protected Pair<String, String> splitInTypeAndMember(String featuresQName) {
        int memberIdx = featuresQName.lastIndexOf(46);
        String type = featuresQName.substring(0, memberIdx);
        String member = featuresQName.substring(memberIdx + 1);
        int indexOf = member.indexOf("(");
        if (indexOf != -1) {
            member = member.substring(0, indexOf);
        }
        Pair pair = Tuples.create((Object)type, (Object)member);
        return pair;
    }
}

