/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.ui.label.GlobalDescriptionLabelProvider;

@Singleton
public class HierarchyLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    @Inject
    private GlobalDescriptionLabelProvider globalDescriptionProvider;

    public Image getImage(Object element) {
        boolean _isRecursive;
        if (element instanceof PendingUpdateAdapter) {
            return null;
        }
        Image image = this.globalDescriptionProvider.getImage(this.getDescription(element));
        if (image == null) {
            return null;
        }
        if (element instanceof IHierarchyNode && (_isRecursive = ((IHierarchyNode)element).isRecursive())) {
            return this.decorateRecursive(image);
        }
        return image;
    }

    protected Image decorateRecursive(Image image) {
        return new DecorationOverlayIcon(image, XtextPluginImages.DESC_OVR_RECURSIVE, 2).createImage();
    }

    public String getText(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return this.getPendingText();
        }
        return this.globalDescriptionProvider.getText(this.getDescription(element));
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            String _pendingText = this.getPendingText();
            return new StyledString(_pendingText);
        }
        return this.globalDescriptionProvider.getStyledText(this.getDescription(element));
    }

    protected IEObjectDescription getDescription(Object element) {
        if (element instanceof IHierarchyNode) {
            return ((IHierarchyNode)element).getElement();
        }
        return null;
    }

    protected String getPendingText() {
        return "...";
    }
}

