/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.TextViewerDeleteLineTarget;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorMessages;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerDeleteLineAction
extends TextViewerAction {
    public static final int WHOLE = 0;
    public static final int TO_BEGINNING = 1;
    public static final int TO_END = 2;
    private final int fType;
    private final boolean fCopyToClipboard;
    private TextViewerDeleteLineTarget fTarget;

    public TextViewerDeleteLineAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int type) {
        this(bundle, prefix, viewer, type, true);
    }

    public TextViewerDeleteLineAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int type, boolean copyToClipboard) {
        super(bundle, prefix, viewer);
        this.fType = type;
        this.fCopyToClipboard = copyToClipboard;
        this.update();
    }

    public TextViewerDeleteLineAction(ITextViewer viewer, int type, boolean copyToClipboard) {
        this(EmbeddedEditorMessages.getBundleForConstructedKeys(), TextViewerDeleteLineAction.getPrefix(type, copyToClipboard), viewer, type, copyToClipboard);
    }

    private static String getPrefix(int type, boolean copyToClipboard) {
        switch (type) {
            case 0: {
                return copyToClipboard ? "Editor.CutLine." : "Editor.DeleteLine.";
            }
            case 1: {
                return copyToClipboard ? "Editor.CutLineToBeginning." : "Editor.DeleteLineToBeginning.";
            }
            case 2: {
                return copyToClipboard ? "Editor.CutLineToEnd." : "Editor.DeleteLineToEnd.";
            }
        }
        Assert.isLegal((boolean)false);
        return "";
    }

    public void run() {
        if (this.fTarget == null) {
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        if (!this.canModifyViewer()) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        ITextSelection selection = this.getSelection(viewer);
        if (selection == null) {
            return;
        }
        try {
            this.fTarget.deleteLine(document, selection, this.fType, this.fCopyToClipboard);
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer != null) {
            if (this.fTarget == null) {
                this.fTarget = new TextViewerDeleteLineTarget(viewer);
            }
        } else {
            this.fTarget = null;
        }
        this.setEnabled(this.fTarget != null);
    }
}

