/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting.preferences;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.formatting2.ContentFormatter;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.xbase.formatting.BasicFormatterPreferenceKeys;

public class XtendFormatterPreview
implements Observer {
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private Provider<ContentFormatter> formatterProvider;
    private EmbeddedEditor editorHandle;
    private String previewContent;
    private EmbeddedEditorModelAccess modelAccess;
    private MarginPainter marginPainter;

    public XtendFormatterPreview forEmbeddedEditor(EmbeddedEditor editorHandle) {
        if (this.editorHandle != null) {
            throw new IllegalStateException("This formatter preview is already binded to an embedet editor");
        }
        this.editorHandle = editorHandle;
        this.modelAccess = editorHandle.createPartialEditor();
        this.marginPainter = new MarginPainter((ITextViewer)editorHandle.getViewer());
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStoreAccess.getPreferenceStore(), (String)"printMarginColor");
        this.marginPainter.setMarginRulerColor(EditorUtils.colorFromRGB((RGB)rgb));
        editorHandle.getViewer().addPainter((IPainter)this.marginPainter);
        return this;
    }

    public XtendFormatterPreview withPreviewContent(String previewContent) {
        this.previewContent = previewContent;
        return this;
    }

    public XtextSourceViewer getEditorViewer() {
        this.checkEditorHandleIsSet();
        return this.editorHandle.getViewer();
    }

    private void checkEditorHandleIsSet() {
        if (this.editorHandle == null) {
            throw new IllegalStateException("This preview should be bind to an EmbeddedEditor, call XtendFormatterPreview#forEmbeddedEditor(EmbeddedEditor) first");
        }
    }

    public Observer getObserver() {
        return this;
    }

    @Override
    public void update(Observable o, Object arg) {
        ProfileManager manager = (ProfileManager)o;
        int value = (Integer)arg;
        switch (value) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.doUpdate(manager.getSelected().getSettings());
            }
        }
    }

    public void doUpdate(Map<String, String> map) {
        this.checkEditorHandleIsSet();
        MapBasedPreferenceValues values = new MapBasedPreferenceValues(map);
        String maxLineWidthValue = values.getPreference((PreferenceKey)BasicFormatterPreferenceKeys.maxLineWidth);
        if (maxLineWidthValue != null) {
            this.moveMarginToColumn(maxLineWidthValue);
        }
        StyledText widget = null;
        try {
            widget = (StyledText)this.editorHandle.getViewer().getControl();
            widget.setRedraw(false);
            this.modelAccess.updateModel("", this.previewContent, "");
            XtextDocument document = this.editorHandle.getDocument();
            ContentFormatter formatter = (ContentFormatter)this.formatterProvider.get();
            formatter.setPreferencesProvider((IPreferenceValuesProvider)values);
            formatter.format((IDocument)document, (IRegion)new Region(0, document.getLength()));
            this.editorHandle.getViewer().setSelection(null);
        }
        finally {
            if (widget != null) {
                widget.setRedraw(true);
            }
        }
    }

    public void moveMarginToColumn(String string) {
        this.checkEditorHandleIsSet();
        int parsedColumn = 99999;
        try {
            parsedColumn = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        this.marginPainter.setMarginRulerColumn(parsedColumn);
    }
}

