/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.core.resource.XtendResourceDescriptionManager;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

@Singleton
public class XtendUIResourceDescriptionManager
extends XtendResourceDescriptionManager {
    @Inject
    private IWorkspaceRoot workspaceRoot;

    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
        List containers = null;
        Collection importedNames = this.getImportedNames(candidate);
        HashMap checkedProjects = Maps.newHashMap();
        for (IResourceDescription.Delta delta : deltas) {
            if (!this.hasChanges(delta, candidate)) continue;
            URI uri = delta.getUri();
            if ((uri.isPlatform() || uri.isArchive()) && delta.getNew() != null) {
                if (containers == null) {
                    containers = this.getContainerManager().getVisibleContainers(candidate, context);
                }
                boolean descriptionIsContained = false;
                int i = 0;
                while (i < containers.size() && !descriptionIsContained) {
                    descriptionIsContained = ((IContainer)containers.get(i)).hasResourceDescription(uri);
                    ++i;
                }
                if (!descriptionIsContained && !this.isProjectDependency(uri, candidate.getURI(), checkedProjects)) {
                    return false;
                }
            }
            if (!this.isAffected(importedNames, delta.getNew()) && !this.isAffected(importedNames, delta.getOld())) continue;
            return true;
        }
        return false;
    }

    private boolean isProjectDependency(URI deltaURI, URI candidateURI, Map<String, Boolean> checkedProjects) {
        if (deltaURI.isPlatformResource() && candidateURI.isPlatformResource()) {
            String deltaProjectName = URI.decode((String)deltaURI.segment(1));
            Boolean prev = checkedProjects.get(deltaProjectName);
            if (prev == null) {
                String candidateProjectName;
                IProject candidateProject;
                IProject deltaProject = this.workspaceRoot.getProject(deltaProjectName);
                if (deltaProject.isAccessible() && JavaCore.create((IProject)deltaProject).exists() && (candidateProject = this.workspaceRoot.getProject(candidateProjectName = URI.decode((String)candidateURI.segment(1)))).isAccessible() && JavaCore.create((IProject)deltaProject).exists()) {
                    if (candidateProject.equals((Object)deltaProject)) {
                        return this.checked(checkedProjects, deltaProjectName, true);
                    }
                    try {
                        if (Arrays.asList(candidateProject.getReferencedProjects()).contains(deltaProject)) {
                            return this.checked(checkedProjects, deltaProjectName, true);
                        }
                    }
                    catch (CoreException coreException) {
                        return this.checked(checkedProjects, deltaProjectName, false);
                    }
                }
                return this.checked(checkedProjects, deltaProjectName, false);
            }
            return prev;
        }
        return false;
    }

    private boolean checked(Map<String, Boolean> checkedProjects, String deltaProjectName, boolean result) {
        checkedProjects.put(deltaProjectName, result);
        return result;
    }
}

