/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.XtendTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.SourceTypeLookup;
import org.eclipse.xtend.lib.macro.services.TypeLookup;
import org.eclipse.xtend.lib.macro.services.UpstreamTypeLookup;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtype.XtypePackage;

public class TypeLookupImpl
implements TypeLookup,
SourceTypeLookup,
UpstreamTypeLookup {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeLookupImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public MutableAnnotationTypeDeclaration findAnnotationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableAnnotationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableAnnotationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableAnnotationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableClassDeclaration findClass(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableClassDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableClassDeclaration) {
            _matched = true;
            _switchResult = (MutableClassDeclaration)type;
        }
        return _switchResult;
    }

    public MutableEnumerationTypeDeclaration findEnumerationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableEnumerationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableEnumerationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableEnumerationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableInterfaceDeclaration findInterface(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableInterfaceDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableInterfaceDeclaration) {
            _matched = true;
            _switchResult = (MutableInterfaceDeclaration)type;
        }
        return _switchResult;
    }

    private Type findType(String qualifiedName) {
        boolean _notEquals;
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        EList _contents = _eResource.getContents();
        Iterable _filter = Iterables.filter((Iterable)_contents, JvmDeclaredType.class);
        Functions.Function1<JvmDeclaredType, String> _function = new Functions.Function1<JvmDeclaredType, String>(){

            public String apply(JvmDeclaredType type) {
                return type.getQualifiedName('.');
            }
        };
        Functions.Function1<JvmDeclaredType, Iterable<? extends JvmDeclaredType>> _function_1 = new Functions.Function1<JvmDeclaredType, Iterable<? extends JvmDeclaredType>>(){

            public Iterable<? extends JvmDeclaredType> apply(JvmDeclaredType type) {
                EList _members = type.getMembers();
                return Iterables.filter((Iterable)_members, JvmDeclaredType.class);
            }
        };
        JvmDeclaredType result = this.recursiveFindType(qualifiedName, _filter, _function, _function_1);
        Type _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)result, null);
        if (_notEquals) {
            _xifexpression = this.compilationUnit.toType((JvmType)result);
        }
        return _xifexpression;
    }

    public ClassDeclaration findSourceClass(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof ClassDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (ClassDeclaration)_switchResult;
    }

    public InterfaceDeclaration findSourceInterface(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof InterfaceDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (InterfaceDeclaration)_switchResult;
    }

    public EnumerationTypeDeclaration findSourceEnumerationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof EnumerationTypeDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (EnumerationTypeDeclaration)_switchResult;
    }

    public AnnotationTypeDeclaration findSourceAnnotationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof AnnotationTypeDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (AnnotationTypeDeclaration)_switchResult;
    }

    private XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> findSourceType(String qualifiedName) {
        boolean _notEquals;
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        EList _contents = _eResource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        EList<XtendTypeDeclaration> _xtendTypes = ((XtendFile)_head).getXtendTypes();
        Functions.Function1<XtendTypeDeclaration, String> _function = new Functions.Function1<XtendTypeDeclaration, String>(){

            public String apply(XtendTypeDeclaration type) {
                IQualifiedNameConverter _qualifiedNameConverter = TypeLookupImpl.this.compilationUnit.getQualifiedNameConverter();
                IQualifiedNameProvider _qualifiedNameProvider = TypeLookupImpl.this.compilationUnit.getQualifiedNameProvider();
                QualifiedName _fullyQualifiedName = _qualifiedNameProvider.getFullyQualifiedName((EObject)type);
                return _qualifiedNameConverter.toString(_fullyQualifiedName);
            }
        };
        Functions.Function1<XtendTypeDeclaration, Iterable<? extends XtendTypeDeclaration>> _function_1 = new Functions.Function1<XtendTypeDeclaration, Iterable<? extends XtendTypeDeclaration>>(){

            public Iterable<? extends XtendTypeDeclaration> apply(XtendTypeDeclaration type) {
                EList<XtendMember> _members = type.getMembers();
                return Iterables.filter(_members, XtendTypeDeclaration.class);
            }
        };
        XtendTypeDeclaration result = this.recursiveFindType(qualifiedName, (Iterable)_xtendTypes, (Functions.Function1)_function, (Functions.Function1)_function_1);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)result, null);
        if (_notEquals) {
            _xifexpression = this.compilationUnit.toXtendTypeDeclaration(result);
        }
        return _xifexpression;
    }

    private <T> T recursiveFindType(String qualifiedName, Iterable<? extends T> typeDeclarations, Functions.Function1<? super T, ? extends String> qualifiedNameProvider, Functions.Function1<? super T, ? extends Iterable<? extends T>> subTypeProvider) {
        int dot = 46;
        for (T type : typeDeclarations) {
            String name = (String)qualifiedNameProvider.apply(type);
            boolean _equals = Objects.equal((Object)qualifiedName, (Object)name);
            if (_equals) {
                return type;
            }
            if (!qualifiedName.startsWith(name) || qualifiedName.charAt(name.length()) != '.') continue;
            Iterable _apply = (Iterable)subTypeProvider.apply(type);
            return this.recursiveFindType(qualifiedName, _apply, qualifiedNameProvider, subTypeProvider);
        }
        return null;
    }

    public Type findTypeGlobally(Class<?> clazz) {
        String _canonicalName = clazz.getCanonicalName();
        return this.findTypeGlobally(_canonicalName);
    }

    public Type findTypeGlobally(String typeName) {
        Type _elvis = null;
        Type _findType = this.findType(typeName);
        if (_findType != null) {
            _elvis = _findType;
        } else {
            Type _findTypeOnScope;
            Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

                public Boolean apply(IEObjectDescription it) {
                    return true;
                }
            };
            _elvis = _findTypeOnScope = this.findTypeOnScope(typeName, (Functions.Function1<? super IEObjectDescription, ? extends Boolean>)_function);
        }
        return _elvis;
    }

    public Type findUpstreamType(Class<?> clazz) {
        String _canonicalName = clazz.getCanonicalName();
        return this.findUpstreamType(_canonicalName);
    }

    public Type findUpstreamType(String typeName) {
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                XtendFile _xtendFile;
                Resource _eResource_1;
                EObject _eObjectOrProxy = it.getEObjectOrProxy();
                Resource _eResource = _eObjectOrProxy.eResource();
                return !Objects.equal((Object)_eResource, (Object)(_eResource_1 = (_xtendFile = TypeLookupImpl.this.compilationUnit.getXtendFile()).eResource()));
            }
        };
        return this.findTypeOnScope(typeName, (Functions.Function1<? super IEObjectDescription, ? extends Boolean>)_function);
    }

    private Type findTypeOnScope(String typeName, Functions.Function1<? super IEObjectDescription, ? extends Boolean> filter) {
        XtendFile _xtendFile;
        IQualifiedNameConverter _qualifiedNameConverter = this.compilationUnit.getQualifiedNameConverter();
        QualifiedName qualifiedName = _qualifiedNameConverter.toQualifiedName(typeName);
        IScopeProvider _scopeProvider = this.compilationUnit.getScopeProvider();
        IScope _scope = _scopeProvider.getScope((EObject)(_xtendFile = this.compilationUnit.getXtendFile()), XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE);
        IEObjectDescription result = _scope.getSingleElement(qualifiedName);
        if (result != null && TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(result.getEClass()) && ((Boolean)filter.apply((Object)result)).booleanValue()) {
            EObject _eObjectOrProxy = result.getEObjectOrProxy();
            return this.compilationUnit.toType((JvmType)_eObjectOrProxy);
        }
        return null;
    }
}

