/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.EPackageInfo;
import org.eclipse.xtext.xtext.wizard.Ecore2XtextConfiguration;
import org.eclipse.xtext.xtext.wizard.ExternalDependency;
import org.eclipse.xtext.xtext.wizard.GradleBuildFile;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ParentProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.PlainTextFile;
import org.eclipse.xtext.xtext.wizard.PomFile;
import org.eclipse.xtext.xtext.wizard.ProjectLayout;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

@FinalFieldsConstructor
@Accessors
public abstract class ProjectDescriptor {
    private final WizardConfiguration config;
    private boolean enabled;

    public String getName() {
        String _baseName = this.config.getBaseName();
        String _nameQualifier = this.getNameQualifier();
        return String.valueOf(_baseName) + _nameQualifier;
    }

    public abstract String getNameQualifier();

    public String getLocation() {
        String _xifexpression = null;
        ProjectLayout _projectLayout = this.config.getProjectLayout();
        boolean _equals = Objects.equal((Object)((Object)_projectLayout), (Object)((Object)ProjectLayout.FLAT));
        if (_equals) {
            String _rootLocation = this.config.getRootLocation();
            String _plus = String.valueOf(_rootLocation) + "/";
            String _name = this.getName();
            _xifexpression = String.valueOf(_plus) + _name;
        } else {
            ParentProjectDescriptor _parentProject = this.config.getParentProject();
            String _location = _parentProject.getLocation();
            String _plus_1 = String.valueOf(_location) + "/";
            String _name_1 = this.getName();
            _xifexpression = String.valueOf(_plus_1) + _name_1;
        }
        return _xifexpression;
    }

    public Set<? extends ProjectDescriptor> getUpstreamProjects() {
        return CollectionLiterals.emptySet();
    }

    public Set<String> getSourceFolders() {
        Functions.Function1<Outlet, String> _function = new Functions.Function1<Outlet, String>(){

            public String apply(Outlet it) {
                return ProjectDescriptor.this.sourceFolder(it);
            }
        };
        List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Outlet[]{Outlet.MAIN_JAVA, Outlet.MAIN_RESOURCES, Outlet.MAIN_SRC_GEN, Outlet.MAIN_XTEND_GEN})), (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_map);
    }

    public Iterable<? extends AbstractFile> getFiles() {
        boolean _isPartOfMavenBuild;
        boolean _isPartOfGradleBuild;
        ArrayList files = CollectionLiterals.newArrayList((Object[])new TextFile[0]);
        boolean _isEclipsePluginProject = this.isEclipsePluginProject();
        if (_isEclipsePluginProject) {
            String _manifest = this.manifest();
            PlainTextFile _file = this.file(Outlet.META_INF, "MANIFEST.MF", _manifest);
            files.add(_file);
            CharSequence _buildProperties = this.buildProperties();
            PlainTextFile _file_1 = this.file(Outlet.ROOT, "build.properties", _buildProperties);
            files.add(_file_1);
        }
        boolean _and = false;
        boolean _needsGradleBuild = this.config.needsGradleBuild();
        _and = !_needsGradleBuild ? false : (_isPartOfGradleBuild = this.isPartOfGradleBuild());
        if (_and) {
            GradleBuildFile _buildGradle = this.buildGradle();
            files.add(_buildGradle);
        }
        boolean _and_1 = false;
        boolean _needsMavenBuild = this.config.needsMavenBuild();
        _and_1 = !_needsMavenBuild ? false : (_isPartOfMavenBuild = this.isPartOfMavenBuild());
        if (_and_1) {
            PomFile _pom = this.pom();
            files.add(_pom);
        }
        return files;
    }

    public abstract boolean isPartOfGradleBuild();

    public abstract boolean isPartOfMavenBuild();

    public abstract boolean isEclipsePluginProject();

    public CharSequence buildProperties() {
        StringConcatenation _builder = new StringConcatenation();
        Set<String> _sourceFolders = this.getSourceFolders();
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return String.valueOf(it) + "/";
            }
        };
        Iterable _map = IterableExtensions.map(_sourceFolders, (Functions.Function1)_function);
        String _buildPropertiesEntry = this.buildPropertiesEntry("source..", _map);
        _builder.append((Object)_buildPropertiesEntry, "");
        _builder.newLineIfNotEmpty();
        Set<String> _binIncludes = this.getBinIncludes();
        String _buildPropertiesEntry_1 = this.buildPropertiesEntry("bin.includes", _binIncludes);
        _builder.append((Object)_buildPropertiesEntry_1, "");
        _builder.newLineIfNotEmpty();
        Set<String> _developmentBundles = this.getDevelopmentBundles();
        String _buildPropertiesEntry_2 = this.buildPropertiesEntry("additional.bundles", _developmentBundles);
        _builder.append((Object)_buildPropertiesEntry_2, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public Set<String> getBinIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        String _sourceFolder = this.sourceFolder(Outlet.META_INF);
        _builder.append((Object)_sourceFolder, "");
        _builder.append((Object)"/");
        return CollectionLiterals.newLinkedHashSet((Object[])new String[]{".", _builder.toString()});
    }

    public Set<String> getDevelopmentBundles() {
        return CollectionLiterals.emptySet();
    }

    private String buildPropertiesEntry(String key, Iterable<String> value) {
        String _xblockexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(value);
        if (_isEmpty) {
            return "";
        }
        String assignment = String.valueOf(key) + " = ";
        int _length = assignment.length();
        String indent = Strings.repeat((String)" ", (int)_length);
        String _join = IterableExtensions.join(value, (CharSequence)(",\\\n" + indent));
        _xblockexpression = String.valueOf(assignment) + _join;
        return _xblockexpression;
    }

    public String manifest() {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Manifest-Version: 1.0");
        _builder.newLine();
        _builder.append((Object)"Bundle-ManifestVersion: 2");
        _builder.newLine();
        _builder.append((Object)"Bundle-Name: ");
        String _name = this.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-Vendor: My Company");
        _builder.newLine();
        _builder.append((Object)"Bundle-Version: 1.0.0.qualifier");
        _builder.newLine();
        _builder.append((Object)"Bundle-SymbolicName: ");
        String _name_1 = this.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"; singleton:=true");
        _builder.newLineIfNotEmpty();
        Object _activatorClassName = this.getActivatorClassName();
        boolean bl = _notEquals = !Objects.equal((Object)_activatorClassName, null);
        if (_notEquals) {
            _builder.append((Object)"Bundle-Activator: ");
            Object _activatorClassName_1 = this.getActivatorClassName();
            _builder.append(_activatorClassName_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"Bundle-ActivationPolicy: lazy");
        _builder.newLine();
        Set<String> _requiredBundles = this.getRequiredBundles();
        String _manifestEntry = this.manifestEntry("Require-Bundle", _requiredBundles);
        _builder.append((Object)_manifestEntry, "");
        _builder.newLineIfNotEmpty();
        Set<String> _importedPackages = this.getImportedPackages();
        String _manifestEntry_1 = this.manifestEntry("Import-Package", _importedPackages);
        _builder.append((Object)_manifestEntry_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-RequiredExecutionEnvironment: ");
        String _bree = this.getBree();
        _builder.append((Object)_bree, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String getBree() {
        JavaVersion _javaVersion = this.config.getJavaVersion();
        return _javaVersion.getBree();
    }

    private String manifestEntry(String key, Iterable<String> value) {
        boolean _isEmpty = IterableExtensions.isEmpty(value);
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)key, "");
        _builder.append((Object)": ");
        String _join = IterableExtensions.join(value, (CharSequence)",\n ");
        _builder.append((Object)_join, "");
        return _builder.toString();
    }

    public Set<String> getRequiredBundles() {
        LinkedHashSet _xblockexpression = null;
        LinkedHashSet bundles = CollectionLiterals.newLinkedHashSet((Object[])new String[0]);
        Set<? extends ProjectDescriptor> _upstreamProjects = this.getUpstreamProjects();
        Functions.Function1<ProjectDescriptor, String> _function = new Functions.Function1<ProjectDescriptor, String>(){

            public String apply(ProjectDescriptor it) {
                return it.getName();
            }
        };
        Iterable _map = IterableExtensions.map(_upstreamProjects, (Functions.Function1)_function);
        Iterables.addAll((Collection)bundles, (Iterable)_map);
        Set<ExternalDependency> _externalDependencies = this.getExternalDependencies();
        Functions.Function1<ExternalDependency, ExternalDependency.P2Coordinates> _function_1 = new Functions.Function1<ExternalDependency, ExternalDependency.P2Coordinates>(){

            public ExternalDependency.P2Coordinates apply(ExternalDependency it) {
                return it.getP2();
            }
        };
        Iterable _map_1 = IterableExtensions.map(_externalDependencies, (Functions.Function1)_function_1);
        Functions.Function1<ExternalDependency.P2Coordinates, Boolean> _function_2 = new Functions.Function1<ExternalDependency.P2Coordinates, Boolean>(){

            public Boolean apply(ExternalDependency.P2Coordinates it) {
                String _bundleId = it.getBundleId();
                return !Objects.equal((Object)_bundleId, null);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_map_1, (Functions.Function1)_function_2);
        Functions.Function1<ExternalDependency.P2Coordinates, String> _function_3 = new Functions.Function1<ExternalDependency.P2Coordinates, String>(){

            public String apply(ExternalDependency.P2Coordinates it) {
                String _bundleId = it.getBundleId();
                String _xifexpression = null;
                String _version = it.getVersion();
                boolean _equals = Objects.equal((Object)_version, null);
                if (_equals) {
                    _xifexpression = "";
                } else {
                    String _version_1 = it.getVersion();
                    String _plus = ";bundle-version=\"" + _version_1;
                    _xifexpression = String.valueOf(_plus) + "\"";
                }
                return String.valueOf(_bundleId) + _xifexpression;
            }
        };
        Iterable _map_2 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_3);
        Iterables.addAll((Collection)bundles, (Iterable)_map_2);
        _xblockexpression = bundles;
        return _xblockexpression;
    }

    public Set<String> getImportedPackages() {
        Set<ExternalDependency> _externalDependencies = this.getExternalDependencies();
        Functions.Function1<ExternalDependency, Set<String>> _function = new Functions.Function1<ExternalDependency, Set<String>>(){

            public Set<String> apply(ExternalDependency it) {
                ExternalDependency.P2Coordinates _p2 = it.getP2();
                return _p2.getPackages();
            }
        };
        Iterable _map = IterableExtensions.map(_externalDependencies, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toSet((Iterable)_flatten);
    }

    public Set<ExternalDependency> getExternalDependencies() {
        LinkedHashSet deps = CollectionLiterals.newLinkedHashSet((Object[])new ExternalDependency[0]);
        Ecore2XtextConfiguration _ecore2Xtext = this.config.getEcore2Xtext();
        Set<EPackageInfo> _ePackageInfos = _ecore2Xtext.getEPackageInfos();
        for (EPackageInfo ePackage : _ePackageInfos) {
            String _bundleID = ePackage.getBundleID();
            ExternalDependency _createBundleDependency = ExternalDependency.createBundleDependency(_bundleID);
            deps.add(_createBundleDependency);
        }
        return deps;
    }

    public Object getActivatorClassName() {
        return null;
    }

    public GradleBuildFile buildGradle() {
        return new GradleBuildFile(this);
    }

    public PomFile pom() {
        return new PomFile(this);
    }

    public String sourceFolder(Outlet outlet) {
        SourceLayout _sourceLayout = this.config.getSourceLayout();
        return _sourceLayout.getPathFor(outlet);
    }

    protected PlainTextFile file(Outlet outlet, String relativePath, CharSequence content) {
        return new PlainTextFile(outlet, relativePath, this, content);
    }

    protected PlainTextFile file(Outlet outlet, String relativePath, CharSequence content, boolean executable) {
        return new PlainTextFile(outlet, relativePath, this, content, executable);
    }

    protected BinaryFile binaryFile(Outlet outlet, String relativePath, URL url) {
        return new BinaryFile(outlet, relativePath, this, false, url);
    }

    public ProjectDescriptor(WizardConfiguration config) {
        this.config = config;
    }

    @Pure
    public WizardConfiguration getConfig() {
        return this.config;
    }

    @Pure
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

