/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;

public class ResolvingTypeParameterHintCollector
extends ExpectationTypeParameterHintCollector {
    private final BoundTypeArgumentSource source;

    public ResolvingTypeParameterHintCollector(ITypeReferenceOwner owner, BoundTypeArgumentSource source) {
        super(owner);
        this.source = source;
    }

    @Override
    protected BoundTypeArgumentSource getTypeArgumentSource() {
        return this.source;
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new UnboundParameterizedTypeReferencePreserver();
    }

    @Override
    protected AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
        return new UnboundArrayTypeReferencePreserver();
    }

    protected class UnboundArrayTypeReferencePreserver
    extends ExpectationTypeParameterHintCollector.DeferredArrayTypeReferenceTraverser {
        protected UnboundArrayTypeReferencePreserver() {
            super(ResolvingTypeParameterHintCollector.this);
        }

        @Override
        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ArrayTypeReference declaration) {
            if (reference.internalIsResolved() || ResolvingTypeParameterHintCollector.this.getOwner().isResolved(reference.getHandle())) {
                reference.tryResolve();
                ResolvingTypeParameterHintCollector.this.outerVisit(reference, declaration);
            } else {
                ResolvingTypeParameterHintCollector.this.addHint(reference, declaration);
            }
        }
    }

    protected class UnboundParameterizedTypeReferencePreserver
    extends ExpectationTypeParameterHintCollector.DeferredParameterizedTypeReferenceTraverser {
        protected UnboundParameterizedTypeReferencePreserver() {
            super(ResolvingTypeParameterHintCollector.this);
        }

        @Override
        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
            if (reference.internalIsResolved() || ResolvingTypeParameterHintCollector.this.getOwner().isResolved(reference.getHandle())) {
                reference.tryResolve();
                ResolvingTypeParameterHintCollector.this.outerVisit(reference, declaration);
            } else {
                ResolvingTypeParameterHintCollector.this.addHint(reference, declaration);
            }
        }
    }
}

