/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.validator;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.core.macro.XAnnotationExtensions;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.ui.validation.XbaseUIValidator;

public class XtendUIValidator
extends XbaseUIValidator {
    private static final Logger LOG = Logger.getLogger(XtendUIValidator.class);
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private XAnnotationExtensions annotationExtensions;
    @Inject
    private IJavaProjectProvider projectProvider;

    protected List<EPackage> getEPackages() {
        List packages = super.getEPackages();
        packages.add(XtendPackage.eINSTANCE);
        packages.add(XAnnotationsPackage.eINSTANCE);
        return packages;
    }

    @Check
    protected void checkAnnotationInSameProject(XAnnotation annotation) throws JavaModelException {
        block3: {
            try {
                JvmType annotationType;
                if (this.annotationExtensions.isProcessed(annotation) && this.isSameProject(annotation, annotationType = annotation.getAnnotationType())) {
                    this.error("The referenced active annotation cannot be used from within the same project.", (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, "org.eclipse.xtend.core.validation.IssueCodes.active_annotation_in_same_project", new String[0]);
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block3;
                throw e;
            }
        }
    }

    protected boolean isSameProject(XAnnotation annotation, JvmType annotationType) throws JavaModelException {
        IJavaProject project = this.projectProvider.getJavaProject(annotation.eResource().getResourceSet());
        if (annotationType.eResource().getURI().isPlatformResource()) {
            String projectName = annotationType.eResource().getURI().segments()[1];
            return project.getProject().getName().equals(projectName);
        }
        IType type = project.findType(annotationType.getIdentifier());
        if (type != null && type.getUnderlyingResource() instanceof IFile) {
            return this.isInSourceFolder(project, (IFile)type.getUnderlyingResource());
        }
        return false;
    }

    protected boolean isInSourceFolder(IJavaProject javaProject, IFile resource) {
        IClasspathEntry[] classpath;
        IPath path = resource.getFullPath();
        try {
            classpath = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IPath entryPath;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (entryPath = entry.getPath()).isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Check
    public void checkFileNamingConventions(XtendFile xtendFile) {
        String expectedPackage = this.getExpectedPackageName(xtendFile);
        String declaredPackage = xtendFile.getPackage();
        if (!(expectedPackage == null || Strings.isEmpty((String)expectedPackage) && declaredPackage == null || expectedPackage.equals(declaredPackage))) {
            this.error("The declared package '" + Strings.notNull((Object)declaredPackage) + "' does not match the expected package '" + Strings.notNull((Object)expectedPackage) + "'", (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_package", new String[]{expectedPackage});
        }
    }

    protected String getExpectedPackageName(XtendFile xtendFile) {
        URI fileURI = xtendFile.eResource().getURI();
        for (Pair storage : this.storage2UriMapper.getStorages(fileURI)) {
            if (!(storage.getFirst() instanceof IFile)) continue;
            IPath fileWorkspacePath = ((IStorage)storage.getFirst()).getFullPath();
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)storage.getSecond()));
            if (javaProject == null || !javaProject.exists() || !javaProject.isOpen()) continue;
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath sourceFolderPath;
                    IResource resource;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && !root.isExternal() && (resource = root.getResource()) != null && (sourceFolderPath = resource.getFullPath()).isPrefixOf(fileWorkspacePath)) {
                        IPath claspathRelativePath = fileWorkspacePath.makeRelativeTo(sourceFolderPath);
                        return claspathRelativePath.removeLastSegments(1).toString().replace("/", ".");
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)"Error resolving expected path for XtendFile", (Throwable)e);
            }
        }
        return null;
    }
}

