/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.util.EmfFormatter;

public class Context2NameFunction
implements Function<EObject, String> {
    public String apply(EObject from) {
        return this.getContextName(from);
    }

    public String getContextName(Action ctx) {
        ParserRule rule = EcoreUtil2.getContainerOfType(ctx, ParserRule.class);
        return String.valueOf(rule.getName()) + "_" + this.getUniqueActionName(ctx);
    }

    public String getContextName(EObject ctx) {
        if (GrammarUtil.isEObjectRule(ctx)) {
            return this.getContextName((ParserRule)ctx);
        }
        if (GrammarUtil.isAssignedAction(ctx)) {
            return this.getContextName((Action)ctx);
        }
        throw new RuntimeException("Invalid Context: " + EmfFormatter.objPath((EObject)ctx));
    }

    public String getContextName(ParserRule ctx) {
        return ctx.getName();
    }

    public String getUniqueActionName(Action action) {
        ArrayList indices = Lists.newArrayList();
        Action current = action;
        while (current.eContainer() instanceof AbstractElement) {
            indices.add(current.eContainer().eContents().indexOf((Object)current));
            current = current.eContainer();
        }
        Collections.reverse(indices);
        return String.valueOf(action.getType().getClassifier().getName()) + "_" + Joiner.on((char)'_').join((Iterable)indices);
    }
}

