/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.ICaseInsensitivityHelper;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

public class ImportedNamespaceAwareLocalScopeProvider
extends AbstractGlobalScopeDelegatingScopeProvider {
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    @Inject
    public ImportedNamespaceAwareLocalScopeProvider() {
    }

    public ImportedNamespaceAwareLocalScopeProvider(IGlobalScopeProvider globalScopeProvider, IQualifiedNameProvider qualifiedNameProvider, IQualifiedNameConverter qualifiedNameConverter, ICaseInsensitivityHelper caseInsensitivityHelper) {
        super(globalScopeProvider, caseInsensitivityHelper);
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.qualifiedNameConverter = qualifiedNameConverter;
    }

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return this.qualifiedNameProvider;
    }

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        IScope result = null;
        result = context.eContainer() != null ? this.getScope(context.eContainer(), reference) : this.getResourceScope(context.eResource(), reference);
        return this.getLocalElementsScope(result, context, reference);
    }

    protected IScope getResourceScope(Resource res, EReference reference) {
        EObject context = (EObject)res.getContents().get(0);
        IScope globalScope = this.getGlobalScope(res, reference);
        List<ImportNormalizer> normalizers = this.getImplicitImports(this.isIgnoreCase(reference));
        if (!normalizers.isEmpty()) {
            globalScope = this.createImportScope(globalScope, normalizers, null, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return this.getResourceScope(globalScope, context, reference);
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        return Collections.emptyList();
    }

    protected IScope getResourceScope(IScope parent, EObject context, EReference reference) {
        if (context.eResource() == null) {
            return parent;
        }
        ISelectable allDescriptions = this.getAllDescriptions(context.eResource());
        return SelectableBasedScope.createScope(parent, allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
    }

    protected Object getKey(Notifier context, EReference reference) {
        return Tuples.create(ImportedNamespaceAwareLocalScopeProvider.class, (Object)context, (Object)reference);
    }

    protected List<ImportNormalizer> getImportedNamespaceResolvers(final EObject context, final boolean ignoreCase) {
        return (List)this.cache.get((Object)Tuples.create((Object)context, (Object)ignoreCase, (Object)"imports"), context.eResource(), (Provider)new Provider<List<ImportNormalizer>>(){

            public List<ImportNormalizer> get() {
                return ImportedNamespaceAwareLocalScopeProvider.this.internalGetImportedNamespaceResolvers(context, ignoreCase);
            }
        });
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        EList eContents = context.eContents();
        for (EObject child : eContents) {
            String value = this.getImportedNamespace(child);
            ImportNormalizer resolver = this.createImportedNamespaceResolver(value, ignoreCase);
            if (resolver == null) continue;
            importedNamespaceResolvers.add(resolver);
        }
        return importedNamespaceResolvers;
    }

    protected String getImportedNamespace(EObject object) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature("importedNamespace");
        if (feature != null && String.class.equals((Object)feature.getEType().getInstanceClass())) {
            return (String)object.eGet(feature);
        }
        return null;
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        boolean hasWildCard;
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.qualifiedNameConverter.toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.getSegmentCount() < 1) {
            return null;
        }
        boolean bl = hasWildCard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildCard()) : importedNamespace.getLastSegment().equals(this.getWildCard());
        if (hasWildCard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, false, ignoreCase);
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new ImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        ImportNormalizer localNormalizer;
        IScope result = parent;
        ISelectable allDescriptions = this.getAllDescriptions(context.eResource());
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        List<ImportNormalizer> namespaceResolvers = this.getImportedNamespaceResolvers(context, ignoreCase);
        if (!namespaceResolvers.isEmpty()) {
            if (this.isRelativeImport() && name != null) {
                localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
                result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
            }
            result = this.createImportScope(result, namespaceResolvers, null, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        if (name != null) {
            localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return result;
    }

    protected ImportScope createImportScope(IScope parent, List<ImportNormalizer> namespaceResolvers, ISelectable importFrom, EClass type, boolean ignoreCase) {
        return new ImportScope(namespaceResolvers, parent, importFrom, type, ignoreCase);
    }

    protected QualifiedName getQualifiedNameOfLocalElement(EObject context) {
        return this.qualifiedNameProvider.getFullyQualifiedName(context);
    }

    protected boolean isRelativeImport() {
        return true;
    }

    protected ISelectable getAllDescriptions(final Resource resource) {
        return (ISelectable)this.cache.get((Object)"internalGetAllDescriptions", resource, (Provider)new Provider<ISelectable>(){

            public ISelectable get() {
                return ImportedNamespaceAwareLocalScopeProvider.this.internalGetAllDescriptions(resource);
            }
        });
    }

    protected ISelectable internalGetAllDescriptions(final Resource resource) {
        Iterable<EObject> allContents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            }
        };
        Iterable<IEObjectDescription> allDescriptions = Scopes.scopedElementsFor(allContents, this.qualifiedNameProvider);
        return new MultimapBasedSelectable(allDescriptions);
    }

    public String getWildCard() {
        return "*";
    }
}

