/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.javaconverter;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.core.javaconverter.JavaConverter;

public class ConversionProblemsDialog
extends Dialog {
    private Map<ICompilationUnit, JavaConverter.ConversionResult> input;
    private CompareViewerPane javaFilesPane;
    private Table javaFilesTable;
    private Set<ICompilationUnit> excluded = new HashSet<ICompilationUnit>();
    private CompareViewerPane problemsPane;
    private Table problemsTable;
    private Button okButton;
    private ICompilationUnit currentCU;
    protected Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");

    public ConversionProblemsDialog(Shell parentShell, Map<ICompilationUnit, JavaConverter.ConversionResult> input) {
        super(parentShell);
        this.input = input;
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        if (this.javaFilesTable != null && !this.javaFilesTable.isDisposed()) {
            for (Map.Entry<ICompilationUnit, JavaConverter.ConversionResult> entry : this.input.entrySet()) {
                if (!entry.getValue().getProblems().iterator().hasNext()) continue;
                ICompilationUnit cu = entry.getKey();
                IResource resource = cu.getResource();
                TableItem ti = new TableItem(this.javaFilesTable, 0);
                ti.setImage(CompareUI.getImage((IAdaptable)resource));
                ti.setText(resource.getName());
                ti.setData((Object)cu);
                ti.setChecked(true);
            }
        }
        if (this.javaFilesTable.getItems().length > 0) {
            this.javaFilesTable.select(0);
            this.handleMemberSelect((Widget)this.javaFilesTable.getItems()[0]);
        }
    }

    protected void okPressed() {
        for (ICompilationUnit iCompilationUnit : this.excluded) {
            this.input.remove(iCompilationUnit);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(600, initialSize.y);
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.getShell().setText("Problems occured during conversion");
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData((Object)new GridData(1808));
        Composite c = new Composite((Composite)vsplitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 1;
        c.setLayout((Layout)layout);
        Label l1 = new Label(c, 0);
        l1.setText("Select files which should be converted anyway:");
        this.javaFilesPane = new CompareViewerPane(c, 0x800800);
        GridData gd = new GridData(1808);
        this.javaFilesPane.setLayoutData((Object)gd);
        this.javaFilesPane.setText("Files with unrecoverable problems");
        this.javaFilesTable = new Table((Composite)this.javaFilesPane, 800);
        this.javaFilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    if (e.item instanceof TableItem) {
                        TableItem ti = (TableItem)e.item;
                        if (!ti.getChecked()) {
                            ConversionProblemsDialog.this.excluded.add((ICompilationUnit)ti.getData());
                        } else {
                            ConversionProblemsDialog.this.excluded.remove(ti.getData());
                        }
                    }
                } else {
                    ConversionProblemsDialog.this.handleMemberSelect(e.item);
                }
            }
        });
        this.javaFilesPane.setContent((Control)this.javaFilesTable);
        c = new Composite((Composite)vsplitter, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 1;
        c.setLayout((Layout)layout);
        Label l2 = new Label(c, 0);
        l2.setText("Choose a file in the file table to show problems:");
        this.problemsPane = new CompareViewerPane(c, 0x800800);
        gd = new GridData(1808);
        this.problemsPane.setLayoutData((Object)gd);
        this.problemsTable = new Table((Composite)this.problemsPane, 768);
        this.problemsPane.setContent((Control)this.problemsTable);
        ConversionProblemsDialog.applyDialogFont((Control)parent);
        vsplitter.setWeights(new int[]{50, 50});
        return parent;
    }

    protected void handleMemberSelect(Widget item) {
        Object data = null;
        if (item != null) {
            data = item.getData();
        }
        if (data instanceof ICompilationUnit) {
            this.currentCU = (ICompilationUnit)data;
            this.problemsPane.setImage(CompareUI.getImage((IAdaptable)this.currentCU.getResource()));
            String pattern = "Problems in file {0}";
            String title = MessageFormat.format((String)pattern, (Object[])new Object[]{this.currentCU.getResource().getName()});
            this.problemsPane.setText(title);
            if (this.problemsTable != null) {
                this.problemsTable.setRedraw(false);
                this.problemsTable.removeAll();
                JavaConverter.ConversionResult conversionResult = this.input.get(this.currentCU);
                for (String problem : conversionResult.getProblems()) {
                    this.addProblemItem(problem);
                }
                this.problemsTable.setRedraw(true);
            }
        } else {
            this.currentCU = null;
        }
    }

    private void addProblemItem(String problem) {
        if (this.problemsTable == null || this.problemsTable.isDisposed()) {
            return;
        }
        TableItem ti = new TableItem(this.problemsTable, 0);
        ti.setImage(this.errorImage);
        ti.setText(problem);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
        this.okButton.setEnabled(true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

