/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.CompositeScope;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDelegateScope;
import org.eclipse.xtext.xbase.scoping.batch.DynamicExtensionsScope;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.LocalVariableScope;
import org.eclipse.xtext.xbase.scoping.batch.NestedTypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.batch.ReceiverFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureOnTypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.SynonymTypeBucket;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.batch.TypeLiteralScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;

@Singleton
public class FeatureScopes
implements IFeatureNames {
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private IResolvedFeatures.Provider resolvedFeaturesProvider;
    @Inject
    private SynonymTypesProvider synonymProvider;
    @Inject(optional=true)
    private XbaseFactory xbaseFactory = XbaseFactory.eINSTANCE;
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;

    public IScope createFeatureCallScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!this.isFeatureCallScope(reference)) {
            throw new IllegalArgumentException(String.valueOf(reference));
        }
        if (!(context instanceof XAbstractFeatureCall)) {
            return IScope.NULLSCOPE;
        }
        XAbstractFeatureCall call = (XAbstractFeatureCall)context;
        XExpression syntacticalReceiver = this.getSyntacticalReceiver(call);
        if (syntacticalReceiver == null) {
            IScope result = this.createSimpleFeatureCallScope(call, session, resolvedTypes);
            return result;
        }
        IScope result = this.createFeatureCallScopeForReceiver(call, syntacticalReceiver, session, resolvedTypes);
        return result;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    public IScope createSimpleFeatureCallScope(EObject context, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        XFeatureCall featureCall;
        IScope root = IScope.NULLSCOPE;
        if (context instanceof XFeatureCall && !(featureCall = (XFeatureCall)context).isExplicitOperationCallOrBuilderSyntax()) {
            root = this.createTypeLiteralScope(context, QualifiedName.EMPTY, root, session, resolvedTypes);
            if (this.isDefiniteTypeLiteral(featureCall)) {
                return root;
            }
        }
        IScope staticImports = this.createStaticFeaturesScope(context, root, session);
        IScope staticMembers = this.createStaticScope(this.asAbstractFeatureCall(context), null, null, staticImports, session, resolvedTypes);
        IScope staticExtensions = this.createStaticExtensionsScope(null, null, context, staticMembers, session, resolvedTypes);
        IScope dynamicExtensions = this.createDynamicExtensionsScope(null, null, context, staticExtensions, session, resolvedTypes);
        IScope localVariables = this.createImplicitFeatureCallAndLocalVariableScope(context, dynamicExtensions, session, resolvedTypes);
        return localVariables;
    }

    protected IScope createImplicitFeatureCallAndLocalVariableScope(EObject context, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IFeatureScopeSession nextCaptureLayer = session.getNextCaptureLayer();
        if (nextCaptureLayer != null) {
            parent = this.createImplicitFeatureCallAndLocalVariableScope(context, parent, nextCaptureLayer, resolvedTypes);
        }
        IScope implicitReceivers = this.createImplicitFeatureCallScope(context, parent, session, resolvedTypes);
        IScope constructors = this.createConstructorDelegates(context, implicitReceivers, session, resolvedTypes);
        IScope localVariables = this.createLocalVariableScope(context, constructors, session, resolvedTypes);
        return localVariables;
    }

    protected boolean isDefiniteTypeLiteral(XFeatureCall featureCall) {
        return this.typeLiteralHelper.isDefiniteTypeLiteral(featureCall);
    }

    protected IScope createConstructorDelegates(EObject context, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription;
        if (session.isConstructorContext() && (thisDescription = session.getLocalElement(THIS)) != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            return this.createConstructorDelegateScope(context, type, parent, session);
        }
        return parent;
    }

    protected XAbstractFeatureCall asAbstractFeatureCall(EObject context) {
        return context instanceof XAbstractFeatureCall ? (XAbstractFeatureCall)context : null;
    }

    protected IScope createFeatureScopeForTypeRef(final XExpression receiver, final LightweightTypeReference featureDeclarator, final boolean implicit, final EObject featureCall, final IFeatureScopeSession session, final JvmIdentifiableElement receiverFeature, IScope parent, final boolean validStaticScope) {
        final Wrapper wrapper = Wrapper.wrap((Object)parent);
        this.synonymProvider.collectSynonymTypes(featureDeclarator, new SynonymTypesProvider.Acceptor(){
            int id = 100;

            @Override
            protected boolean accept(LightweightTypeReference synonymType, int flags) {
                List<JvmType> rawTypes = synonymType.getRawTypes();
                ConformanceFlags.sanityCheck(flags);
                SynonymTypeBucket bucket = new SynonymTypeBucket(this.id++, rawTypes, FeatureScopes.this.resolvedFeaturesProvider, flags);
                CompoundTypeReference compoundTypeReference = synonymType.getOwner().newCompoundTypeReference(true);
                compoundTypeReference.addComponent(featureDeclarator);
                compoundTypeReference.addComponent(synonymType);
                wrapper.set((Object)FeatureScopes.this.createReceiverFeatureScope(featureCall, receiver, compoundTypeReference, receiverFeature, implicit, validStaticScope, bucket, (IScope)wrapper.get(), session));
                return true;
            }
        });
        if (featureDeclarator.isMultiType()) {
            List<LightweightTypeReference> components = featureDeclarator.getMultiTypeComponents();
            IScope result = (IScope)wrapper.get();
            int i = components.size() - 1;
            while (i >= 0) {
                LightweightTypeReference component = components.get(i);
                List<JvmType> rawTypes = component.getRawTypes();
                TypeBucket typeBucket = new TypeBucket(-1 - i, rawTypes, this.resolvedFeaturesProvider);
                result = this.createReceiverFeatureScope(featureCall, receiver, featureDeclarator, receiverFeature, implicit, validStaticScope, typeBucket, result, session);
                --i;
            }
            return result;
        }
        List<JvmType> rawTypes = featureDeclarator.getRawTypes();
        TypeBucket typeBucket = new TypeBucket(-1, rawTypes, this.resolvedFeaturesProvider);
        IScope result = this.createReceiverFeatureScope(featureCall, receiver, featureDeclarator, receiverFeature, implicit, validStaticScope, typeBucket, (IScope)wrapper.get(), session);
        return result;
    }

    public IScope createFeatureCallScopeForReceiver(XExpression featureCall, XExpression receiver, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (receiver == null || receiver.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        LightweightTypeReference receiverType = resolvedTypes.getActualType(receiver);
        if (receiverType != null && !this.isUnknownReceiverType(receiverType)) {
            JvmIdentifiableElement linkedReceiver = resolvedTypes.getLinkedFeature(this.asAbstractFeatureCall(receiver));
            boolean typeLiteral = false;
            IScope root = this.createTypeLiteralScope(featureCall, receiver, session, resolvedTypes, receiverType, linkedReceiver);
            if (root != null) {
                if (featureCall instanceof XMemberFeatureCall && ((XMemberFeatureCall)featureCall).isExplicitStatic()) {
                    return root;
                }
                typeLiteral = true;
            } else {
                root = IScope.NULLSCOPE;
            }
            if (typeLiteral || this.isValidFeatureCallArgument(receiver, linkedReceiver, session)) {
                IScope staticScope = this.createStaticScope(this.asAbstractFeatureCall(featureCall), receiver, receiverType, root, session, resolvedTypes);
                IScope staticExtensionScope = this.createStaticExtensionsScope(receiver, receiverType, featureCall, staticScope, session, resolvedTypes);
                IScope extensionScope = this.createDynamicExtensionsScope(receiver, receiverType, featureCall, staticExtensionScope, session, resolvedTypes);
                return this.createFeatureScopeForTypeRef(receiver, receiverType, false, featureCall, session, linkedReceiver, extensionScope, true);
            }
            return this.createFeatureScopeForTypeRef(receiver, receiverType, false, featureCall, session, linkedReceiver, IScope.NULLSCOPE, true);
        }
        if (this.typeLiteralHelper.isPotentialTypeLiteral(featureCall, resolvedTypes)) {
            IScope errorScope = this.createFollowUpErrorScope(receiverType);
            List<String> prefix = this.typeLiteralHelper.getTypeNameSegmentsFromConcreteSyntax((XMemberFeatureCall)featureCall);
            if (prefix == null) {
                return errorScope;
            }
            return this.createTypeLiteralScope(featureCall, QualifiedName.create(prefix), errorScope, session, resolvedTypes);
        }
        return this.createFollowUpErrorScope(receiverType);
    }

    protected IScope createTypeLiteralScope(XExpression featureCall, XExpression receiver, IFeatureScopeSession session, IResolvedTypes resolvedTypes, LightweightTypeReference receiverType, JvmIdentifiableElement linkedReceiver) {
        IFeatureLinkingCandidate candidate;
        if (linkedReceiver instanceof JvmDeclaredType && (candidate = resolvedTypes.getLinkingCandidate(this.asAbstractFeatureCall(receiver))) != null && candidate.isTypeLiteral()) {
            JvmDeclaredType declaringType = (JvmDeclaredType)linkedReceiver;
            IScope result = this.createNestedTypeLiteralScope(featureCall, receiverType, declaringType, IScope.NULLSCOPE, session);
            result = this.createStaticFeatureOnTypeLiteralScope(this.asAbstractFeatureCall(featureCall), (JvmType)declaringType, receiver, receiverType, result, session);
            return result;
        }
        return null;
    }

    protected boolean isUnknownReceiverType(LightweightTypeReference receiverType) {
        if (receiverType.isUnknown()) {
            return true;
        }
        if (receiverType instanceof UnboundTypeReference) {
            List<LightweightBoundTypeArgument> hints = ((UnboundTypeReference)receiverType).getAllHints();
            for (LightweightBoundTypeArgument hint : hints) {
                LightweightTypeReference typeReference = hint.getTypeReference();
                if (typeReference == null || !typeReference.isUnknown()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidFeatureCallArgument(XExpression expression, JvmIdentifiableElement linkedReceiver, IFeatureScopeSession session) {
        IEObjectDescription knownSuperType;
        if (linkedReceiver instanceof JvmType && (knownSuperType = session.getLocalElement(SUPER)) != null && linkedReceiver == knownSuperType.getEObjectOrProxy()) {
            return false;
        }
        return !(expression instanceof XAbstractFeatureCall) || linkedReceiver != null && !linkedReceiver.eIsProxy();
    }

    protected IScope createStaticExtensionsScope(XExpression receiver, LightweightTypeReference receiverType, EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IFeatureScopeSession nextCaptureLayer = session.getNextCaptureLayer();
        if (nextCaptureLayer != null) {
            parent = this.createStaticExtensionsScope(receiver, receiverType, featureCall, parent, nextCaptureLayer, resolvedTypes);
        }
        IScope result = parent;
        if (receiver == null) {
            result = this.createImplicitExtensionScope(THIS, featureCall, session, resolvedTypes, result);
            result = this.createImplicitExtensionScope(IT, featureCall, session, resolvedTypes, result);
            return result;
        }
        if (receiverType == null) {
            throw new IllegalStateException("Unknown receiver type");
        }
        result = this.createStaticExtensionsScope(featureCall, receiver, receiverType, false, parent, session);
        return result;
    }

    protected IScope createStaticScope(XAbstractFeatureCall featureCall, XExpression receiver, LightweightTypeReference receiverType, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IScope result = parent;
        if (receiver == null) {
            result = this.createImplicitStaticScope(THIS, featureCall, session, resolvedTypes, result);
            result = this.createImplicitStaticScope(IT, featureCall, session, resolvedTypes, result);
            return result;
        }
        TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(receiverType.getType()), this.resolvedFeaturesProvider);
        return this.createStaticFeatureScope(featureCall, receiver, receiverType, receiverBucket, parent, session);
    }

    protected IScope createStaticFeatureOnTypeLiteralScope(XAbstractFeatureCall featureCall, JvmType type, XExpression receiver, LightweightTypeReference receiverType, IScope parent, IFeatureScopeSession session) {
        TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(type), this.resolvedFeaturesProvider);
        return this.createStaticFeatureOnTypeLiteralScope((EObject)featureCall, receiver, receiverType, receiverBucket, parent, session);
    }

    protected IScope createDynamicExtensionsScope(XExpression firstArgument, LightweightTypeReference firstArgumentType, EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        return this.createDynamicExtensionsScope(firstArgument, firstArgumentType, featureCall, parent, session, session, resolvedTypes);
    }

    protected IScope createDynamicExtensionsScope(XExpression firstArgument, LightweightTypeReference firstArgumentType, EObject featureCall, IScope parent, IFeatureScopeSession captureLayer, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        List<ExpressionBucket> extensionProviders;
        IFeatureScopeSession nextCaptureLayer = captureLayer.getNextCaptureLayer();
        if (nextCaptureLayer != null) {
            parent = this.createDynamicExtensionsScope(firstArgument, firstArgumentType, featureCall, parent, nextCaptureLayer, session, resolvedTypes);
        }
        if ((extensionProviders = captureLayer.getExtensionProviders()).isEmpty()) {
            return parent;
        }
        IScope result = parent;
        if (firstArgument == null) {
            result = this.createDynamicExtensionsScope(THIS, featureCall, captureLayer, session, resolvedTypes, result, true);
            result = this.createDynamicExtensionsScope(IT, featureCall, captureLayer, session, resolvedTypes, result, false);
            return result;
        }
        result = this.createDynamicExtensionsScope(featureCall, firstArgument, firstArgumentType, false, parent, captureLayer);
        return result;
    }

    protected IScope createDynamicExtensionsScope(QualifiedName implicitFirstArgumentName, EObject featureCall, IFeatureScopeSession captureLayer, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent, boolean all) {
        if (all) {
            List<IEObjectDescription> firstArguments = this.getDeepLocalElements(session, implicitFirstArgumentName);
            switch (firstArguments.size()) {
                case 0: {
                    return this.createDynamicExtensionsScope(featureCall, null, null, true, parent, captureLayer);
                }
                case 1: {
                    return this.createDynamicExtensionsScope(implicitFirstArgumentName, firstArguments.get(0), featureCall, captureLayer, session, resolvedTypes, parent);
                }
            }
            CompositeScope result = this.createCompositeScope(featureCall, parent, session);
            for (IEObjectDescription firstArgumentDescription : firstArguments) {
                IScope extensionsScope = this.createDynamicExtensionsScope(implicitFirstArgumentName, firstArgumentDescription, featureCall, captureLayer, session, resolvedTypes, IScope.NULLSCOPE);
                if (IScope.NULLSCOPE == extensionsScope) continue;
                result.addDelegate((AbstractSessionBasedScope)extensionsScope);
            }
            if (result.hasDelegates()) {
                return result;
            }
            return parent;
        }
        IEObjectDescription firstArgumentDescription = this.getDeepLocalElement(session, implicitFirstArgumentName);
        if (firstArgumentDescription != null) {
            return this.createDynamicExtensionsScope(implicitFirstArgumentName, firstArgumentDescription, featureCall, captureLayer, session, resolvedTypes, parent);
        }
        return this.createDynamicExtensionsScope(featureCall, null, null, true, parent, captureLayer);
    }

    protected IEObjectDescription getDeepLocalElement(IFeatureScopeSession session, QualifiedName name) {
        while (session != null) {
            IEObjectDescription element = session.getLocalElement(name);
            if (element != null) {
                return element;
            }
            session = session.getNextCaptureLayer();
        }
        return null;
    }

    protected List<IEObjectDescription> getDeepLocalElements(IFeatureScopeSession session, QualifiedName name) {
        ArrayList result = Lists.newArrayList();
        while (session != null) {
            IEObjectDescription element = session.getLocalElement(name);
            if (element != null) {
                result.add(element);
            }
            session = session.getNextCaptureLayer();
        }
        return result;
    }

    protected IScope createDynamicExtensionsScope(QualifiedName implicitFirstArgumentName, IEObjectDescription firstArgumentDescription, EObject featureCall, IFeatureScopeSession captureLayer, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement feature = (JvmIdentifiableElement)firstArgumentDescription.getEObjectOrProxy();
        if (feature instanceof JvmType && THIS.equals((Object)implicitFirstArgumentName) && !session.isInstanceContext()) {
            return parent;
        }
        LightweightTypeReference type = resolvedTypes.getActualType(feature);
        if (type != null && !type.isUnknown()) {
            XFeatureCall implicitArgument = this.xbaseFactory.createXFeatureCall();
            implicitArgument.setFeature(feature);
            return this.createDynamicExtensionsScope(featureCall, implicitArgument, type, true, parent, captureLayer);
        }
        return parent;
    }

    protected XExpression getSyntacticalReceiver(XAbstractFeatureCall call) {
        return new FeatureLinkHelper().getSyntacticReceiver(call);
    }

    protected IScope createImplicitFeatureCallScope(EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IScope result = parent;
        result = this.createImplicitFeatureCallScope(THIS, featureCall, session, resolvedTypes, result);
        result = this.createImplicitFeatureCallScope(IT, featureCall, session, resolvedTypes, result);
        return result;
    }

    protected IScope createImplicitFeatureCallScope(QualifiedName implicitName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null) {
            LightweightTypeReference type;
            JvmIdentifiableElement thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy();
            boolean validStaticScope = true;
            if (thisElement instanceof JvmType && THIS.equals((Object)implicitName) && !session.isInstanceContext()) {
                validStaticScope = false;
            }
            if ((type = resolvedTypes.getActualType(thisElement)) != null && !type.isUnknown()) {
                XFeatureCall implicitReceiver = this.xbaseFactory.createXFeatureCall();
                implicitReceiver.setFeature(thisElement);
                return this.createFeatureScopeForTypeRef(implicitReceiver, type, true, featureCall, session, thisElement, parent, validStaticScope);
            }
        }
        return parent;
    }

    protected IScope createImplicitExtensionScope(QualifiedName implicitName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            XFeatureCall implicitReceiver = this.xbaseFactory.createXFeatureCall();
            implicitReceiver.setFeature(thisElement);
            return this.createStaticExtensionsScope(featureCall, implicitReceiver, type, true, parent, session);
        }
        return parent;
    }

    protected IScope createImplicitStaticScope(QualifiedName implicitName, XAbstractFeatureCall featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        JvmIdentifiableElement thisElement;
        LightweightTypeReference type;
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null && (type = resolvedTypes.getActualType(thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy())) != null && !type.isUnknown()) {
            TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(type.getType()), this.resolvedFeaturesProvider);
            return this.createStaticFeatureScope(featureCall, null, type, receiverBucket, parent, session);
        }
        return parent;
    }

    protected IScope createStaticFeatureScope(XAbstractFeatureCall featureCall, XExpression receiver, LightweightTypeReference receiverType, TypeBucket receiverBucket, IScope parent, IFeatureScopeSession session) {
        return new StaticFeatureScope(parent, session, featureCall, receiver, receiverType, receiverBucket, this.operatorMapping);
    }

    protected IScope createStaticFeatureOnTypeLiteralScope(EObject featureCall, XExpression receiver, LightweightTypeReference receiverType, TypeBucket receiverBucket, IScope parent, IFeatureScopeSession session) {
        return new StaticFeatureOnTypeLiteralScope(parent, session, this.asAbstractFeatureCall(featureCall), receiver, receiverType, receiverBucket, this.operatorMapping);
    }

    protected IScope createDynamicExtensionsScope(EObject featureCall, XExpression firstArgument, LightweightTypeReference firstArgumentType, boolean implicitArgument, IScope parent, IFeatureScopeSession session) {
        return new DynamicExtensionsScope(parent, session, firstArgument, firstArgumentType, implicitArgument, this.asAbstractFeatureCall(featureCall), this.operatorMapping);
    }

    protected IScope createStaticExtensionsScope(EObject featureCall, XExpression firstArgument, LightweightTypeReference firstArgumentType, boolean implicitArgument, IScope parent, IFeatureScopeSession session) {
        return new StaticExtensionImportsScope(parent, session, firstArgument, firstArgumentType, implicitArgument, this.asAbstractFeatureCall(featureCall), this.operatorMapping);
    }

    protected IScope createTypeLiteralScope(EObject featureCall, QualifiedName parentSegments, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        return new TypeLiteralScope(parent, session, this.asAbstractFeatureCall(featureCall), resolvedTypes, parentSegments);
    }

    protected IScope createNestedTypeLiteralScope(EObject featureCall, LightweightTypeReference enclosingType, JvmDeclaredType rawEnclosingType, IScope parent, IFeatureScopeSession session) {
        return new NestedTypeLiteralScope(parent, session, this.asAbstractFeatureCall(featureCall), enclosingType, (JvmType)rawEnclosingType);
    }

    protected IScope createStaticFeaturesScope(EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new StaticImportsScope(parent, session, this.asAbstractFeatureCall(featureCall));
    }

    protected IScope createLocalVariableScope(EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        return new LocalVariableScope(parent, session, this.asAbstractFeatureCall(featureCall));
    }

    protected IScope createConstructorDelegateScope(EObject featureCall, LightweightTypeReference type, IScope parent, IFeatureScopeSession session) {
        return new ConstructorDelegateScope(parent, type, session, this.asAbstractFeatureCall(featureCall));
    }

    protected CompositeScope createCompositeScope(EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new CompositeScope(parent, session, this.asAbstractFeatureCall(featureCall));
    }

    protected IScope createReceiverFeatureScope(EObject featureCall, XExpression receiver, LightweightTypeReference receiverType, JvmIdentifiableElement receiverFeature, boolean implicitReceiver, boolean validStatic, TypeBucket receiverBucket, IScope parent, IFeatureScopeSession session) {
        return new ReceiverFeatureScope(parent, session, receiver, receiverType, implicitReceiver, this.asAbstractFeatureCall(featureCall), receiverBucket, receiverFeature, this.operatorMapping, validStatic);
    }

    protected IScope createFollowUpErrorScope(final LightweightTypeReference receiverType) {
        return new SimpleScope(Collections.emptyList()){

            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                return Collections.singletonList(new ScopeProviderAccess.ErrorDescription(receiverType));
            }
        };
    }

    protected OperatorMapping getOperatorMapping() {
        return this.operatorMapping;
    }

    protected IResolvedFeatures.Provider getResolvedFeaturesProvider() {
        return this.resolvedFeaturesProvider;
    }

    protected SynonymTypesProvider getSynonymProvider() {
        return this.synonymProvider;
    }

    protected FeatureCallAsTypeLiteralHelper getTypeLiteralHelper() {
        return this.typeLiteralHelper;
    }

    protected XbaseFactory getXbaseFactory() {
        return this.xbaseFactory;
    }
}

