/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.annotations.Beta;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.FileSystemAccessRequest;

public class FileSystemAccessQueue
extends AdapterImpl {
    private final BlockingQueue<FileSystemAccessRequest> requestQueue;
    private final IProgressMonitor monitor;

    public FileSystemAccessQueue(BlockingQueue<FileSystemAccessRequest> requestQueue, IProgressMonitor monitor) {
        this.requestQueue = requestQueue;
        this.monitor = monitor;
    }

    public void sendAsync(URI uri, Runnable runMe) {
        this.send(new FileSystemAccessRequest(uri, runMe));
    }

    protected FileSystemAccessRequest send(FileSystemAccessRequest request) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            this.requestQueue.put(request);
            return request;
        }
        catch (InterruptedException t) {
            throw new OperationCanceledException();
        }
    }

    @Beta
    public void waitForEmptyQueue() {
        while (!this.requestQueue.isEmpty()) {
            Thread.yield();
        }
    }
}

