/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;

@ImplementedBy(value=RuleBasedNameValidator.class)
public interface IRenameNameValidator {
    public void validate(EObject var1, String var2, RefactoringIssueAcceptor var3);

    public static class RuleBasedNameValidator
    implements IRenameNameValidator {
        @Inject
        private IValueConverterService valueConverterService;

        @Override
        public void validate(EObject target, String newName, RefactoringIssueAcceptor issues) {
            try {
                this.getNameAsValue(newName);
            }
            catch (ValueConverterException e) {
                issues.add(RefactoringIssueAcceptor.Severity.FATAL, "Illegal name: " + e.getMessage(), new Object[0]);
            }
        }

        protected String getNameAsText(String nameAsValue) {
            return this.valueConverterService.toString((Object)nameAsValue, this.getRuleName());
        }

        protected String getNameAsValue(String nameAsText) {
            return this.valueConverterService.toValue(nameAsText, this.getRuleName(), null).toString();
        }

        protected String getRuleName() {
            return "ID";
        }
    }
}

