/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.xtext.xbase.interpreter.impl.AbstractClosureInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingInvocationHandler
extends AbstractClosureInvocationHandler {
    private final Object receiver;
    private Method method;

    public DelegatingInvocationHandler(Object receiver, Class<?> interfaceType) {
        this.receiver = receiver;
        this.method = this.findMethod(interfaceType);
    }

    protected Method findMethod(Class<?> interfaceType) {
        Method[] methodArray = interfaceType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if ("apply".equals(m.getName())) {
                return m;
            }
            ++n2;
        }
        throw new IllegalStateException("receiver does not expose a method 'apply'");
    }

    @Override
    protected Object doInvoke(Method method, Object[] args) throws Throwable {
        try {
            return this.method.invoke(this.receiver, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new DelegationFailedException(e);
        }
    }

    public static class DelegationFailedException
    extends UndeclaredThrowableException {
        private static final long serialVersionUID = 1L;

        public DelegationFailedException(Throwable undeclaredThrowable) {
            super(undeclaredThrowable);
        }
    }
}

