/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat;

import com.google.inject.Inject;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.packrat.IParseResultFactory;
import org.eclipse.xtext.parser.packrat.debug.DebugUtil;
import org.eclipse.xtext.parser.packrat.debug.ParsedTokenPrinter;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedToken;
import org.eclipse.xtext.parser.packrat.tokens.AbstractParsedTokenVisitor;
import org.eclipse.xtext.parser.packrat.tokens.CompoundParsedTokenVisitor;
import org.eclipse.xtext.parser.packrat.tokens.ErrorToken;
import org.eclipse.xtext.parser.packrat.tokens.FakedToken;
import org.eclipse.xtext.parser.packrat.tokens.ParsedAction;
import org.eclipse.xtext.parser.packrat.tokens.ParsedEnumLiteral;
import org.eclipse.xtext.parser.packrat.tokens.ParsedNonTerminal;
import org.eclipse.xtext.parser.packrat.tokens.ParsedNonTerminalEnd;
import org.eclipse.xtext.parser.packrat.tokens.ParsedTerminal;
import org.eclipse.xtext.parser.packrat.tokens.ParsedTerminalWithFeature;
import org.eclipse.xtext.parser.packrat.tokens.ParsedTerminalWithFeatureInfo;
import org.eclipse.xtext.parser.packrat.tokens.ParsedToken;

public class ParseResultFactory
extends AbstractParsedTokenVisitor
implements IParseResultFactory {
    private final LinkedList<EObject> currentStack = new LinkedList();
    @Inject
    private IAstFactory factory;
    private final LinkedList<ParsedNonTerminal> nonterminalStack = new LinkedList();

    public IParseResult createParseResult(AbstractParsedToken token, CharSequence input) {
        this.currentStack.clear();
        this.nonterminalStack.clear();
        if (DebugUtil.PARSE_RESULT_FACTORY_DEBUG) {
            CompoundParsedTokenVisitor visitor = new CompoundParsedTokenVisitor(new ParsedTokenPrinter(), this);
            token.accept(visitor);
        } else {
            token.accept(this);
        }
        throw new UnsupportedOperationException();
    }

    public void visitAbstractParsedToken(AbstractParsedToken token) {
    }

    public void visitErrorToken(ErrorToken token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitFakedToken(FakedToken token) {
        if (token.isSkipped()) {
            return;
        }
        super.visitFakedToken(token);
    }

    public void visitParsedNonTerminal(ParsedNonTerminal token) {
        if (token.isSkipped()) {
            return;
        }
        this.nonterminalStack.add(token);
        this.currentStack.add(null);
    }

    public void visitParsedNonTerminalEnd(ParsedNonTerminalEnd token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitParsedEnumLiteral(ParsedEnumLiteral token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitParsedTerminal(ParsedTerminal token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitParsedTerminalWithFeatureInfo(ParsedTerminalWithFeatureInfo token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitParsedTerminalWithFeature(ParsedTerminalWithFeature token) {
        if (token.isSkipped()) {
            return;
        }
    }

    public void visitParsedAction(ParsedAction token) {
        if (token.isSkipped()) {
            return;
        }
        EObject newCurrent = this.factory.create(token.getType());
        EObject prevCurrent = this.currentStack.removeLast();
        this.currentStack.add(newCurrent);
        if (token.getFeature() != null) {
            try {
                if (token.isMany()) {
                    this.factory.add(newCurrent, token.getFeature(), prevCurrent, null, null);
                }
                this.factory.set(newCurrent, token.getFeature(), prevCurrent, null, null);
            }
            catch (ValueConverterException valueConverterException) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else if (prevCurrent != null) {
            throw new IllegalStateException("Cannot throw away created current.");
        }
    }

    public void visitParsedToken(ParsedToken token) {
        if (token.isSkipped()) {
            return;
        }
        super.visitParsedToken(token);
    }

    public void setFactory(IAstFactory factory) {
        this.factory = factory;
    }

    public IAstFactory getFactory() {
        return this.factory;
    }
}

