/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TypeReferences {
    private static final Logger log = Logger.getLogger(TypeReferences.class);
    @Inject
    private TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private ClassURIHelper uriHelper;
    @Inject
    private SuperTypeCollector superTypeCollector;

    public JvmAnyTypeReference createAnyTypeReference(Notifier context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        JvmAnyTypeReference result = this.factory.createJvmAnyTypeReference();
        JvmType objectType = this.findDeclaredType(Object.class, context);
        if (objectType == null) {
            return null;
        }
        result.setType(objectType);
        return result;
    }

    public JvmMultiTypeReference createMultiTypeReference(Notifier context, JvmTypeReference ... references) {
        JvmType findDeclaredType;
        if (context == null) {
            throw new NullPointerException("context");
        }
        JvmMultiTypeReference result = this.factory.createJvmMultiTypeReference();
        if (references != null && references.length != 0) {
            JvmTypeReference[] jvmTypeReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                JvmTypeReference reference = jvmTypeReferenceArray[n2];
                result.getReferences().add((Object)this.createDelegateTypeReference(reference));
                ++n2;
            }
        }
        if ((findDeclaredType = this.findDeclaredType(Object.class, context)) == null) {
            return null;
        }
        result.setType(findDeclaredType);
        return result;
    }

    public JvmParameterizedTypeReference createTypeRef(JvmType type, JvmTypeReference ... typeArgs) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        ArrayList typeReferences = Collections.emptyList();
        if (typeArgs != null && typeArgs.length > 0) {
            typeReferences = Lists.newArrayListWithCapacity((int)typeArgs.length);
            int i = 0;
            while (i < typeArgs.length) {
                JvmTypeReference jvmTypeReference = typeArgs[i];
                typeReferences.add((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)jvmTypeReference));
                ++i;
            }
        }
        if (type instanceof JvmGenericType) {
            EList list = ((JvmGenericType)type).getTypeParameters();
            if (!typeReferences.isEmpty() && list.size() != typeReferences.size()) {
                throw new IllegalArgumentException("The type " + type.getIdentifier() + " expects " + list.size() + " type arguments, but was " + typeReferences.size() + ". Either pass zero arguments (raw type) or the correct number.");
            }
            if (typeReferences.isEmpty() && !list.isEmpty()) {
                typeReferences = Lists.newArrayListWithCapacity((int)list.size());
                for (JvmTypeParameter typeParameter : list) {
                    typeReferences.add(this.createTypeRef(typeParameter, new JvmTypeReference[0]));
                }
            }
        }
        JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
        reference.setType(type);
        if (!typeReferences.isEmpty()) {
            reference.getArguments().addAll((Collection)typeReferences);
        }
        return reference;
    }

    public JvmDelegateTypeReference createDelegateTypeReference(JvmTypeReference typeRef) {
        JvmDelegateTypeReference delegate = this.factory.createJvmDelegateTypeReference();
        delegate.setDelegate(typeRef);
        return delegate;
    }

    public JvmTypeReference getArgument(JvmTypeReference left, int index) {
        if (left.getType() instanceof JvmGenericType) {
            EList<JvmTypeReference> arguments;
            EList typeParameters = ((JvmGenericType)left.getType()).getTypeParameters();
            if (typeParameters.size() <= index) {
                throw new IllegalArgumentException("The type " + left.getType().getIdentifier() + " cannot be parameterized with more than " + typeParameters.size() + " type arguments.");
            }
            if (left instanceof JvmParameterizedTypeReference && (arguments = ((JvmParameterizedTypeReference)left).getArguments()).size() == typeParameters.size()) {
                return (JvmTypeReference)arguments.get(index);
            }
            JvmTypeParameter jvmTypeParameter = (JvmTypeParameter)typeParameters.get(index);
            return this.createTypeRef(jvmTypeParameter, new JvmTypeReference[0]);
        }
        throw new IllegalArgumentException(String.valueOf(left.getType().getIdentifier()) + " is not generic.");
    }

    public JvmWildcardTypeReference wildCard() {
        JvmWildcardTypeReference result = this.factory.createJvmWildcardTypeReference();
        return result;
    }

    public JvmWildcardTypeReference wildCardExtends(JvmTypeReference clone) {
        JvmWildcardTypeReference result = this.factory.createJvmWildcardTypeReference();
        JvmUpperBound upperBound = this.factory.createJvmUpperBound();
        upperBound.setTypeReference(clone);
        result.getConstraints().add((Object)upperBound);
        return result;
    }

    protected URI toCommonTypesUri(Class<?> clazz) {
        URI result = this.uriHelper.getFullURI(clazz);
        return result;
    }

    public JvmTypeReference getTypeForName(Class<?> clazz, Notifier context, JvmTypeReference ... params) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        JvmType declaredType = this.findDeclaredType(clazz, context);
        if (declaredType == null) {
            return this.getUnknownTypeReference(clazz.getName());
        }
        JvmParameterizedTypeReference result = this.createTypeRef(declaredType, params);
        return result;
    }

    protected JvmUnknownTypeReference getUnknownTypeReference(String qualifiedName) {
        JvmUnknownTypeReference reference = TypesFactory.eINSTANCE.createJvmUnknownTypeReference();
        reference.setQualifiedName(qualifiedName);
        return reference;
    }

    public JvmTypeReference getTypeForName(String typeName, Notifier context, JvmTypeReference ... params) {
        if (typeName == null) {
            throw new NullPointerException("typeName");
        }
        JvmType declaredType = this.findDeclaredType(typeName, context);
        if (declaredType == null) {
            return this.getUnknownTypeReference(typeName);
        }
        JvmParameterizedTypeReference result = this.createTypeRef(declaredType, params);
        return result;
    }

    public JvmGenericArrayTypeReference createArrayType(JvmTypeReference componentType) {
        JvmGenericArrayTypeReference result = this.factory.createJvmGenericArrayTypeReference();
        result.setComponentType((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)componentType));
        return result;
    }

    public JvmType findDeclaredType(Class<?> clazz, Notifier context) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        JvmType declaredType = this.findDeclaredType(clazz.getName(), context);
        return declaredType;
    }

    public JvmType findDeclaredType(String typeName, Notifier context) {
        if (typeName == null) {
            throw new NullPointerException("typeName");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet == null) {
            return null;
        }
        IJvmTypeProvider typeProvider = this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        try {
            JvmType result = typeProvider.findTypeByName(typeName);
            return result;
        }
        catch (RuntimeException e) {
            log.info((Object)("Couldn't find JvmType for name '" + typeName + "' in context " + context), (Throwable)e);
            return null;
        }
    }

    public boolean is(JvmTypeReference reference, Class<?> clazz) {
        if (this.isNullOrProxy(reference)) {
            return false;
        }
        boolean result = this.is(reference.getType(), clazz);
        return result;
    }

    public boolean is(JvmType type, Class<?> clazz) {
        if (type == null) {
            return false;
        }
        String className = clazz.getName();
        if (className.charAt(0) == '[') {
            className = clazz.getCanonicalName();
        }
        boolean result = className.equals(type.getIdentifier());
        return result;
    }

    public boolean isNullOrProxy(JvmTypeReference reference) {
        return reference == null || reference.getType() == null || reference.getType().eIsProxy();
    }

    public boolean isInstanceOf(JvmTypeReference reference, Class<?> clazz) {
        if (this.isNullOrProxy(reference)) {
            return false;
        }
        if (this.is(reference, clazz)) {
            return true;
        }
        Set<JvmTypeReference> types = this.superTypeCollector.collectSuperTypes(reference);
        for (JvmTypeReference jvmTypeReference : types) {
            if (!this.is(jvmTypeReference, clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isArray(JvmTypeReference type) {
        if (this.isNullOrProxy(type)) {
            return false;
        }
        return type instanceof JvmGenericArrayTypeReference || type.getType() instanceof JvmArrayType;
    }
}

