/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.codebuilder.ICodeBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaConstructorBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaFieldBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaMethodBuilder;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.xtext.ui.JdtHyperlink;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;

public class CodeBuilderQuickfix {
    @Inject
    private IURIEditorOpener editorOpener;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;

    public void addQuickfix(ICodeBuilder builder, String label, Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _isValid = builder.isValid();
        if (_isValid) {
            IModification _switchResult = null;
            boolean _matched = false;
            if (builder instanceof ICodeBuilder.Xtend) {
                _matched = true;
                _switchResult = this.getXtendModification((ICodeBuilder.Xtend)builder);
            }
            if (!_matched && builder instanceof ICodeBuilder.Java) {
                _matched = true;
                _switchResult = this.getJavaModification((ICodeBuilder.Java)builder);
            }
            IModification modification = _switchResult;
            acceptor.accept(issue, label, builder.getPreview(), builder.getImage(), modification);
        }
    }

    protected String getImage(ICodeBuilder builder) {
        String _switchResult = null;
        JvmVisibility _visibility = builder.getVisibility();
        if (_visibility != null) {
            switch (_visibility) {
                case PRIVATE: {
                    _switchResult = "fix_private_obj.gif";
                    break;
                }
                case PUBLIC: {
                    _switchResult = "fix_public_obj.gif";
                    break;
                }
                case PROTECTED: {
                    _switchResult = "fix_protected_obj.gif";
                    break;
                }
                default: {
                    _switchResult = "fix_default_obj.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fix_default_obj.gif";
        }
        return _switchResult;
    }

    protected boolean isXtendSource(ICodeBuilder builder) {
        Object _ownerSource = builder.getOwnerSource();
        return _ownerSource instanceof XtendClass;
    }

    protected int getTypeIndentation(XtextResource resource, IXtextDocument document, XtendTypeDeclaration xtendClass) {
        ICompositeNode node;
        EObject object = resource.getEObject(EcoreUtil.getURI((EObject)xtendClass).fragment());
        if (object != null && (node = NodeModelUtils.findActualNodeFor((EObject)object)) != null) {
            return this.appendableFactory.getIndentationLevelAtOffset(node.getOffset(), (IDocument)document, resource);
        }
        return 0;
    }

    protected IModification getXtendModification(ICodeBuilder.Xtend builder) {
        IModification _function = it -> {
            XtendTypeDeclaration xtendClass = builder.getXtendType();
            IEditorPart editor = this.editorOpener.open(EcoreUtil.getURI((EObject)xtendClass), false);
            if (!(editor instanceof XtextEditor)) {
                return;
            }
            XtextEditor xtextEditor = (XtextEditor)editor;
            IXtextDocument document = xtextEditor.getDocument();
            Wrapper wrapper = Wrapper.forType(Integer.class);
            IUnitOfWork _function_1 = resource -> {
                ReplacingAppendable _xblockexpression = null;
                int offset = builder.getInsertOffset((XtextResource)resource);
                wrapper.set((Object)offset);
                int typeIndentation = this.getTypeIndentation((XtextResource)resource, document, xtendClass);
                DocumentSourceAppender.Factory.OptionalParameters _optionalParameters = new DocumentSourceAppender.Factory.OptionalParameters();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    int _plus;
                    int _indentationLevel = builder.getIndentationLevel();
                    it_1.baseIndentationLevel = _plus = _indentationLevel + typeIndentation;
                    it_1.ensureEmptyLinesAround = true;
                };
                DocumentSourceAppender.Factory.OptionalParameters _doubleArrow = (DocumentSourceAppender.Factory.OptionalParameters)ObjectExtensions.operator_doubleArrow((Object)_optionalParameters, (Procedures.Procedure1)_function_2);
                _xblockexpression = (ReplacingAppendable)this.appendableFactory.create(document, resource, offset, 0, _doubleArrow);
                return _xblockexpression;
            };
            ReplacingAppendable appendable = (ReplacingAppendable)document.readOnly(_function_1);
            Integer offset = (Integer)wrapper.get();
            builder.build((ISourceAppender)appendable);
            appendable.commitChanges();
            xtextEditor.setHighlightRange(offset + 1, appendable.length(), true);
        };
        return _function;
    }

    protected IModification getJavaModification(ICodeBuilder.Java builder) {
        IModification _function = it -> {
            IField element;
            NullProgressMonitor _nullProgressMonitor;
            String _string;
            IType type = builder.getIType();
            char _charAt = ".".charAt(0);
            ImportManager importManager = new ImportManager(true, _charAt);
            StringBuilderBasedAppendable content = new StringBuilderBasedAppendable(importManager);
            builder.build((ISourceAppender)content);
            Consumer<String> _function_1 = it_1 -> {
                try {
                    ICompilationUnit _compilationUnit = type.getCompilationUnit();
                    NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                    _compilationUnit.createImport(it_1, null, (IProgressMonitor)_nullProgressMonitor);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            importManager.getImports().forEach(_function_1);
            IField _switchResult = null;
            boolean _matched = false;
            if (builder instanceof JavaFieldBuilder) {
                _matched = true;
                _string = content.toString();
                _nullProgressMonitor = new NullProgressMonitor();
                _switchResult = type.createField(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
            }
            if (!_matched && builder instanceof JavaConstructorBuilder) {
                _matched = true;
                _string = content.toString();
                _nullProgressMonitor = new NullProgressMonitor();
                _switchResult = type.createMethod(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
            }
            if (!_matched && builder instanceof JavaMethodBuilder) {
                _matched = true;
                _string = content.toString();
                _nullProgressMonitor = new NullProgressMonitor();
                _switchResult = type.createMethod(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
            }
            if (!_matched) {
                _switchResult = null;
            }
            if ((element = _switchResult) != null) {
                JdtHyperlink _jdtHyperlink = new JdtHyperlink();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    it_1.setJavaElement((IJavaElement)((IMember)element));
                    it_1.open();
                };
                ObjectExtensions.operator_doubleArrow((Object)_jdtHyperlink, (Procedures.Procedure1)_function_2);
            }
        };
        return _function;
    }
}

