/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.smap.CompilationParticipantExtension;
import org.eclipse.xtext.builder.smap.DerivedResourceMarkerCopier;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceAsPrimarySourceInstaller;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.smap.TraceAsSmapInstaller;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.generator.trace.AbstractEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.osgi.framework.Version;

public class DebugSourceInstallingCompilationParticipant
extends CompilationParticipant
implements CompilationParticipantExtension {
    private static final Logger log = Logger.getLogger(DebugSourceInstallingCompilationParticipant.class);
    private static final Version VERSION_3_34_0 = new Version(3, 34, 0);
    private static Version installedJdtCoreVersion;
    private List<BuildContext> files;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private Provider<TraceAsSmapInstaller> traceAsSmapInstaller;
    @Inject
    private Provider<TraceAsPrimarySourceInstaller> traceAsPrimarySourceInstallerProvider;
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private DerivedResourceMarkerCopier markerReflector;

    @Override
    public boolean isPostProcessor() {
        return true;
    }

    protected OutputConfiguration findOutputConfiguration(SourceRelativeURI dslSourceFile, IFile generatedJavaFile) {
        IProject project;
        IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(dslSourceFile.getURI());
        if (serviceProvider == null) {
            return null;
        }
        EclipseOutputConfigurationProvider cfgProvider = (EclipseOutputConfigurationProvider)((Object)serviceProvider.get(EclipseOutputConfigurationProvider.class));
        Set<OutputConfiguration> configurations = cfgProvider.getOutputConfigurations(project = generatedJavaFile.getProject());
        if (!configurations.isEmpty()) {
            if (configurations.size() == 1) {
                return configurations.iterator().next();
            }
            for (OutputConfiguration out : configurations) {
                for (String source : out.getSourceFolders()) {
                    IContainer container = ResourceUtil.getContainer((IProject)project, (String)out.getOutputDirectory(source));
                    if (container == null || !container.getFullPath().isPrefixOf(generatedJavaFile.getFullPath())) continue;
                    return out;
                }
            }
        }
        log.error((Object)("Could not find output configuration for file " + String.valueOf(generatedJavaFile.getFullPath())));
        return null;
    }

    protected ITraceToBytecodeInstaller getInstaller(OutputConfiguration config) {
        if (config.isInstallDslAsPrimarySource()) {
            TraceAsPrimarySourceInstaller installer = (TraceAsPrimarySourceInstaller)this.traceAsPrimarySourceInstallerProvider.get();
            installer.setHideSyntheticVariables(config.isHideSyntheticLocalVariables());
            return installer;
        }
        TraceAsSmapInstaller installer = (TraceAsSmapInstaller)this.traceAsSmapInstaller.get();
        return installer;
    }

    @Override
    public Optional<byte[]> postProcess(BuildContext ctx, ByteArrayInputStream bytes) {
        Optional<byte[]> no_change = Optional.empty();
        if (!DebugSourceInstallingCompilationParticipant.isJdtCoreGreaterOrEqual(VERSION_3_34_0)) {
            return no_change;
        }
        try {
            IFile generatedJavaFile = ctx.getFile();
            IEclipseTrace traceToSource = (IEclipseTrace)this.traceInformation.getTraceToSource((Object)generatedJavaFile);
            if (traceToSource == null) {
                return no_change;
            }
            AbstractTraceRegion rootTraceRegion = this.findRootTraceRegion((ITrace)traceToSource);
            if (rootTraceRegion == null) {
                return no_change;
            }
            SourceRelativeURI dslSourceFile = rootTraceRegion.getAssociatedSrcRelativePath();
            OutputConfiguration outputConfiguration = this.findOutputConfiguration(dslSourceFile, generatedJavaFile);
            if (outputConfiguration == null) {
                return no_change;
            }
            IJavaElement element = JavaCore.create((IFile)generatedJavaFile);
            if (element == null) {
                return no_change;
            }
            this.deleteTaskMarkers(generatedJavaFile);
            this.markerReflector.reflectErrorMarkerInSource(generatedJavaFile, traceToSource);
            ITraceToBytecodeInstaller installer = this.getInstaller(outputConfiguration);
            installer.setTrace(generatedJavaFile.getName(), rootTraceRegion);
            byte[] byteCode = installer.installTrace(ByteStreams.toByteArray((InputStream)bytes));
            if (byteCode != null) {
                return Optional.of(byteCode);
            }
        }
        catch (Exception e) {
            String msg = "Could not process %s to install source information: %s";
            log.error((Object)String.format(msg, ctx.getFile().getFullPath().toString(), e.getMessage()), (Throwable)e);
        }
        return no_change;
    }

    public void buildFinished(IJavaProject project) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"DebugSourceInstallingCompilationParticipant.install");
        try {
            task.start();
            super.buildFinished(project);
            if (DebugSourceInstallingCompilationParticipant.isJdtCoreGreaterOrEqual(VERSION_3_34_0)) {
                return;
            }
            if (this.files == null) {
                return;
            }
            for (BuildContext ctx : this.files) {
                try {
                    IJavaElement element;
                    SourceRelativeURI dslSourceFile;
                    OutputConfiguration outputConfiguration;
                    AbstractTraceRegion rootTraceRegion;
                    IFile generatedJavaFile = ctx.getFile();
                    IEclipseTrace traceToSource = (IEclipseTrace)this.traceInformation.getTraceToSource((Object)generatedJavaFile);
                    if (traceToSource == null || (rootTraceRegion = this.findRootTraceRegion((ITrace)traceToSource)) == null || (outputConfiguration = this.findOutputConfiguration(dslSourceFile = rootTraceRegion.getAssociatedSrcRelativePath(), generatedJavaFile)) == null || (element = JavaCore.create((IFile)generatedJavaFile)) == null) continue;
                    this.deleteTaskMarkers(generatedJavaFile);
                    this.markerReflector.reflectErrorMarkerInSource(generatedJavaFile, traceToSource);
                    ITraceToBytecodeInstaller installer = this.getInstaller(outputConfiguration);
                    installer.setTrace(generatedJavaFile.getName(), rootTraceRegion);
                    for (IFile javaClassFile : this.findGeneratedJavaClassFiles(element)) {
                        try (InputStream contents = javaClassFile.getContents();){
                            byte[] byteCode = installer.installTrace(ByteStreams.toByteArray((InputStream)contents));
                            if (byteCode != null) {
                                javaClassFile.setContents((InputStream)new ByteArrayInputStream(byteCode), 0, null);
                                continue;
                            }
                            javaClassFile.touch(null);
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Could not process %s to install source information: %s";
                    log.error((Object)String.format(msg, ctx.getFile().getFullPath().toString(), e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            this.files = null;
            task.stop();
        }
    }

    protected void deleteTaskMarkers(IFile generatedJavaFile) throws CoreException {
        generatedJavaFile.deleteMarkers("org.eclipse.jdt.core.task", false, 0);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        if (!DebugSourceInstallingCompilationParticipant.isJdtCoreGreaterOrEqual(VERSION_3_34_0)) {
            if (this.files != null) {
                this.files.addAll(Arrays.asList(files));
            } else {
                this.files = Lists.newArrayList((Object[])files);
            }
        }
    }

    protected List<IFile> findGeneratedJavaClassFiles(IJavaElement element) {
        IRegion region = JavaCore.newRegion();
        region.add(element);
        LinkedList result = Lists.newLinkedList();
        IResource[] iResourceArray = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                result.add((IFile)res);
            }
            ++n2;
        }
        return result;
    }

    protected AbstractTraceRegion findRootTraceRegion(ITrace traceToSource) {
        if (!(traceToSource instanceof AbstractEclipseTrace)) {
            return null;
        }
        return ((AbstractEclipseTrace)traceToSource).getRootTraceRegion();
    }

    public boolean isActive(IJavaProject project) {
        return XtextProjectHelper.hasNature((IProject)project.getProject());
    }

    private static boolean isJdtCoreGreaterOrEqual(Version version) {
        if (installedJdtCoreVersion == null) {
            installedJdtCoreVersion = JavaCore.getPlugin().getBundle().getVersion();
        }
        return installedJdtCoreVersion.compareTo(version) >= 0;
    }
}

