/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.inject.Inject;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.binary.asm.JvmDeclaredTypeBuilder;
import org.eclipse.xtext.common.types.descriptions.EObjectDescriptionBasedStubGenerator;
import org.eclipse.xtext.java.resource.ClassFileCache;
import org.eclipse.xtext.java.resource.InMemoryClassLoader;
import org.eclipse.xtext.java.resource.IndexAwareNameEnvironment;
import org.eclipse.xtext.java.resource.JavaConfig;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaDerivedStateComputer {
    private static final Logger LOG = Logger.getLogger(JavaDerivedStateComputer.class);
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private EObjectDescriptionBasedStubGenerator stubGenerator;
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;
    private static final MethodHandle INLINE_JSR_BYTECODE = JavaDerivedStateComputer.findInlineJsrBytecode();
    private static final MethodHandle ORIGINAL_SOURCE_LEVEL = JavaDerivedStateComputer.findOriginalSourceLevel();
    private static final MethodHandle ORIGINAL_COMPLIANCE_LEVEL = JavaDerivedStateComputer.findOriginalComplianceLevel();

    public void discardDerivedState(Resource resource) {
        EList resourcesContentsList = resource.getContents();
        for (EObject eObject : resourcesContentsList) {
            this.unloader.unloadRoot(eObject);
        }
        resourcesContentsList.clear();
        if (this.isInfoFile(resource)) {
            return;
        }
        if (this.getCompilationUnit(resource) != null) {
            ClassFileCache classFileCache = this.findOrCreateClassFileCache(resource.getResourceSet());
            classFileCache.addResourceToCompile(resource);
        }
    }

    public void installStubs(Resource resource) {
        if (this.isInfoFile(resource)) {
            return;
        }
        CompilationUnit compilationUnit = this.getCompilationUnit(resource);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.getCompilerOptions(resource), (IProblemFactory)new DefaultProblemFactory());
        Parser parser = new Parser(problemReporter, true);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)compilationUnit, 0, 1, -1);
        CompilationUnitDeclaration result = parser.dietParse((ICompilationUnit)compilationUnit, compilationResult);
        if (result.types != null) {
            TypeDeclaration[] typeDeclarationArray = result.types;
            int n = result.types.length;
            int n2 = 0;
            while (n2 < n) {
                char[][] importName;
                TypeDeclaration type = typeDeclarationArray[n2];
                ImportReference currentPackage = result.currentPackage;
                String packageName = null;
                if (currentPackage != null && (importName = currentPackage.getImportName()) != null) {
                    packageName = CharOperation.toString((char[][])importName);
                }
                JvmDeclaredType jvmType = this.createType(type, packageName);
                resource.getContents().add((Object)jvmType);
                ++n2;
            }
        }
    }

    public JvmDeclaredType createType(TypeDeclaration type, String packageName) {
        int n;
        int n2;
        TypeParameter[] typeParameterArray;
        JvmGenericType jvmType = null;
        switch (TypeDeclaration.kind((int)type.modifiers)) {
            case 1: {
                jvmType = TypesFactory.eINSTANCE.createJvmGenericType();
                break;
            }
            case 2: {
                jvmType = TypesFactory.eINSTANCE.createJvmGenericType();
                jvmType.setInterface(true);
                break;
            }
            case 3: {
                jvmType = TypesFactory.eINSTANCE.createJvmEnumerationType();
                break;
            }
            case 4: {
                jvmType = TypesFactory.eINSTANCE.createJvmAnnotationType();
                break;
            }
            case 5: {
                jvmType = TypesFactory.eINSTANCE.createJvmGenericType();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle type " + type.toString());
            }
        }
        jvmType.setPackageName(packageName);
        jvmType.setSimpleName(String.valueOf(type.name));
        if (jvmType instanceof JvmGenericType && type.typeParameters != null) {
            typeParameterArray = type.typeParameters;
            n2 = type.typeParameters.length;
            n = 0;
            while (n < n2) {
                TypeParameter typeParam = typeParameterArray[n];
                JvmTypeParameter jvmTypeParam = TypesFactory.eINSTANCE.createJvmTypeParameter();
                jvmTypeParam.setName(String.valueOf(typeParam.name));
                jvmType.getTypeParameters().add((Object)jvmTypeParam);
                ++n;
            }
        }
        if (type.memberTypes != null) {
            typeParameterArray = type.memberTypes;
            n2 = type.memberTypes.length;
            n = 0;
            while (n < n2) {
                TypeParameter nestedType = typeParameterArray[n];
                JvmDeclaredType nested = this.createType((TypeDeclaration)nestedType, null);
                jvmType.getMembers().add((Object)nested);
                ++n;
            }
        }
        return jvmType;
    }

    public CompilationUnit getCompilationUnit(Resource resource) {
        return ((JavaResource)resource).getCompilationUnit();
    }

    protected ClassFileCache findOrCreateClassFileCache(ResourceSet rs) {
        ClassFileCache cache = ClassFileCache.findInEmfObject((Notifier)rs);
        if (cache == null) {
            cache = new ClassFileCache();
            cache.attachToEmfObject((Notifier)rs);
        }
        return cache;
    }

    public void installFull(Resource resource) {
        if (this.isInfoFile(resource)) {
            return;
        }
        final ClassFileCache classFileCache = this.findOrCreateClassFileCache(resource.getResourceSet());
        final CompilationUnit compilationUnit = this.getCompilationUnit(resource);
        ClassLoader classLoader = this.getClassLoader(resource);
        IResourceDescriptions data = this.resourceDescriptionsProvider.getResourceDescriptions(resource.getResourceSet());
        if (data == null) {
            throw new IllegalStateException("No index installed");
        }
        final Procedures.Procedure2 initializer = (topLevelTypes, classMap) -> {
            InMemoryClassLoader inMemClassLoader = new InMemoryClassLoader((Map<String, byte[]>)classMap, classLoader);
            for (String topLevel : topLevelTypes) {
                try {
                    BinaryClass binaryClass = new BinaryClass(topLevel, (ClassLoader)inMemClassLoader);
                    ClassFileBytesAccess classFileBytesAccess = new ClassFileBytesAccess();
                    JvmDeclaredTypeBuilder builder = new JvmDeclaredTypeBuilder(binaryClass, classFileBytesAccess, (ClassLoader)inMemClassLoader);
                    JvmDeclaredType type = builder.buildType();
                    resource.getContents().add((Object)type);
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Could not load type '" + topLevel + "'", t);
                }
            }
        };
        boolean wasCached = classFileCache.popCompileResult(compilationUnit.fileName, (Procedures.Procedure2<? super List<String>, ? super Map<String, byte[]>>)initializer);
        if (!wasCached) {
            Set<ICompilationUnit> unitsToCompile = classFileCache.drainResourcesToCompile().stream().map(r -> this.getCompilationUnit((Resource)r)).collect(Collectors.toSet());
            unitsToCompile.add((ICompilationUnit)compilationUnit);
            IndexAwareNameEnvironment nameEnv = new IndexAwareNameEnvironment(resource, classLoader, data, this.stubGenerator, classFileCache);
            ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

                public void acceptResult(CompilationResult result) {
                    ClassFile[] classFileArray = result.getClassFiles();
                    int n = classFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassFile cls = classFileArray[n2];
                        QualifiedName key = QualifiedName.create((String[])CharOperation.toStrings((char[][])cls.getCompoundName()));
                        classFileCache.computeIfAbsent(key, name -> {
                            try {
                                return new ClassFileReader(cls.getBytes(), cls.fileName());
                            }
                            catch (Throwable e) {
                                throw Exceptions.sneakyThrow((Throwable)e);
                            }
                        });
                        ++n2;
                    }
                    HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                    ArrayList<String> topLevelTypes = new ArrayList<String>();
                    ClassFile[] classFileArray2 = result.getClassFiles();
                    int n3 = classFileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassFile cf = classFileArray2[n4];
                        String className = CharOperation.toString((char[][])cf.getCompoundName());
                        map.put(className, cf.getBytes());
                        if (!cf.isNestedType) {
                            topLevelTypes.add(className);
                        }
                        ++n4;
                    }
                    if (Arrays.equals(result.fileName, compilationUnit.fileName)) {
                        initializer.apply(topLevelTypes, map);
                    } else {
                        classFileCache.addCompileResult(result.fileName, topLevelTypes, map);
                    }
                }
            };
            DefaultProblemFactory problemFactory = new DefaultProblemFactory();
            Compiler compiler = new Compiler((INameEnvironment)nameEnv, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.getCompilerOptions(resource), compilerRequestor, (IProblemFactory)problemFactory);
            compiler.compile(unitsToCompile.toArray(new ICompilationUnit[0]));
        }
    }

    protected boolean isInfoFile(Resource resource) {
        String name = resource.getURI().trimFileExtension().lastSegment();
        return "package-info".equals(name) || "module-info".equals(name);
    }

    protected CompilerOptions getCompilerOptions() {
        return this.getCompilerOptions((JavaConfig)null);
    }

    protected CompilerOptions getCompilerOptions(Resource resource) {
        ResourceSet resourceSet;
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            return this.getCompilerOptions(resourceSet);
        }
        return null;
    }

    protected CompilerOptions getCompilerOptions(ResourceSet resourceSet) {
        return this.getCompilerOptions(JavaConfig.findInEmfObject((Notifier)resourceSet));
    }

    protected CompilerOptions getCompilerOptions(JavaConfig javaConfig) {
        JavaVersion sourceVersion = JavaVersion.JAVA8;
        JavaVersion targetVersion = JavaVersion.JAVA8;
        if (javaConfig != null) {
            if (javaConfig.getJavaSourceLevel() != null) {
                sourceVersion = javaConfig.getJavaSourceLevel();
            }
            if (javaConfig.getJavaTargetLevel() != null) {
                targetVersion = javaConfig.getJavaTargetLevel();
            }
        }
        if (JavaVersion.JAVA7.equals((Object)sourceVersion)) {
            LOG.warn((Object)"The java source language has been configured with Java 7. JDT will not produce signature information for generic @Override methods in this version, which might lead to follow up issues.");
        }
        long sourceLevel = this.toJdtVersion(sourceVersion);
        long targetLevel = this.toJdtVersion(targetVersion);
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.targetJDK = targetLevel;
        compilerOptions.sourceLevel = sourceLevel;
        compilerOptions.produceMethodParameters = true;
        compilerOptions.produceReferenceInfo = true;
        compilerOptions.complianceLevel = sourceLevel;
        if (ORIGINAL_SOURCE_LEVEL != null) {
            try {
                ORIGINAL_SOURCE_LEVEL.invoke(compilerOptions, targetLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ORIGINAL_COMPLIANCE_LEVEL != null) {
            try {
                ORIGINAL_COMPLIANCE_LEVEL.invoke(compilerOptions, targetLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (INLINE_JSR_BYTECODE != null) {
            try {
                INLINE_JSR_BYTECODE.invoke(compilerOptions, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return compilerOptions;
    }

    private static MethodHandle findInlineJsrBytecode() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "inlineJsrBytecode", Boolean.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle findOriginalSourceLevel() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "originalSourceLevel", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle findOriginalComplianceLevel() {
        try {
            return MethodHandles.lookup().findSetter(CompilerOptions.class, "originalComplianceLevel", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected long toJdtVersion(JavaVersion version) {
        return version.toJdtClassFileConstant();
    }

    protected ClassLoader getClassLoader(Resource it) {
        ResourceSet resourceSet = it.getResourceSet();
        return (ClassLoader)((XtextResourceSet)resourceSet).getClasspathURIContext();
    }
}

