/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.editor.hierarchy.DeferredHierarchyBuilder;
import org.eclipse.xtext.ui.editor.hierarchy.HierarchyLabelProvider;
import org.eclipse.xtext.ui.editor.hierarchy.XtextCallHierarchyNode;

public class XtextCallHierarchyLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    @Inject
    private HierarchyLabelProvider hierarchyLabelProvider;

    public Image getImage(Object element) {
        return this.hierarchyLabelProvider.getImage(element);
    }

    public String getText(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        if (obj instanceof XtextCallHierarchyNode) {
            return this._getText((XtextCallHierarchyNode)((Object)obj));
        }
        if (obj instanceof DeferredHierarchyBuilder.DeferredHierarchyNode) {
            return this._getText((DeferredHierarchyBuilder.DeferredHierarchyNode)obj);
        }
        return this._getText(obj);
    }

    protected String _getText(Object element) {
        return this.hierarchyLabelProvider.getText(element);
    }

    protected String _getText(DeferredHierarchyBuilder.DeferredHierarchyNode hierarchyNode) {
        return this.getText(hierarchyNode.getDelegate());
    }

    protected String _getText(XtextCallHierarchyNode hierarchyNode) {
        if (hierarchyNode.getElement() == null) {
            return this.hierarchyLabelProvider.getText((Object)hierarchyNode);
        }
        List<QualifiedName> qualifiedNames = Arrays.asList(hierarchyNode.getElement().getQualifiedName(), hierarchyNode.getGrammarDescription() != null ? hierarchyNode.getGrammarDescription().getQualifiedName() : null);
        return Joiner.on((String)" - ").join(Iterables.filter(qualifiedNames, Objects::nonNull));
    }

    public StyledString getStyledText(Object obj) {
        Preconditions.checkNotNull((Object)obj);
        if (obj instanceof XtextCallHierarchyNode) {
            return this._getStyledText((XtextCallHierarchyNode)((Object)obj));
        }
        if (obj instanceof DeferredHierarchyBuilder.DeferredHierarchyNode) {
            return this._getStyledText((DeferredHierarchyBuilder.DeferredHierarchyNode)obj);
        }
        return this._getStyledText(obj);
    }

    protected StyledString _getStyledText(Object element) {
        return this.hierarchyLabelProvider.getStyledText(element);
    }

    protected StyledString _getStyledText(DeferredHierarchyBuilder.DeferredHierarchyNode hierarchyNode) {
        return this.getStyledText(hierarchyNode.getDelegate());
    }

    protected StyledString _getStyledText(XtextCallHierarchyNode hierarchyNode) {
        if (hierarchyNode.getElement() == null) {
            return this.hierarchyLabelProvider.getStyledText((Object)hierarchyNode);
        }
        StyledString styledString = new StyledString(String.valueOf(hierarchyNode.getElement().getQualifiedName()));
        if (hierarchyNode.getGrammarDescription() == null) {
            return styledString;
        }
        return styledString.append(new StyledString(" - " + String.valueOf(hierarchyNode.getGrammarDescription().getQualifiedName()), StyledString.QUALIFIER_STYLER));
    }
}

