/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;

public class DeprecationUtil {
    public static boolean isDeprecated(JvmAnnotationTarget jvmAnnotationTarget) {
        if (jvmAnnotationTarget instanceof JvmMember) {
            return DeprecationUtil.isDeprecatedMember((JvmMember)jvmAnnotationTarget);
        }
        return false;
    }

    public static boolean isTransitivelyDeprecated(JvmAnnotationTarget jvmAnnotationTarget) {
        if (jvmAnnotationTarget instanceof JvmMember) {
            return DeprecationUtil.isTransitivelyDeprecatedMember((JvmMember)jvmAnnotationTarget);
        }
        return false;
    }

    public static boolean isDeprecatedAnnotation(JvmAnnotationType jvmAnnotationType) {
        return !jvmAnnotationType.eIsProxy() && Deprecated.class.getName().equals(jvmAnnotationType.getIdentifier());
    }

    public static boolean isDeprecated(JvmType type) {
        if (type instanceof JvmMember) {
            return DeprecationUtil.isDeprecatedMember((JvmMember)((Object)type));
        }
        return false;
    }

    public static boolean isDeprecatedMember(JvmMember member) {
        if (member.isSetDeprecated()) {
            return member.isDeprecated();
        }
        EList<JvmAnnotationReference> annotations = member.getAnnotations();
        for (JvmAnnotationReference annotation : annotations) {
            JvmAnnotationType annotationType = annotation.getAnnotation();
            if (annotationType == null || !Deprecated.class.getName().equals(annotationType.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransitivelyDeprecatedMember(JvmMember member) {
        JvmMember container = member;
        while (container instanceof JvmMember) {
            if (DeprecationUtil.isDeprecatedMember(container)) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }
}

